/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestEditProject
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEditProject.xml");
    }

    public void testProjectDoesNotExistAdmin() throws Exception {
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    public void testProjectDoesNotExistNonAdmin() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("You must log in to access this page.");
        this.navigation.login("gandhi");
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertTextNotPresent("You cannot view this URL as a guest.");
    }

    public void testEditProjectSuccess() {
        ProjectClient pc = new ProjectClient(this.environmentData);
        Project dog = pc.get("DOG");
        TestEditProject.assertEquals((String)"DOG", (String)dog.key);
        TestEditProject.assertEquals((String)"Canine", (String)dog.name);
        TestEditProject.assertEquals(null, (String)dog.description);
        TestEditProject.assertEquals(null, (String)dog.url);
        TestEditProject.assertEquals((String)"murray", (String)dog.lead.name);
        TestEditProject.assertEquals((Object)((Object)Project.AssigneeType.PROJECT_LEAD), (Object)((Object)dog.assigneeType));
        this.tester.gotoPage("/plugins/servlet/project-config/" + dog.key + "/summary");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Dogs");
        this.tester.setFormElement("url", "http://www.dogs.com");
        this.tester.setFormElement("description", "This is the dog project.");
        this.tester.submit("Update");
        this.assertions.assertNodeByIdHasText("project-config-header-name", "Dogs");
        Project newDog = pc.get("DOG");
        TestEditProject.assertEquals((String)"DOG", (String)newDog.key);
        TestEditProject.assertEquals((String)"Dogs", (String)newDog.name);
        TestEditProject.assertEquals((String)"This is the dog project.", (String)newDog.description);
        TestEditProject.assertEquals((String)"http://www.dogs.com", (String)newDog.url);
        TestEditProject.assertEquals((String)"murray", (String)newDog.lead.name);
        TestEditProject.assertEquals((Object)((Object)Project.AssigneeType.PROJECT_LEAD), (Object)((Object)newDog.assigneeType));
    }

    public void testEditProjectNameExists() {
        this.tester.gotoPage("/plugins/servlet/project-config/DOG/summary");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Bovine");
        this.tester.submit("Update");
        this.tester.assertTextPresent("A project with that name already exists.");
    }

    public void testEditProjectValidation() {
        this.tester.gotoPage("/plugins/servlet/project-config/DOG/summary");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("url", "badURL");
        this.tester.submit("Update");
        this.tester.assertTextPresent("You must specify a valid project name.");
        this.tester.assertTextPresent("The URL specified is not valid - it must start with http://");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("url", "badURL");
        this.tester.submit("Update");
    }

    public void testEditProjectNoAccess() {
        this.navigation.logout();
        this.navigation.login("cow", "cow");
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10020&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Welcome to Dev JIRA");
        this.tester.assertTextNotPresent("Edit Project: Canine");
        this.tester.assertTextNotPresent("Use this page to update your project details.");
    }

    public void testEditProjectDoesntExist() {
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10025&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    public void testEditProjectChangeNothing() {
        this.tester.gotoPage("/plugins/servlet/project-config/DOG/summary");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", "Canine");
        this.tester.setFormElement("url", "");
        this.tester.setFormElement("description", "");
        this.tester.submit("Update");
        ProjectClient pc = new ProjectClient(this.environmentData);
        Project dog = pc.get("DOG");
        TestEditProject.assertEquals((String)"DOG", (String)dog.key);
        TestEditProject.assertEquals((String)"Canine", (String)dog.name);
        TestEditProject.assertEquals(null, (String)dog.description);
        TestEditProject.assertEquals(null, (String)dog.url);
        TestEditProject.assertEquals((String)"murray", (String)dog.lead.name);
        TestEditProject.assertEquals((Object)((Object)Project.AssigneeType.PROJECT_LEAD), (Object)((Object)dog.assigneeType));
    }

    public void testEditWithFieldsExceedingLimits() throws Exception {
        ProjectClient pc = new ProjectClient(this.environmentData);
        Project dog = pc.get("DOG");
        TestEditProject.assertEquals((String)"DOG", (String)dog.key);
        TestEditProject.assertEquals((String)"Canine", (String)dog.name);
        TestEditProject.assertEquals(null, (String)dog.description);
        TestEditProject.assertEquals(null, (String)dog.url);
        TestEditProject.assertEquals((String)"murray", (String)dog.lead.name);
        TestEditProject.assertEquals((Object)((Object)Project.AssigneeType.PROJECT_LEAD), (Object)((Object)dog.assigneeType));
        this.tester.gotoPage("/plugins/servlet/project-config/DOG/summary");
        this.tester.clickLink("edit_project");
        this.tester.assertTextPresent("Edit Project: Canine");
        this.tester.setFormElement("name", StringUtils.repeat((String)"N", (int)151));
        this.tester.setFormElement("url", StringUtils.repeat((String)"U", (int)256));
        this.tester.submit("Update");
        this.tester.assertTextPresent("The project name must not exceed 150 characters in length");
        this.tester.assertTextPresent("The URL must not exceed 255 characters in length");
    }

    public void testEditProjectWithoutBrowseProjectPermission() throws Exception {
        this.tester.gotoPage("/plugins/servlet/project-config/VG/summary");
        this.tester.clickLink("edit_project");
        this.tester.setFormElement("name", "Vegans");
        this.tester.submit("Update");
        ProjectClient pc = new ProjectClient(this.environmentData);
        Project dog = pc.get("VG");
        TestEditProject.assertEquals((String)"VG", (String)dog.key);
        TestEditProject.assertEquals((String)"Vegans", (String)dog.name);
    }
}

