/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSE_PROJECT, Category.COMPONENTS_AND_VERSIONS})
public class TestBrowseVersionsAndComponents
extends JIRAWebTest {
    private static final String VIEW_RESOLVED_ISSUES_LINK = "Resolved";
    private static final String VIEW_UNRESOLVED_ISSUES_LINK = "Unresolved";
    private static final String POPULAR_ISSUES_LINK = "Popular Issues";

    public TestBrowseVersionsAndComponents(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestProjectVersionsAndComponentsTabPanel.xml");
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testBrowseComponentsPopularIssuesPanel() {
        this.gotoComponentBrowse("NDT", "New Component 1");
        this.clickLinkWithText(POPULAR_ISSUES_LINK);
        this.clickToScope(VIEW_UNRESOLVED_ISSUES_LINK);
        this.assertNoPopularIssues();
        this.clickToScope(VIEW_RESOLVED_ISSUES_LINK);
        this.assertNoPopularIssues();
        this.gotoComponentBrowse("HSP", "full component");
        this.clickLinkWithText(POPULAR_ISSUES_LINK);
        this.clickToScope(VIEW_UNRESOLVED_ISSUES_LINK);
        this.assertExpectedPopularIssues(false);
        this.clickToScope(VIEW_RESOLVED_ISSUES_LINK);
        this.assertExpectedPopularIssuesResolved(false);
    }

    public void testBrowseVersionPopularIssuesPanel() {
        this.gotoVersionBrowse("NDT", "New Version 1");
        this.clickLinkWithText(POPULAR_ISSUES_LINK);
        this.clickToScope(VIEW_UNRESOLVED_ISSUES_LINK);
        this.assertNoPopularIssues();
        this.clickToScope(VIEW_RESOLVED_ISSUES_LINK);
        this.assertNoPopularIssues();
        this.gotoVersionBrowse("HSP", "full version");
        this.clickLinkWithText(POPULAR_ISSUES_LINK);
        this.clickToScope(VIEW_UNRESOLVED_ISSUES_LINK);
        this.assertExpectedPopularIssues(true);
        this.clickToScope(VIEW_RESOLVED_ISSUES_LINK);
        this.assertExpectedPopularIssuesResolved(true);
    }

    private void assertNoPopularIssues() {
        try {
            WebTable componentsTable = this.getDialog().getResponse().getTableWithID("popular_issues_table");
            TestBrowseVersionsAndComponents.assertEquals((int)1, (int)componentsTable.getRowCount());
            this.assertTableHasMatchingRow(componentsTable, new Object[]{"No issues"});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertExpectedPopularIssues(boolean isVersion) {
        try {
            WebTable componentsTable = this.getDialog().getResponse().getTableWithID("popular_issues_table");
            TestBrowseVersionsAndComponents.assertEquals((int)3, (int)componentsTable.getRowCount());
            if (isVersion) {
                this.assertTableHasMatchingRow(componentsTable, new Object[]{"3", new ImageCell("/images/icons/bug.gif"), "HSP-5", new LinkCell("/browse/HSP-5", "hsp bug 1"), "full version", new ImageCell("/images/icons/priority_blocker.gif"), new ImageCell("/images/icons/status_open.gif")});
            } else {
                this.assertTableHasMatchingRow(componentsTable, new Object[]{"3", new ImageCell("/images/icons/bug.gif"), "HSP-5", new LinkCell("/browse/HSP-5", "hsp bug 1"), new LinkCell("/browse/HSP/fixforversion/10000", "full version"), new ImageCell("/images/icons/priority_blocker.gif"), new ImageCell("/images/icons/status_open.gif")});
            }
            this.assertTableHasMatchingRow(componentsTable, new Object[]{"2", new ImageCell("/images/icons/improvement.gif"), "HSP-4", new LinkCell("/browse/HSP-4", "hsp improvement 2"), new LinkCell("/browse/HSP/fixforversion/10001", "desc version"), new ImageCell("/images/icons/priority_critical.gif"), new ImageCell("/images/icons/status_inprogress.gif")});
            this.assertTableHasMatchingRow(componentsTable, new Object[]{"1", new ImageCell("/images/icons/task.gif"), "HSP-3", new LinkCell("/browse/HSP-3", "hsp task 3"), new LinkCell("/browse/HSP/fixforversion/10002", "date version"), new ImageCell("/images/icons/priority_major.gif"), new ImageCell("/images/icons/status_open.gif")});
            this.assertTableHasNoMatchingRow(componentsTable, new Object[]{null, new ImageCell("/images/icons/newfeature.gif"), "HSP-2", new LinkCell("/browse/HSP-2", "hsp feature 4"), null, new ImageCell("/images/icons/priority_minor.gif"), new ImageCell("/images/icons/status_inprogress.gif")});
            this.assertTableHasNoMatchingRow(componentsTable, new Object[]{null, new ImageCell("/images/icons/bug.gif"), "HSP-1", new LinkCell("/browse/HSP-1", "hsp bug 5"), null, new ImageCell("/images/icons/priority_trivial.gif"), new ImageCell("/images/icons/status_open.gif")});
            this.assertTableHasNoMatchingRow(componentsTable, new Object[]{null, new ImageCell("/images/icons/task.gif"), "HSP-6", new LinkCell("/browse/HSP-6", "hsp resolved bug 1"), null, new ImageCell("/images/icons/priority_major.gif"), new ImageCell("/images/icons/status_resolved.gif")});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertExpectedPopularIssuesResolved(boolean isVersion) {
        try {
            WebTable componentsTable = this.getDialog().getResponse().getTableWithID("popular_issues_table");
            TestBrowseVersionsAndComponents.assertEquals((int)1, (int)componentsTable.getRowCount());
            if (isVersion) {
                this.assertTableHasMatchingRow(componentsTable, new Object[]{"1", new ImageCell("/images/icons/task.gif"), "HSP-6", new LinkCell("/browse/HSP-6", "hsp resolved bug 1"), "full version", new ImageCell("/images/icons/priority_major.gif"), new ImageCell("/images/icons/status_resolved.gif")});
            } else {
                this.assertTableHasMatchingRow(componentsTable, new Object[]{"1", new ImageCell("/images/icons/task.gif"), "HSP-6", new LinkCell("/browse/HSP-6", "hsp resolved bug 1"), new LinkCell("/browse/HSP/fixforversion/10000", "full version"), new ImageCell("/images/icons/priority_major.gif"), new ImageCell("/images/icons/status_resolved.gif")});
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void clickToScope(String scope) {
        try {
            this.assertLinkPresentWithText(scope);
            this.clickLinkWithText(scope);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

