/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSE_PROJECT})
public class TestBrowseProjectSummaryScreen
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestBrowseProjectSummaryTab.xml");
    }

    public void testProjectDescriptionFrag() {
        this.navigation.login("admin");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragprojectdescription']");
        this.assertNodeHasText("//div[@id='fragprojectdescription']//h3", "Description");
        this.text.assertTextPresent(new IdLocator(this.tester, "pd-url"), "http://www.atlassian.com");
        this.text.assertTextPresent(new IdLocator(this.tester, "project_summary_admin"), "Administrator");
        this.text.assertTextPresent(new IdLocator(this.tester, "pd-key"), "NODESC");
        TestBrowseProjectSummaryScreen.assertEquals((int)0, (int)new IdLocator(this.tester, "pd-desc").getNodes().length);
        this.navigation.browseProject("NOURL");
        this.assertNodeExists("//div[@id='fragprojectdescription']");
        this.assertNodeHasText("//div[@id='fragprojectdescription']//h3", "Description");
        this.text.assertTextPresent(new IdLocator(this.tester, "project_summary_admin"), "Administrator");
        this.text.assertTextPresent(new IdLocator(this.tester, "pd-key"), "NOURL");
        this.text.assertTextPresent(new IdLocator(this.tester, "pd-desc"), "This is a description");
    }

    public void testDueIssuesFrag() {
        this.navigation.login("admin");
        this.navigation.browseProject("NODESC");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='fragdueissues']");
        TestBrowseProjectSummaryScreen.assertFalse((boolean)locator.exists());
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 1");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 2");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 3");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 4");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 5");
        this.resolveIssue("NODESC-1");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragdueissues']");
        this.assertNodeHasText("//div[@id='fragdueissues']//h3", "Issues: Due");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[1]", "NODESC-2");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[2]", "NODESC-3");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[3]", "NODESC-4");
        this.navigation.issue().gotoEditIssue("NODESC-5");
        this.tester.setFormElement("duedate", "9/Feb/09");
        this.tester.submit("Update");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragdueissues']");
        this.assertNodeHasText("//div[@id='fragdueissues']//h3", "Issues: Due");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[1]", "NODESC-5");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[2]", "NODESC-2");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[3]", "NODESC-3");
        this.navigation.issue().gotoEditIssue("NODESC-4");
        this.tester.setFormElement("priority", "1");
        this.tester.submit("Update");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragdueissues']");
        this.assertNodeHasText("//div[@id='fragdueissues']//h3", "Issues: Due");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[1]", "NODESC-5");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[2]", "NODESC-4");
        this.assertNodeHasText("//div[@id='fragdueissues']//ul/li[3]", "NODESC-2");
        this.resolveIssue("NODESC-2");
        this.resolveIssue("NODESC-3");
        this.resolveIssue("NODESC-4");
        this.resolveIssue("NODESC-5");
        this.navigation.browseProject("DUEDATEHIDDEN");
        this.navigation.browseProject("NODESC");
        this.assertNodeDoesNotExists("//div[@id='fragdueissues']");
        this.assertNodeDoesNotExists("//div[@id='fragdueissues']");
    }

    private void resolveIssue(String key) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Resolve Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    public void testCreatedVsResolvedFrag() {
        this.navigation.login("admin");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragcreatedvsresolved']");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='fragcreatedvsresolved']/div");
        TestBrowseProjectSummaryScreen.assertTrue((boolean)locator.exists());
        this.text.assertTextSequence(locator, "Issues:", "0", "created and", "0", "resolved");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 1");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 2");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 3");
        this.navigation.issue().createIssue("No Description", "Bug", "Summary 4");
        this.resolveIssue("NODESC-1");
        this.navigation.browseProject("NODESC");
        this.assertNodeExists("//div[@id='fragcreatedvsresolved']");
        locator = new XPathLocator(this.tester, "//div[@id='fragcreatedvsresolved']/div");
        TestBrowseProjectSummaryScreen.assertTrue((boolean)locator.exists());
        this.text.assertTextSequence(locator, "Issues:", "4", "created and", "1", "resolved");
    }

    public void assertNodeHasText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        TestBrowseProjectSummaryScreen.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, textToTest);
    }

    public void assertNodeDoesNotHaveText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        TestBrowseProjectSummaryScreen.assertTrue((boolean)locator.exists());
        this.text.assertTextNotPresent(locator, textToTest);
    }

    public void assertNodeExists(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        TestBrowseProjectSummaryScreen.assertTrue((boolean)locator.exists());
    }

    public void assertNodeDoesNotExists(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        TestBrowseProjectSummaryScreen.assertFalse((boolean)locator.exists());
    }
}

