/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable.enabling;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN})
public class TestPortletModuleEnabling
extends AbstractReloadablePluginsTest {
    public void testPortletShouldNotBeAvailableGivenReferencePluginDisabled() throws Exception {
        this.runPortlet(ReferencePluginConstants.REFERENCE_PORTLET_KEY);
        this.text.assertTextPresent("A gadget with the key " + ReferencePluginConstants.REFERENCE_PORTLET_KEY + " does not exist.");
    }

    public void testPortletShouldBeAvailableGivenReferencePluginEnabled() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.runPortlet(ReferencePluginConstants.REFERENCE_PORTLET_KEY);
        this.text.assertTextPresent(this.locator.id("userinfo"), "Current logged in user: Administrator");
    }

    private void runPortlet(String portletKey) {
        this.tester.gotoPage("/RunPortlet.jspa?portletKey=" + portletKey);
    }
}

