/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable.enabling;

import com.atlassian.jira.functest.framework.admin.plugins.ReferenceDependentPlugin;
import com.atlassian.jira.functest.framework.admin.plugins.ReferencePlugin;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN})
public class TestModuleTypeModuleEnabling
extends AbstractReloadablePluginsTest {
    private ReferencePlugin referencePlugin;
    private ReferenceDependentPlugin referenceDependentPlugin;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.referencePlugin = this.administration.plugins().referencePlugin();
        this.referenceDependentPlugin = this.administration.plugins().referenceDependentPlugin();
    }

    public void testShouldNotDisplayModuleTypeActionContentsGivenReferencePluginDisabled() {
        this.assertNoModuleImplementationAvailable();
    }

    public void testShouldDisplayInternalImplementationGivenReferencePluginOnlyEnabled() {
        this.administration.plugins().referencePlugin().enable();
        this.assertReferenceModuleImplementationsAvailable();
    }

    public void testShouldDisplayInternalAndExternalImplementationGivenReferencePluginAndReferenceDependentPluginEnabled() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.assertAllModuleImplementationAvailable();
    }

    public void testShouldDisplayExternalImplementationGivenReferenceDependentPluginDisabledAndEnabledAgain() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.assertAllModuleImplementationAvailable();
        this.administration.plugins().referenceDependentPlugin().disable();
        this.assertReferenceModuleImplementationsAvailable();
        this.assertReferenceDependentModuleImplementationsNotAvailable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.assertAllModuleImplementationAvailable();
    }

    public void testShouldNotDisplayAnyImplementationGivenReferencePluginDisabled() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.assertAllModuleImplementationAvailable();
        this.administration.plugins().referencePlugin().disable();
        this.assertNoModuleImplementationAvailable();
        this.administration.plugins().referencePlugin().enable();
        this.assertAllModuleImplementationAvailable();
    }

    public void testShouldDisplayOnlyEnabledImplementations() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.assertAllModuleImplementationAvailable();
        this.administration.plugins().referencePlugin().moduleType().internalWithI18n().disable();
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.administration.plugins().referencePlugin().moduleType().internalWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.administration.plugins().referencePlugin().moduleType().internalWithoutI18n().isAvailable());
        this.assertReferenceDependentModuleImplementationsAvailable();
        this.administration.plugins().referenceDependentPlugin().externalReferenceModuleWithI18n().disable();
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.administration.plugins().referencePlugin().moduleType().internalWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.administration.plugins().referencePlugin().moduleType().internalWithoutI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.administration.plugins().referenceDependentPlugin().externalReferenceModuleWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.administration.plugins().referenceDependentPlugin().externalReferenceModuleWithoutI18n().isAvailable());
    }

    private void assertAllModuleImplementationAvailable() {
        this.assertReferenceModuleImplementationsAvailable();
        this.assertReferenceDependentModuleImplementationsAvailable();
    }

    private void assertNoModuleImplementationAvailable() {
        this.assertReferenceModuleImplementationsNotAvailable();
        this.assertReferenceDependentModuleImplementationsNotAvailable();
    }

    private void assertReferenceModuleImplementationsAvailable() {
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.referencePlugin.moduleType().internalWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.referencePlugin.moduleType().internalWithoutI18n().isAvailable());
    }

    private void assertReferenceModuleImplementationsNotAvailable() {
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.referencePlugin.moduleType().internalWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.referencePlugin.moduleType().internalWithoutI18n().isAvailable());
    }

    private void assertReferenceDependentModuleImplementationsAvailable() {
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.referenceDependentPlugin.externalReferenceModuleWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertTrue((boolean)this.referenceDependentPlugin.externalReferenceModuleWithoutI18n().isAvailable());
    }

    private void assertReferenceDependentModuleImplementationsNotAvailable() {
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.referenceDependentPlugin.externalReferenceModuleWithI18n().isAvailable());
        TestModuleTypeModuleEnabling.assertFalse((boolean)this.referenceDependentPlugin.externalReferenceModuleWithoutI18n().isAvailable());
    }
}

