/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable.disabling;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN})
public class TestRestModuleTypeDisabling
extends AbstractReloadablePluginsTest {
    public void testShouldNotBeReachableAfterBeingDisabled() throws JSONException {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referencePlugin().restResources().endPoint().get();
        this.administration.plugins().referencePlugin().restResources().disable();
        TestRestModuleTypeDisabling.assertFalse((boolean)this.administration.plugins().referencePlugin().restResources().endPoint().isReachable());
    }

    public void testShouldNotBeReachableAfterDisablingTheReferencePlugin() throws JSONException {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referencePlugin().restResources().endPoint().get();
        this.administration.plugins().referencePlugin().disable();
        TestRestModuleTypeDisabling.assertFalse((boolean)this.administration.plugins().referencePlugin().restResources().endPoint().isReachable());
    }

    public void testShouldBeReachableAfterEnablingTheReferencePluginBackAgain() throws JSONException {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referencePlugin().restResources().endPoint().get();
        this.administration.plugins().referencePlugin().disable();
        this.administration.plugins().referencePlugin().enable();
        TestRestModuleTypeDisabling.assertTrue((boolean)this.administration.plugins().referencePlugin().restResources().endPoint().isReachable());
        JSONObject endpointJSONResponse = this.administration.plugins().referencePlugin().restResources().endPoint().get();
        TestRestModuleTypeDisabling.assertEquals((Object)endpointJSONResponse.get("endpoint"), (Object)false);
    }

    public void testShouldBeReachableAfterEnablingItBackAgain() throws JSONException {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referencePlugin().restResources().endPoint().get();
        this.administration.plugins().referencePlugin().restResources().disable();
        this.administration.plugins().referencePlugin().restResources().enable();
        TestRestModuleTypeDisabling.assertTrue((boolean)this.administration.plugins().referencePlugin().restResources().endPoint().isReachable());
        JSONObject endpointJSONResponse = this.administration.plugins().referencePlugin().restResources().endPoint().get();
        TestRestModuleTypeDisabling.assertEquals((Object)endpointJSONResponse.get("endpoint"), (Object)false);
    }
}

