/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.PLUGINS, Category.REFERENCE_PLUGIN})
public class TestWebWork1ActionModuleReloadability
extends AbstractReloadablePluginsTest {
    private static final String REFERENCE_ACTION_URI = "/ReferenceAction.jspa";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
    }

    public void testShouldNotExistAndBeAccessibleBeforeEnablingThePlugin() throws Exception {
        this.goToReferenceActionPage();
        this.assertActionNotAccessible();
    }

    public void testShouldBeReachableAfterEnablingTheReferencePlugin() {
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceActionPage();
        this.assertActionAccessible();
    }

    public void testActionShouldNotBeAccessibleAfterDisablingThePlugin() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceActionPage();
        this.assertActionAccessible();
        this.administration.plugins().referencePlugin().disable();
        this.goToReferenceActionPage();
        this.assertActionNotAccessible();
    }

    public void testActionShouldNotBeAccessibleAfterDisablingItsPluginModule() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        for (int i = 0; i < 3; ++i) {
            this.goToReferenceActionPage();
            this.assertActionAccessible();
            this.disableReferenceWebworkActionModule();
            this.goToReferenceActionPage();
            this.assertActionNotAccessible();
            this.enableReferenceWebworkActionModule();
        }
    }

    public void testActionShouldBeAccessibleAfterMultiplePluginDisablingAndEnabling() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceActionPage();
        this.assertActionAccessible();
        this.administration.plugins().referencePlugin().disable();
        this.goToReferenceActionPage();
        this.assertActionNotAccessible();
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceActionPage();
        this.assertActionAccessible();
    }

    private void assertActionAccessible() {
        this.text.assertTextPresent(this.locator.id("reference-action-message"), "Welcome to JIRA");
    }

    private void assertActionNotAccessible() {
        TestWebWork1ActionModuleReloadability.assertEquals((int)DisabledActionResponse.CODE, (int)this.tester.getDialog().getResponse().getResponseCode());
        this.text.assertTextNotPresent(this.locator.id("reference-action-message"), "Welcome to JIRA");
    }

    private void goToReferenceActionPage() {
        this.tester.gotoPage(REFERENCE_ACTION_URI);
    }

    private void enableReferenceWebworkActionModule() {
        this.administration.plugins().referencePlugin().enableModule(ReferencePluginConstants.REFERENCE_ACTIONS_KEY);
    }

    private void disableReferenceWebworkActionModule() {
        this.administration.plugins().referencePlugin().disableModule(ReferencePluginConstants.REFERENCE_ACTIONS_KEY);
    }

    static class DisabledActionResponse {
        static int CODE = 404;

        DisabledActionResponse() {
        }
    }
}

