/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.AbstractChangeHistoryFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestSearchChangesInStatus
extends AbstractChangeHistoryFuncTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestWasSearch.xml");
    }

    public void testReturnsAllIssuesThatWereInASpecificStatus() {
        this.navigation.login("bob");
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.assertSearchWithResults("status was Open", openIssues);
    }

    public void testReturnsAllIssuesThatWereNotEverInASpecificStatus() throws Exception {
        this.navigation.login("bob");
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.assertSearchWithResults("Status was not 'In Progress'", openIssues);
    }

    public void testReturnsAllIssuesThatWereInASetOfSpecificStatuses() throws Exception {
        this.navigation.login("bob");
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.assertSearchWithResults("status was in (Open,'In Progress')", openIssues);
    }

    public void testReturnsAllIssuesThatWereNotEverInASetOfSpecificStatuses() throws Exception {
        this.navigation.login("bob");
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.assertSearchWithResults("status was not in ('In Progress',Reopened,Closed)", openIssues);
    }

    public void testReturnsZeroIssuesForAStatusThatHasNeverBeenSet() throws Exception {
        this.navigation.login("bob");
        this.assertSearchWithResults("status was Closed", new String[0]);
    }

    public void testIgnoresTheCaseOfTheStatusValue() throws Exception {
        this.navigation.login("bob");
        this.assertSearchWithResults("status was Open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("Status was open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("Status was oPEn", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
    }

    public void testReturnsAnErrorForANonExistingStatus() {
        this.navigation.login("bob");
        this.assertSearchWithError("status was dingbat", "The value 'dingbat' does not exist for the field 'status'.");
    }

    public void testTakesIntoAccountUpdatesToTheStatusOfAnIssue() {
        this.navigation.login("fred");
        String issueToBeUpdated = "HSP-1";
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.assertSearchWithResults("status was Open", openIssues);
        this.assertSearchWithResults("status was Closed", "HSP-1");
    }

    public void testAddingANewStatusAllowsSearchingForIssuesInThatStatus() {
        this.navigation.login("admin");
        this.tester.gotoPage("secure/admin/ViewStatuses.jspa");
        this.tester.setFormElement("name", "myStatus");
        this.tester.submit("Add");
        this.assertSearchWithResults("status was myStatus", new String[0]);
    }

    public void testStatusFieldRename() {
        this.navigation.login("admin");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.assertSearchWithResults("status was Closed", "HSP-1");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=6");
        this.tester.setFormElement("name", "Shut");
        this.tester.submit("Update");
        this.assertSearchWithResults("Status was Closed", "HSP-1");
        this.assertSearchWithResults("Status was shut", "HSP-1");
    }
}

