/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.priority;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.AbstractChangeHistoryFuncTest;
import com.google.common.collect.Sets;
import java.util.HashSet;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestPriorityWasSearching
extends AbstractChangeHistoryFuncTest {
    private static final String FIELD_NAME = "priority";
    private static final String[] ALL_ISSUES = new String[]{"HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.navigation.login("admin");
    }

    public void testWasEmptySearch() {
        String[] issueKeys = new String[]{};
        super.assertWasEmptySearchReturnsEmptyValuesUsingEmptyKeyword(FIELD_NAME, issueKeys);
    }

    public void testWasNotEmptySearch() {
        super.assertWasNotEmptySearchReturnsNotEmptyValuesWithEmptyKeyword(FIELD_NAME, ALL_ISSUES);
    }

    public void testWasSearchUsingSingleValueOperandsReturnsExpectedValues() {
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, "major", ALL_ISSUES);
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, "minor", "HSP-7", "HSP-2");
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, "catastrophic", "HSP-7", "HSP-1");
    }

    public void testWasSearchUsingListOperands() {
        HashSet priorities = Sets.newHashSet((Object[])new String[]{"major", "minor"});
        super.assertWasInSearchReturnsExpectedValues(FIELD_NAME, priorities, ALL_ISSUES);
        priorities = Sets.newHashSet((Object[])new String[]{"minor", "catastrophic"});
        super.assertWasInSearchReturnsExpectedValues(FIELD_NAME, priorities, "HSP-7", "HSP-2", "HSP-1");
    }

    public void testWasNotInSearchUsingListOperands() {
        HashSet priorities = Sets.newHashSet((Object[])new String[]{"minor", "catastrophic"});
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3"};
        super.assertWasNotInSearchReturnsExpectedValues(FIELD_NAME, priorities, expected);
    }

    public void testWasSearchForRenamedConstant() {
        this.assertWasSearchForRenamedConstantFindsOldName(FIELD_NAME, "critical", "catastrophic", "HSP-7", "HSP-1");
    }

    public void testWasSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "major", "admin", expected);
        expected = new String[]{"HSP-1"};
        super.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "catastrophic", "fred", expected);
        super.assertWasBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "catastrophic", Sets.newHashSet((Object[])new String[]{"fred", "bob"}), "HSP-1");
    }

    public void testWasSearchUsingDuringPredicate() {
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/30'", "'2011/06/02'", expected);
    }

    public void testWasSearchUsingBeforePredicate() {
        super.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01'", ALL_ISSUES);
        String[] expected = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "major", "'2010/06/02'", expected);
    }

    public void testWasSearchUsingAfterPredicate() {
        super.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/01'", ALL_ISSUES);
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01 10:55'", expected);
    }

    public void testWasSearchUsingOnPredicate() {
        super.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/01'", ALL_ISSUES);
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01'", expected);
    }

    public void testWasSearchUsingLongOperandsIsInvalid() {
        String expectedError = "History searches only support string values.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "1", "", expectedError);
    }

    public void testWasSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "(major, minor", "", expectedError);
    }

    public void testWasSearchUsingIcorrectPriorityIsInvalid() {
        String expectedError = "The value 'urgent' does not exist for the field 'priority'.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "urgent", "", expectedError);
    }

    public void testWasSearchUsingIncorrectPredicateIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 29)";
        super.assertInvalidSearchProducesError(FIELD_NAME, "(major, minor)", "at '10:55'", expectedError);
    }

    public void testWasSearchUsingIncorrectFunctionIsInvalid() {
        String expectedError = "A value provided by the function 'currentLogin' is invalid for the field 'priority'.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "currentLogin()", "", expectedError);
    }
}

