/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSystemFieldLiterals
extends AbstractJqlFuncTest {
    public void testAffectedVersion() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsVersion.xml");
        String fieldName = "affectedVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'New Version 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("affectedVersion", matrix);
    }

    public void testAssignee() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsAssignee.xml");
        String fieldName = "assignee";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("administrator", new Result(new String[]{"HSP-1"}));
        matrix.put("admin", new Result(new String[]{"HSP-2"}));
        matrix.put("'Fred Normal'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("12345", new Result(new String[]{"HSP-5"}));
        matrix.put("'12345'", new Result(new String[]{"HSP-5"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("assignee", matrix);
    }

    public void testCategory() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsCategory.xml");
        String fieldName = "category";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Category1'", new Result(new String[]{"CAT-1"}));
        matrix.put("'10000'", new Result(new String[]{"CATTWO-1"}));
        matrix.put("'10001'", new Result(new String[]{"CATTWO-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"CAT-1"}));
        matrix.put("10001", new Result(new String[]{"CATTWO-1"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"NOT-1"}));
        this._testLiteralMatrix("category", matrix);
    }

    public void testComment() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsComment.xml");
        String fieldName = "comment";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"COM-1"}));
        matrix.put("'-Test'", new Result(new String[]{"COM-2"}));
        matrix.put("'123456'", new Result(new String[]{"COM-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"COM-1"}));
        matrix.put("123456", new Result(new String[]{"COM-2"}));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("comment", "~", matrix);
    }

    public void testComponent() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsComponent.xml");
        String fieldName = "component";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Component 1'", new Result(new String[]{"CMP-1"}));
        matrix.put("'10010'", new Result(new String[]{"CMP-2"}));
        matrix.put("'10011'", new Result(new String[]{"CMP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10010", new Result(new String[]{"CMP-1"}));
        matrix.put("10011", new Result(new String[]{"CMP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"CMP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("component", matrix);
    }

    public void testCreated() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsCreated.xml");
        String fieldName = "created";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("'1d'", new Result(new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"CRE-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("created", "<", matrix);
    }

    public void testDescription() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsDescription.xml");
        String fieldName = "description";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-Test'", new Result(new String[]{"HSP-2"}));
        matrix.put("'123456'", new Result(new String[]{"HSP-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"HSP-1"}));
        matrix.put("123456", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("description", "~", matrix);
    }

    public void testDueDate() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsDueDate.xml");
        String fieldName = "due";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242204510000", new Result(new String[]{"HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        matrix.put("'2009/05/13'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-2"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-2"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        this._testLiteralMatrix("due", "=", matrix);
        matrix = new LinkedHashMap();
        matrix.put("'1d'", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        this._testLiteralMatrix("due", "<", matrix);
    }

    public void testEnvironment() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsEnvironment.xml");
        String fieldName = "environment";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-Test'", new Result(new String[]{"HSP-2"}));
        matrix.put("'123456'", new Result(new String[]{"HSP-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"HSP-1"}));
        matrix.put("123456", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("environment", "~", matrix);
    }

    public void testFixVersion() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsVersion.xml");
        String fieldName = "fixVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'New Version 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("fixVersion", matrix);
    }

    public void testIssue() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsIssue.xml");
        String fieldName = "issue";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("''", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("'HSP-2'", new Result(new String[]{"HSP-2"}));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("issue", matrix);
    }

    public void testLevel() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsLevel.xml");
        String fieldName = "level";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Level 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10010'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10010", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("level", matrix);
    }

    public void testTimeTracking() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsTime.xml");
        String fieldName = "originalEstimate";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'60'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2h'", new Result(new String[]{"HSP-2"}));
        matrix.put("'0h'", new Result(new String[]{"HSP-5"}));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("240", new Result(new String[]{"HSP-3"}));
        matrix.put("0", new Result(new String[]{"HSP-5"}));
        matrix.put("'-240'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix(fieldName, matrix);
        fieldName = "remainingEstimate";
        matrix = new LinkedHashMap();
        matrix.put("'40'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1h'", new Result(new String[]{"HSP-3", "HSP-2"}));
        matrix.put("'0m'", new Result(new String[]{"HSP-5"}));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("60", new Result(new String[]{"HSP-3", "HSP-2"}));
        matrix.put("0", new Result(new String[]{"HSP-5"}));
        matrix.put("'-60'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix(fieldName, matrix);
        fieldName = "timeSpent";
        matrix = new LinkedHashMap();
        matrix.put("'20'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1h'", new Result(new String[]{"HSP-2"}));
        matrix.put("'0d'", new Result(new String[0]));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("180", new Result(new String[]{"HSP-3"}));
        matrix.put("0", new Result(new String[0]));
        matrix.put("'-180'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix(fieldName, matrix);
        fieldName = "workRatio";
        matrix = new LinkedHashMap();
        matrix.put("'33'", new Result(new String[]{"HSP-1"}));
        matrix.put("'33.3'", new Result(ErrorType.INVALID_INTEGER_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_INTEGER_FORMAT));
        matrix.put("0", new Result(new String[0]));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix(fieldName, matrix);
    }

    public void testParent() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsParent.xml");
        String fieldName = "parent";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("''", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("'HSP-2'", new Result(new String[]{"HSP-4"}));
        matrix.put("10000", new Result(new String[]{"HSP-3"}));
        matrix.put("10001", new Result(new String[]{"HSP-4"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("parent", matrix);
    }

    public void testPriority() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsPriority.xml");
        String fieldName = "priority";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Blocker'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1'", new Result(new String[]{"HSP-2"}));
        matrix.put("'2'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("priority", matrix);
    }

    public void testProject() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsProject.xml");
        String fieldName = "project";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10010'", new Result(new String[]{"NUM-1"}));
        matrix.put("'10011'", new Result(new String[]{"NUM-1"}));
        matrix.put("'DUP'", new Result(new String[]{"DUP-1"}));
        matrix.put("'HSP'", new Result(new String[]{"HSP-1"}));
        matrix.put("'homosapien'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10010", new Result(new String[]{"HSP-1"}));
        matrix.put("10011", new Result(new String[]{"NUM-1"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("project", matrix);
        NavigatorSearch search = new NavigatorSearch((NavigatorCondition)new ProjectCondition().addProject("HSP"));
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("DUP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertJqlQueryInTextArea("project = DUP");
        search = new NavigatorSearch((NavigatorCondition)new ProjectCondition().addProject("homosapien"));
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertJqlQueryInTextArea("project = HSP");
    }

    public void testReporter() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsAssignee.xml");
        String fieldName = "reporter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("administrator", new Result(new String[]{"HSP-1"}));
        matrix.put("admin", new Result(new String[]{"HSP-2"}));
        matrix.put("'Fred Normal'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("12345", new Result(new String[]{"HSP-5"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("'12345'", new Result(new String[]{"HSP-5"}));
        this._testLiteralMatrix("reporter", matrix);
    }

    public void testResolution() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsResolution.xml");
        String fieldName = "resolution";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Fixed'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1'", new Result(new String[]{"HSP-2"}));
        matrix.put("'3'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix("resolution", matrix);
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", "HSP-3", "HSP-2");
        this.assertSearchAndErrorMessagePresent("resolution = '\"unresolved\"'", ErrorType.NAME_NOT_FOUND.formatError("resolution", "'\"unresolved\"'"));
        this.administration.resolutions().addResolution("unRESOLVED");
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved)", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", "HSP-3", "HSP-2");
        this.assertSearchResults("resolution = '\"unresolved\"'", new String[0]);
        this.assertSearchResults("resolution in ('\"unresolved\"')", new String[0]);
        this.assertSearchResults("resolution in ('\"unresolved\"', Fixed)", "HSP-1");
        this.assertSearchResults("resolution != '\"unresolved\"'", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"')", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"', Fixed)", "HSP-3", "HSP-2");
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "test");
        this.navigation.issue().resolveIssue(issue, "unRESOLVED", "test");
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", issue, "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved)", issue, "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", issue, "HSP-3", "HSP-2");
        this.assertSearchResults("resolution = '\"unresolved\"'", issue);
        this.assertSearchResults("resolution in ('\"unresolved\"')", issue);
        this.assertSearchResults("resolution in ('\"unresolved\"', Fixed)", issue, "HSP-1");
        this.assertSearchResults("resolution != '\"unresolved\"'", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"')", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"', Fixed)", "HSP-3", "HSP-2");
        this.assertSearchAndErrorMessagePresent("resolution = \"\\\"\\\"unresolved\\\"\\\"\"", ErrorType.NAME_NOT_FOUND.formatError("resolution", "'\"\"unresolved\"\"'"));
        this.administration.resolutions().addResolution("\"unresolved\"");
        this.assertSearchResults("resolution = \"\\\"\\\"unresolved\\\"\\\"\"", new String[0]);
        issue = this.navigation.issue().createIssue("homosapien", "Bug", "test");
        this.navigation.issue().resolveIssue(issue, "\"unresolved\"", "test");
        this.assertSearchResults("resolution = \"\\\"\\\"unresolved\\\"\\\"\"", issue);
    }

    public void testResolutionDate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        String fieldName = "resolved";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'1d'", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("resolved", "<", matrix);
    }

    public void testSavedFilter() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsSavedFilter.xml");
        String fieldName = "savedFilter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bugs'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("savedFilter", matrix);
    }

    public void testStatus() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsStatus.xml");
        String fieldName = "status";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'1'", new Result(new String[]{"HSP-2"}));
        matrix.put("'3'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Open'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("3", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("status", matrix);
    }

    public void testSummary() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsSummary.xml");
        String fieldName = "summary";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'OneTwoThree'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-OneTwoThree'", new Result(new String[]{"HSP-2"}));
        matrix.put("'456'", new Result(new String[]{"HSP-2"}));
        matrix.put("OneTwoThree", new Result(new String[]{"HSP-1"}));
        matrix.put("456", new Result(new String[]{"HSP-2"}));
        matrix.put("-456", new Result(new String[]{"HSP-1"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("summary", "~", matrix);
    }

    public void testText() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsSummary.xml");
        String fieldName = "text";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'OneTwoThree'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-OneTwoThree'", new Result(new String[]{"HSP-2"}));
        matrix.put("'456'", new Result(new String[]{"HSP-2"}));
        matrix.put("OneTwoThree", new Result(new String[]{"HSP-1"}));
        matrix.put("456", new Result(new String[]{"HSP-2"}));
        matrix.put("-456", new Result(new String[]{"HSP-1"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("text", "~", matrix);
    }

    public void testType() throws Exception {
        this.administration.restoreData("TestSystemFieldLiteralsType.xml");
        String fieldName = "type";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'1'", new Result(new String[]{"HSP-2"}));
        matrix.put("'2'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bug'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("type", matrix);
    }

    public void testUpdated() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        String fieldName = "updated";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'1d'", new Result(new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("updated", "<", matrix);
    }

    public void testVotes() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsVotes.xml");
        String fieldName = "votes";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'0'", new Result(new String[]{"HSP-3"}));
        matrix.put("'1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-3'", new Result(ErrorType.INVALID_VOTES_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_VOTES_FORMAT));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("-3", new Result(ErrorType.INVALID_VOTES_FORMAT_WITH_QUOTES));
        matrix.put("EMPTY", new Result(ErrorType.INVALID_VOTES_FORMAT_WITH_QUOTES));
        this._testLiteralMatrix("votes", matrix);
    }

    private void _testLiteralMatrix(String fieldName, Map<String, Result> matrix) {
        this._testLiteralMatrix(fieldName, "=", matrix);
    }

    private void _testLiteralMatrix(String fieldName, String operator, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String operand = entry.getKey();
            String jqlQuery = String.format("%s %s %s", fieldName, operator, operand);
            Result result = entry.getValue();
            if (result.issueKeys == null && result.errorType != null) {
                String errorMsg = result.errorType.formatError(fieldName, operand);
                this.assertSearchAndErrorMessagePresent(jqlQuery, errorMsg);
                continue;
            }
            this.assertSearchResults(jqlQuery, result.issueKeys);
        }
    }

    private void assertSearchResults(String jqlQuery, String ... issueKeys) {
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), issueKeys));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), issueKeys.length));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private void assertSearchAndErrorMessagePresent(String jqlQuery, String msg) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertErrorMessagePresent(msg);
    }

    private void assertErrorMessagePresent(String msg) {
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), msg);
    }

    private static enum ErrorType {
        EMPTY_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The field '%s' does not support searching for EMPTY values.", fieldName);
            }
        }
        ,
        EMPTY_STRING_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The field '%s' does not support searching for an empty string.", fieldName);
            }
        }
        ,
        ISSUE_KEY_INVALID{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The issue key %s for field '%s' is invalid.", operand, fieldName);
            }
        }
        ,
        INVALID_VOTES_FORMAT{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("Value %s is invalid for the '%s' field. Votes must be a positive whole number.", operand, fieldName);
            }
        }
        ,
        INVALID_VOTES_FORMAT_WITH_QUOTES{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("Value '%s' is invalid for the '%s' field. Votes must be a positive whole number.", operand, fieldName);
            }
        }
        ,
        INVALID_INTEGER_FORMAT{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The value %s for field '%s' is invalid - please specify an integer.", operand, fieldName);
            }
        }
        ,
        INVALID_DURATION_FORMAT{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The value %s for field '%s' is invalid. Please specify a positive duration format; for example: '1h 30m', '2d'.", operand, fieldName);
            }
        }
        ,
        INVALID_DATE_FORMAT{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("Date value %s for field '%s' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", operand, fieldName);
            }
        }
        ,
        INVALID_RELATIVE_DATE_FORMAT{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("Date value %s for field '%s' is invalid. Valid formats include: 'YYYY/MM/DD', 'YYYY-MM-DD', or a period format e.g. '-5d', '4w 2d'.", operand, fieldName);
            }
        }
        ,
        CANT_PARSE_QUERY{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("Unable to parse the text %s for field '%s'.", operand, fieldName);
            }
        }
        ,
        INVALID_START_CHAR{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The text query %s for field '%s' is not allowed to start with %1$s.", operand, fieldName);
            }
        }
        ,
        NAME_NOT_FOUND{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The value %s does not exist for the field '%s'.", operand, fieldName);
            }
        }
        ,
        ID_NOT_FOUND{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("A value with ID '%s' does not exist for the field '%s'.", operand, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Result {
        private String[] issueKeys = null;
        private ErrorType errorType = null;

        private Result(String ... issueKeys) {
            this.issueKeys = issueKeys;
        }

        private Result(ErrorType errorType) {
            this.errorType = errorType;
        }
    }
}

