/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSearchRequestModified
extends FuncTestCase {
    public void testSimpleViewDoesNotResetQueryString() throws Exception {
        this.administration.restoreData("TestSearchRequestModified.xml");
        this._testJqlIsntModifiedAfterSearchingOnSimple("type    =    bug");
        this._testJqlIsntModifiedAfterSearchingOnSimple("project    =    HSP");
        this._testJqlIsntModifiedAfterSearchingOnSimple("project    =    HSP and fixVersion = 'New Version 1'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("project    =    HSP AND affectedVersion = 'New Version 1'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("project   =    HSP AND component = 'New Component 1'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("status = 'open'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("resolution   =   'fixed'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("priority   =   'Major'");
        this._testJqlIsntModifiedAfterSearchingOnSimple("created   >=    \"2009/08/26\"");
        this._testJqlIsntModifiedAfterSearchingOnSimple("updated   >=    \"2009/08/26\"");
        this._testJqlIsntModifiedAfterSearchingOnSimple("resolved   >=    \"2009/08/26\"");
    }

    public void testLoadedFilterShowsModified() throws Exception {
        this.administration.restoreData("TestSearchRequestModified.xml");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertNotModified();
        this.text.assertTextPresent(new XPathLocator(this.tester, "//textarea[@id='jqltext']"), "type = bug");
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "type =   bug");
        this.tester.submit();
        this.assertModified();
        this.navigation.issueNavigator().gotoViewMode();
        this.tester.clickLink("reload");
        this.assertNotModified();
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        this.tester.selectOption("type", "Task");
        this.tester.submit("show");
        this.assertModified();
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertModified();
        this.text.assertTextPresent(new XPathLocator(this.tester, "//textarea[@id='jqltext']"), "issuetype = Task");
    }

    private void _testJqlIsntModifiedAfterSearchingOnSimple(String jqlString) {
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.navigation.issueNavigator().createSearch(jqlString);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        this.tester.submit("show");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//textarea[@id='jqltext']"), jqlString);
    }

    private void assertModified() {
        this.text.assertTextPresent(new IdLocator(this.tester, "filter-description"), "Filter modified since loading");
    }

    private void assertNotModified() {
        this.text.assertTextNotPresent(new IdLocator(this.tester, "filter-description"), "Filter modified since loading");
    }
}

