/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSearchConstrainedByConfiguration
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSearchConstrainedByConfiguration.xml");
    }

    public void testHideFieldEmptyQueries() throws Exception {
        this.assertSearchWithResults(String.format("'%s' is EMPTY", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' = EMPTY", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' in (EMPTY)", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", "priority"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' != EMPTY", "priority"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", "priority"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.administration.fieldConfigurations().fieldConfiguration("Invisible Configuration").showFields("Priority");
        this.administration.reIndex();
        this.assertSearchWithResults(String.format("'%s' is EMPTY", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' = EMPTY", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' in (EMPTY)", "priority"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", "priority"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' != EMPTY", "priority"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", "priority"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' is EMPTY", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' = EMPTY", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' in (EMPTY)", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", "reporter"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' != EMPTY", "reporter"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", "reporter"), "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.administration.fieldConfigurations().fieldConfiguration("Invisible Configuration").showFields("Reporter");
        this.administration.reIndex();
        this.assertSearchWithResults(String.format("'%s' is EMPTY", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' = EMPTY", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' in (EMPTY)", "reporter"), new String[0]);
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", "reporter"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' != EMPTY", "reporter"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", "reporter"), "MKY-2", "MKY-1", "INI-1", "HSP-2", "HSP-1");
        this._testHideFieldEmptyQueries("affectedVersion", "Affects Version/s", true, true);
        this._testHideFieldEmptyQueries("assignee", "Assignee", false, true);
        this._testHideFieldEmptyQueries("Cascading Select CF", true, true);
        this._testHideFieldEmptyQueries("component", "Component/s", true, true);
        this._testHideFieldEmptyQueries("description", "Description", true, false);
        this._testHideFieldEmptyQueries("duedate", "Due Date", true, true);
        this._testHideFieldEmptyQueries("environment", "Environment", true, false);
        this._testHideFieldEmptyQueries("fixVersion", "Fix Version/s", true, true);
        this._testHideFieldEmptyQueries("Free Text Field CF", true, false);
        this._testHideFieldEmptyQueries("Group Picker CF", true, true);
        this._testHideFieldEmptyQueries("Multi Checkboxes CF", true, true);
        this._testHideFieldEmptyQueries("Multi Group Picker CF", true, true);
        this._testHideFieldEmptyQueries("Multi Select CF", true, true);
        this._testHideFieldEmptyQueries("Multi User Picker CF", true, true);
        this._testHideFieldEmptyQueries("Number Field CF", true, true);
        this._testHideFieldEmptyQueries("Project Picker CF", true, true);
        this._testHideFieldEmptyQueries("Radio Buttons CF", true, true);
        this._testHideFieldEmptyQueries("resolution", "Resolution", true, true);
        this._testHideFieldEmptyQueries("Select List CF", true, true);
        this._testHideFieldEmptyQueries("Single Version Picker CF", true, true);
        this._testHideFieldEmptyQueries("Text Field 255", true, false);
        this._testHideFieldEmptyQueries("URL Field CF", true, true);
        this._testHideFieldEmptyQueries("User Picker CF", true, true);
        this._testHideFieldEmptyQueries("Version Picker CF", true, true);
    }

    private void _testHideFieldEmptyQueries(String fieldClauseName, boolean invisibleInEmpty, boolean equalsAndListsSupported) {
        this._testHideFieldEmptyQueries(fieldClauseName, fieldClauseName, invisibleInEmpty, equalsAndListsSupported);
    }

    private void _testHideFieldEmptyQueries(String fieldClauseName, String fieldConfigName, boolean invisibleInEmpty, boolean equalsAndListsSupported) {
        String[] stringArray;
        String[] stringArray2;
        this.assertSearchWithResults(String.format("'%s' is EMPTY", fieldClauseName), "MKY-2", "HSP-2");
        if (equalsAndListsSupported) {
            this.assertSearchWithResults(String.format("'%s' = EMPTY", fieldClauseName), "MKY-2", "HSP-2");
            this.assertSearchWithResults(String.format("'%s' in (EMPTY)", fieldClauseName), "MKY-2", "HSP-2");
        }
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", fieldClauseName), "MKY-1", "HSP-1");
        if (equalsAndListsSupported) {
            this.assertSearchWithResults(String.format("'%s' != EMPTY", fieldClauseName), "MKY-1", "HSP-1");
            this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", fieldClauseName), "MKY-1", "HSP-1");
        }
        this.administration.fieldConfigurations().fieldConfiguration("Invisible Configuration").showFields(fieldConfigName);
        this.administration.reIndex();
        if (invisibleInEmpty) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "MKY-2";
            stringArray3[1] = "INI-1";
            stringArray2 = stringArray3;
            stringArray3[2] = "HSP-2";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "MKY-2";
            stringArray2 = stringArray4;
            stringArray4[1] = "HSP-2";
        }
        String[] emptyIssues = stringArray2;
        if (!invisibleInEmpty) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = "MKY-1";
            stringArray5[1] = "INI-1";
            stringArray = stringArray5;
            stringArray5[2] = "HSP-1";
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = "MKY-1";
            stringArray = stringArray6;
            stringArray6[1] = "HSP-1";
        }
        String[] nonEmptyIssues = stringArray;
        this.assertSearchWithResults(String.format("'%s' is EMPTY", fieldClauseName), emptyIssues);
        if (equalsAndListsSupported) {
            this.assertSearchWithResults(String.format("'%s' = EMPTY", fieldClauseName), emptyIssues);
            this.assertSearchWithResults(String.format("'%s' in (EMPTY)", fieldClauseName), emptyIssues);
        }
        this.assertSearchWithResults(String.format("'%s' is not EMPTY", fieldClauseName), nonEmptyIssues);
        if (equalsAndListsSupported) {
            this.assertSearchWithResults(String.format("'%s' != EMPTY", fieldClauseName), nonEmptyIssues);
            this.assertSearchWithResults(String.format("'%s' not in (EMPTY)", fieldClauseName), nonEmptyIssues);
        }
    }

    public void testHideFields() throws Exception {
        this._runFilterAndVerifySearchNoRestrictions(10000);
        this._testHideField("affectedVersion", "=", "'New Version 1'", "Affects Version/s");
        this._runFilterAndVerifySearchRestricted(10000);
        this._runFilterAndVerifySearchNoRestrictions(10001);
        this._testHideField("assignee", "=", "admin", "Assignee");
        this._runFilterAndVerifySearchRestricted(10001);
        this._runFilterAndVerifySearchNoRestrictions(10002);
        this._testHideField("Cascading Select CF", "in", "cascadeOption(\"Parent Option 1\", \"Child Option 1\")");
        this._runFilterAndVerifySearchRestricted(10002);
        this._runFilterAndVerifySearchNoRestrictions(10003);
        this._testHideField("component", "=", "\"New Component 1\"", "Component/s");
        this._runFilterAndVerifySearchRestricted(10003);
        this._runFilterAndVerifySearchNoRestrictions(10004);
        this._testHideField("description", "~", "'same description'", "Description");
        this._runFilterAndVerifySearchRestricted(10004);
        this._runFilterAndVerifySearchNoRestrictions(10005);
        this._testHideField("duedate", "=", "\"2009/07/06\"", "Due Date");
        this._runFilterAndVerifySearchRestricted(10005);
        this._runFilterAndVerifySearchNoRestrictions(10006);
        this._testHideField("environment", "~", "'same environment'", "Environment");
        this._runFilterAndVerifySearchRestricted(10006);
        this._runFilterAndVerifySearchNoRestrictions(10007);
        this._testHideField("fixVersion", "=", "'New Version 4'", "Fix Version/s");
        this._runFilterAndVerifySearchRestricted(10007);
        this._runFilterAndVerifySearchNoRestrictions(10008);
        this._testHideField("Free Text Field CF", "~", "'free text'");
        this._runFilterAndVerifySearchRestricted(10008);
        this._runFilterAndVerifySearchNoRestrictions(10009);
        this._testHideField("Group Picker CF", "=", "'jira-administrators'");
        this._runFilterAndVerifySearchRestricted(10009);
        this._runFilterAndVerifySearchNoRestrictions(10010);
        this._testHideField("Multi Checkboxes CF", "=", "'check 1'");
        this._runFilterAndVerifySearchRestricted(10010);
        this._runFilterAndVerifySearchNoRestrictions(10011);
        this._testHideField("Multi Group Picker CF", "=", "'jira-administrators'");
        this._runFilterAndVerifySearchRestricted(10011);
        this._runFilterAndVerifySearchNoRestrictions(10012);
        this._testHideField("Multi Select CF", "=", "'opt 1'");
        this._runFilterAndVerifySearchRestricted(10012);
        this._runFilterAndVerifySearchNoRestrictions(10013);
        this._testHideField("Multi User Picker CF", "=", "admin");
        this._runFilterAndVerifySearchRestricted(10013);
        this._runFilterAndVerifySearchNoRestrictions(10014);
        this._testHideField("Number Field CF", "=", "1");
        this._runFilterAndVerifySearchRestricted(10014);
        this._runFilterAndVerifySearchNoRestrictions(10015);
        this._testHideField("Project Picker CF", "=", "Invisible");
        this._runFilterAndVerifySearchRestricted(10015);
        this._runFilterAndVerifySearchNoRestrictions(10016);
        this._testHideField("Radio Buttons CF", "=", "'Radio Option 1'");
        this._runFilterAndVerifySearchRestricted(10016);
        this._runFilterAndVerifySearchNoRestrictions(10017);
        this._testHideField("resolution", "=", "Fixed", "Resolution");
        this._runFilterAndVerifySearchRestricted(10017);
        this._runFilterAndVerifySearchNoRestrictions(10018);
        this._testHideField("Select List CF", "=", "\"option 1\"");
        this._runFilterAndVerifySearchRestricted(10018);
        this._runFilterAndVerifySearchNoRestrictions(10019);
        this._testHideField("Single Version Picker CF", "=", "'New Version 1'");
        this._runFilterAndVerifySearchRestricted(10019);
        this._runFilterAndVerifySearchNoRestrictions(10020);
        this._testHideField("Text Field 255", "~", "'text 255'");
        this._runFilterAndVerifySearchRestricted(10020);
        this._runFilterAndVerifySearchNoRestrictions(10021);
        this._testHideField("URL Field CF", "=", "'http://google.com'");
        this._runFilterAndVerifySearchRestricted(10021);
        this._runFilterAndVerifySearchNoRestrictions(10022);
        this._testHideField("User Picker CF", "=", "admin");
        this._runFilterAndVerifySearchRestricted(10022);
        this._runFilterAndVerifySearchNoRestrictions(10023);
        this._testHideField("Version Picker CF", "=", "'New Version 4'");
        this._runFilterAndVerifySearchRestricted(10023);
    }

    public void testNoBrowseProjectPermission() throws Exception {
        this._runFilterAndVerifySearchNoRestrictions(10000);
        this._runFilterAndVerifySearchNoRestrictions(10001);
        this._runFilterAndVerifySearchNoRestrictions(10002);
        this._runFilterAndVerifySearchNoRestrictions(10003);
        this._runFilterAndVerifySearchNoRestrictions(10004);
        this._runFilterAndVerifySearchNoRestrictions(10005);
        this._runFilterAndVerifySearchNoRestrictions(10006);
        this._runFilterAndVerifySearchNoRestrictions(10007);
        this._runFilterAndVerifySearchNoRestrictions(10008);
        this._runFilterAndVerifySearchNoRestrictions(10009);
        this._runFilterAndVerifySearchNoRestrictions(10010);
        this._runFilterAndVerifySearchNoRestrictions(10011);
        this._runFilterAndVerifySearchNoRestrictions(10012);
        this._runFilterAndVerifySearchNoRestrictions(10013);
        this._runFilterAndVerifySearchNoRestrictions(10014);
        this._runFilterAndVerifySearchNoRestrictions(10015);
        this._runFilterAndVerifySearchNoRestrictions(10016);
        this._runFilterAndVerifySearchNoRestrictions(10017);
        this._runFilterAndVerifySearchNoRestrictions(10018);
        this._runFilterAndVerifySearchNoRestrictions(10019);
        this._runFilterAndVerifySearchNoRestrictions(10020);
        this._runFilterAndVerifySearchNoRestrictions(10021);
        this._runFilterAndVerifySearchNoRestrictions(10022);
        this._runFilterAndVerifySearchNoRestrictions(10023);
        this._runAndVerifySearchForFieldNoRestrictions("affectedVersion", "=", "'New Version 1'");
        this._runAndVerifySearchForFieldNoRestrictions("assignee", "=", "admin");
        this._runAndVerifySearchForFieldNoRestrictions("Cascading Select CF", "in", "cascadeOption(\"Parent Option 1\", \"Child Option 1\")");
        this._runAndVerifySearchForFieldNoRestrictions("component", "=", "\"New Component 1\"");
        this._runAndVerifySearchForFieldNoRestrictions("description", "~", "'same description'");
        this._runAndVerifySearchForFieldNoRestrictions("duedate", "=", "\"2009/07/06\"");
        this._runAndVerifySearchForFieldNoRestrictions("environment", "~", "'same environment'");
        this._runAndVerifySearchForFieldNoRestrictions("fixVersion", "=", "'New Version 4'");
        this._runAndVerifySearchForFieldNoRestrictions("Free Text Field CF", "~", "'free text'");
        this._runAndVerifySearchForFieldNoRestrictions("Group Picker CF", "=", "'jira-administrators'");
        this._runAndVerifySearchForFieldNoRestrictions("Multi Checkboxes CF", "=", "'check 1'");
        this._runAndVerifySearchForFieldNoRestrictions("Multi Group Picker CF", "=", "'jira-administrators'");
        this._runAndVerifySearchForFieldNoRestrictions("Multi Select CF", "=", "'opt 1'");
        this._runAndVerifySearchForFieldNoRestrictions("Multi User Picker CF", "=", "admin");
        this._runAndVerifySearchForFieldNoRestrictions("Number Field CF", "=", "1");
        this._runAndVerifySearchForFieldNoRestrictions("Project Picker CF", "=", "Invisible");
        this._runAndVerifySearchForFieldNoRestrictions("Radio Buttons CF", "=", "'Radio Option 1'");
        this._runAndVerifySearchForFieldNoRestrictions("resolution", "=", "Fixed");
        this._runAndVerifySearchForFieldNoRestrictions("Select List CF", "=", "\"option 1\"");
        this._runAndVerifySearchForFieldNoRestrictions("Single Version Picker CF", "=", "'New Version 1'");
        this._runAndVerifySearchForFieldNoRestrictions("Text Field 255", "~", "'text 255'");
        this._runAndVerifySearchForFieldNoRestrictions("URL Field CF", "=", "'http://google.com'");
        this._runAndVerifySearchForFieldNoRestrictions("User Picker CF", "=", "admin");
        this._runAndVerifySearchForFieldNoRestrictions("Version Picker CF", "=", "'New Version 4'");
        this.assertSearchWithResults("priority = \"Major\"", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults("reporter = \"admin\"", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.administration.permissionSchemes().scheme("Custom Permission Scheme").removePermission(10, "jira-users");
        this._runFilterAndVerifySearchRestricted(10000);
        this._runFilterAndVerifySearchRestricted(10001);
        this._runFilterAndVerifySearchRestricted(10002);
        this._runFilterAndVerifySearchRestricted(10003);
        this._runFilterAndVerifySearchRestricted(10004);
        this._runFilterAndVerifySearchRestricted(10005);
        this._runFilterAndVerifySearchRestricted(10006);
        this._runFilterAndVerifySearchRestricted(10007);
        this._runFilterAndVerifySearchRestricted(10008);
        this._runFilterAndVerifySearchRestricted(10009);
        this._runFilterAndVerifySearchRestricted(10010);
        this._runFilterAndVerifySearchRestricted(10011);
        this._runFilterAndVerifySearchRestricted(10012);
        this._runFilterAndVerifySearchRestricted(10013);
        this._runFilterAndVerifySearchRestricted(10014);
        this._runFilterAndVerifySearchRestricted(10015);
        this._runFilterAndVerifySearchRestricted(10016);
        this._runFilterAndVerifySearchRestricted(10017);
        this._runFilterAndVerifySearchRestricted(10018);
        this._runFilterAndVerifySearchRestricted(10019);
        this._runFilterAndVerifySearchRestricted(10020);
        this._runFilterAndVerifySearchRestricted(10021);
        this._runFilterAndVerifySearchRestricted(10022);
        this._runFilterAndVerifySearchRestricted(10023);
        this._runAndVerifySearchForFieldRestricted("affectedVersion", "=", "'New Version 1'");
        this._runAndVerifySearchForFieldRestricted("assignee", "=", "admin");
        this._runAndVerifySearchForFieldRestricted("Cascading Select CF", "in", "cascadeOption(\"Parent Option 1\", \"Child Option 1\")");
        this._runAndVerifySearchForFieldRestricted("component", "=", "\"New Component 1\"");
        this._runAndVerifySearchForFieldRestricted("description", "~", "'same description'");
        this._runAndVerifySearchForFieldRestricted("duedate", "=", "\"2009/07/06\"");
        this._runAndVerifySearchForFieldRestricted("environment", "~", "'same environment'");
        this._runAndVerifySearchForFieldRestricted("fixVersion", "=", "'New Version 4'");
        this._runAndVerifySearchForFieldRestricted("Free Text Field CF", "~", "'free text'");
        this._runAndVerifySearchForFieldRestricted("Group Picker CF", "=", "'jira-administrators'");
        this._runAndVerifySearchForFieldRestricted("Multi Checkboxes CF", "=", "'check 1'");
        this._runAndVerifySearchForFieldRestricted("Multi Group Picker CF", "=", "'jira-administrators'");
        this._runAndVerifySearchForFieldRestricted("Multi Select CF", "=", "'opt 1'");
        this._runAndVerifySearchForFieldRestricted("Multi User Picker CF", "=", "admin");
        this._runAndVerifySearchForFieldRestricted("Number Field CF", "=", "1");
        this._runAndVerifySearchForFieldRestricted("Project Picker CF", "=", "Invisible");
        this._runAndVerifySearchForFieldRestricted("Radio Buttons CF", "=", "'Radio Option 1'");
        this._runAndVerifySearchForFieldRestricted("resolution", "=", "Fixed");
        this._runAndVerifySearchForFieldRestricted("Select List CF", "=", "\"option 1\"");
        this._runAndVerifySearchForFieldRestricted("Single Version Picker CF", "=", "'New Version 1'");
        this._runAndVerifySearchForFieldRestricted("Text Field 255", "~", "'text 255'");
        this._runAndVerifySearchForFieldRestricted("URL Field CF", "=", "'http://google.com'");
        this._runAndVerifySearchForFieldRestricted("User Picker CF", "=", "admin");
        this._runAndVerifySearchForFieldRestricted("Version Picker CF", "=", "'New Version 4'");
        this.assertSearchWithResults("priority = \"Major\"", "HSP-2", "HSP-1");
        this.assertSearchWithResults("reporter = \"admin\"", "HSP-2", "HSP-1");
        this.administration.permissionSchemes().scheme("Default Permission Scheme").removePermission(10, "jira-users");
        this._rundAndVerifyFieldDoesntExist("affectedVersion", "=", "'New Version 1'");
        this._rundAndVerifyFieldDoesntExist("assignee", "=", "admin");
        this._rundAndVerifyFieldDoesntExist("Cascading Select CF", "in", "(\"Parent Option 1\", \"Child Option 1\")");
        this._rundAndVerifyFieldDoesntExist("component", "=", "\"New Component 1\"");
        this._rundAndVerifyFieldDoesntExist("description", "~", "'same description'");
        this._rundAndVerifyFieldDoesntExist("duedate", "=", "\"2009/07/06\"");
        this._rundAndVerifyFieldDoesntExist("environment", "~", "'same environment'");
        this._rundAndVerifyFieldDoesntExist("fixVersion", "=", "'New Version 4'");
        this._rundAndVerifyFieldDoesntExist("Free Text Field CF", "~", "'free text'");
        this._rundAndVerifyFieldDoesntExist("Group Picker CF", "=", "'jira-administrators'");
        this._rundAndVerifyFieldDoesntExist("Multi Checkboxes CF", "=", "'check 1'");
        this._rundAndVerifyFieldDoesntExist("Multi Group Picker CF", "=", "'jira-administrators'");
        this._rundAndVerifyFieldDoesntExist("Multi Select CF", "=", "'opt 1'");
        this._rundAndVerifyFieldDoesntExist("Multi User Picker CF", "=", "admin");
        this._rundAndVerifyFieldDoesntExist("Number Field CF", "=", "1");
        this._rundAndVerifyFieldDoesntExist("Project Picker CF", "=", "Invisible");
        this._rundAndVerifyFieldDoesntExist("Radio Buttons CF", "=", "'Radio Option 1'");
        this._rundAndVerifyFieldDoesntExist("resolution", "=", "Fixed");
        this._rundAndVerifyFieldDoesntExist("Select List CF", "=", "\"option 1\"");
        this._rundAndVerifyFieldDoesntExist("Single Version Picker CF", "=", "'New Version 1'");
        this._rundAndVerifyFieldDoesntExist("Text Field 255", "~", "'text 255'");
        this._rundAndVerifyFieldDoesntExist("URL Field CF", "=", "'http://google.com'");
        this._rundAndVerifyFieldDoesntExist("User Picker CF", "=", "admin");
        this._rundAndVerifyFieldDoesntExist("Version Picker CF", "=", "'New Version 4'");
        this._runFilterAndVerifyFieldDoesntExist("affectedVersion", 10000);
        this._runFilterAndVerifyFieldDoesntExist("assignee", 10001);
        this._runFilterAndVerifyFieldDoesntExist("component", 10003);
        this._runFilterAndVerifyFieldDoesntExist("description", 10004);
        this._runFilterAndVerifyFieldDoesntExist("duedate", 10005);
        this._runFilterAndVerifyFieldDoesntExist("environment", 10006);
        this._runFilterAndVerifyFieldDoesntExist("fixVersion", 10007);
        this._runFilterAndVerifyFieldDoesntExist("Free Text Field CF", 10008);
        this._runFilterAndVerifyFieldDoesntExist("Group Picker CF", 10009);
        this._runFilterAndVerifyFieldDoesntExist("Multi Checkboxes CF", 10010);
        this._runFilterAndVerifyFieldDoesntExist("Multi Group Picker CF", 10011);
        this._runFilterAndVerifyFieldDoesntExist("Multi Select CF", 10012);
        this._runFilterAndVerifyFieldDoesntExist("Multi User Picker CF", 10013);
        this._runFilterAndVerifyFieldDoesntExist("Number Field CF", 10014);
        this._runFilterAndVerifyFieldDoesntExist("Project Picker CF", 10015);
        this._runFilterAndVerifyFieldDoesntExist("Radio Buttons CF", 10016);
        this._runFilterAndVerifyFieldDoesntExist("resolution", 10017);
        this._runFilterAndVerifyFieldDoesntExist("Select List CF", 10018);
        this._runFilterAndVerifyFieldDoesntExist("Single Version Picker CF", 10019);
        this._runFilterAndVerifyFieldDoesntExist("Text Field 255", 10020);
        this._runFilterAndVerifyFieldDoesntExist("URL Field CF", 10021);
        this._runFilterAndVerifyFieldDoesntExist("User Picker CF", 10022);
        this._runFilterAndVerifyFieldDoesntExist("Version Picker CF", 10023);
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10002");
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Field 'Cascading Select CF' does not exist or you do not have permission to view it.");
    }

    public void testMakeFieldsOutOfScope() throws Exception {
        this._testMakeFieldOutOfScope("Cascading Select CF", "in", "cascadeOption(\"Parent Option 1\", \"Child Option 1\")", "10001", "10011");
        this._testMakeFieldOutOfScope("Free Text Field CF", "~", "'free text'", "10010", "10020");
        this._testMakeFieldOutOfScope("Group Picker CF", "=", "'jira-administrators'", "10011", "10021");
        this._testMakeFieldOutOfScope("Multi Checkboxes CF", "=", "'check 1'", "10012", "10022");
        this._testMakeFieldOutOfScope("Multi Group Picker CF", "=", "'jira-administrators'", "10013", "10023");
        this._testMakeFieldOutOfScope("Multi Select CF", "=", "'opt 1'", "10014", "10024");
        this._testMakeFieldOutOfScope("Multi User Picker CF", "=", "admin", "10015", "10025");
        this._testMakeFieldOutOfScope("Number Field CF", "=", "1", "10003", "10013");
        this._testMakeFieldOutOfScope("Project Picker CF", "=", "Invisible", "10016", "10026");
        this._testMakeFieldOutOfScope("Radio Buttons CF", "=", "'Radio Option 1'", "10017", "10027");
        this._testMakeFieldOutOfScope("Select List CF", "=", "\"option 1\"", "10000", "10010");
        this._testMakeFieldOutOfScope("Single Version Picker CF", "=", "'New Version 1'", "10018", "10028");
        this._testMakeFieldOutOfScope("Text Field 255", "~", "'text 255'", "10019", "10029");
        this._testMakeFieldOutOfScope("URL Field CF", "=", "'http://google.com'", "10020", "10030");
        this._testMakeFieldOutOfScope("User Picker CF", "=", "admin", "10002", "10012");
        this._testMakeFieldOutOfScope("Version Picker CF", "=", "'New Version 4'", "10021", "10031");
    }

    public void testMakeNumberFieldCFOutOfScopeByIssueType() throws Exception {
        this.assertSearchWithResults("\"Number Field CF\" = 1", "MKY-1", "HSP-1");
        this.assertSearchWithResults("\"Number Field CF\" is empty", "MKY-2", "HSP-2");
        this.administration.customFields().editConfigurationSchemeContextById("10003", "10013", null, new String[]{"4"}, new String[]{"10000"});
        this.administration.reIndex();
        this.navigation.issueNavigator().createSearch("\"Number Field CF\" = 1");
        this.tester.assertTextPresent("No matching issues found.");
        this.navigation.issueNavigator().createSearch("\"Number Field CF\" is empty");
        this.tester.assertTextPresent("No matching issues found.");
    }

    public void testHidePriority() throws Exception {
        this.assertSearchWithResults("priority = \"Major\"", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.administration.fieldConfigurations().fieldConfiguration("Hide Stuff Configuration").hideFields("Priority");
        this.administration.reIndex();
        this.assertSearchWithResults("priority = \"Major\"", "HSP-2", "HSP-1");
    }

    public void testHideReporter() throws Exception {
        this.assertSearchWithResults("reporter = \"admin\"", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.administration.fieldConfigurations().fieldConfiguration("Hide Stuff Configuration").hideFields("Reporter");
        this.administration.reIndex();
        this.assertSearchWithResults("reporter = \"admin\"", "HSP-2", "HSP-1");
    }

    public void testValidValuesBasedOnBrowseProjectPermission() throws Exception {
        String jqlAffectedVersion = this.createJqlQuery("affectedVersion", "New Version 1", "New Version 2");
        this.assertSearchWithResults(jqlAffectedVersion, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10030);
        String jqlComponents = this.createJqlQuery("component", "New Component 1", "New Component 4");
        this.assertSearchWithResults(jqlComponents, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10031);
        String jqlFixVersion = this.createJqlQuery("fixVersion", "New Version 4", "New Version 2");
        this.assertSearchWithResults(jqlFixVersion, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10032);
        String jqlLevel = this.createJqlQuery("level", "Example Level 1", "Example Level 3");
        this.assertSearchWithResults(jqlLevel, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10033);
        String jqlProject = this.createJqlQuery("project", "Monkey", "Homosapien");
        this.assertSearchWithResults(jqlProject, "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10034");
        this.assertIssues("HSP-1", "HSP-2", "MKY-1", "MKY-2");
        String jqlProjectPicker = this.createJqlQuery("Project Picker CF", "Monkey", "Invisible");
        this.assertSearchWithResults(jqlProjectPicker, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10035);
        String jqlVersionPicker = this.createJqlQuery("Version Picker CF", "New Version 1", "New Version 2");
        this.assertSearchWithResults(jqlVersionPicker, "MKY-1", "HSP-1");
        this._runFilterAndVerifySearchNoRestrictions(10036);
        this.administration.permissionSchemes().scheme("Custom Permission Scheme").removePermission(10, "jira-users");
        this.assertInvalidValue("affectedVersion", "New Version 1", "New Version 2");
        this._runFilterAndVerifySearchRestricted(10030, "affectedVersion", "New Version 2");
        this.assertInvalidValue("component", "New Component 1", "New Component 4");
        this._runFilterAndVerifySearchRestricted(10031, "component", "New Component 4");
        this.assertInvalidValue("fixVersion", "New Version 4", "New Version 2");
        this._runFilterAndVerifySearchRestricted(10032, "fixVersion", "New Version 2");
        this.assertInvalidValue("level", "Example Level 1", "Example Level 3");
        this._runFilterAndVerifySearchRestricted(10033, "level", "Example Level 3");
        this.assertInvalidValue("project", "Homosapien", "Monkey");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10034");
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '10001' does not exist for the field 'project'.");
        this.assertInvalidValue("Project Picker CF", "Invisible", "Monkey");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10035");
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '10001' does not exist for the field 'Project Picker CF'.");
        this.assertInvalidValue("Version Picker CF", "New Version 1", "New Version 2");
        this._runFilterAndVerifySearchRestricted(10036, "Version Picker CF", "New Version 2");
    }

    public void testValidValuesForParentClause() throws Exception {
        String subTaskMKY = this.navigation.issue().createSubTask("MKY-1", "Sub-task", "blub", "blah");
        String subTaskHSP = this.navigation.issue().createSubTask("HSP-1", "Sub-task", "blub", "blah");
        String jqlParent = this.createJqlQuery("parent", "MKY-1", "HSP-1");
        this.assertSearchWithResults(jqlParent, subTaskMKY, subTaskHSP);
        this._runFilterAndVerifySearchNoRestrictions(10037);
        this.administration.permissionSchemes().scheme("Custom Permission Scheme").removePermission(10, "jira-users");
        this.assertSearchWithError(this.createJqlQuery("parent", "HSP-1", "MKY-1"), "An issue with key 'MKY-1' does not exist for field 'parent'.");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10037");
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '10001' does not exist for the field 'parent'.");
    }

    private String createJqlQuery(String clauseName, String value1, String value2) {
        return "\"" + clauseName + "\" = \"" + value1 + "\" OR \"" + clauseName + "\" = \"" + value2 + "\"";
    }

    private void assertInvalidValue(String fieldName, String value1, String invalidValue) {
        this.assertSearchWithError(this.createJqlQuery(fieldName, value1, invalidValue), "The value '" + invalidValue + "' does not exist for the field '" + fieldName + "'.");
    }

    private void _testHideField(String fieldName, String operator, String fieldValue) {
        this._testHideField(fieldName, operator, fieldValue, fieldName);
    }

    private void _testHideField(String fieldClauseName, String operator, String fieldValue, String fieldConfigName) {
        this._runAndVerifySearchForFieldNoRestrictions(fieldClauseName, operator, fieldValue);
        this.administration.fieldConfigurations().fieldConfiguration("Hide Stuff Configuration").hideFields(fieldConfigName);
        this.administration.reIndex();
        this._runAndVerifySearchForFieldRestricted(fieldClauseName, operator, fieldValue);
    }

    private void _testMakeFieldOutOfScope(String fieldName, String operator, String fieldValue, String customFieldId, String fieldConfigSchemeId) {
        this._runAndVerifySearchForFieldNoRestrictions(fieldName, operator, fieldValue);
        this.administration.customFields().editConfigurationSchemeContextById(customFieldId, fieldConfigSchemeId, null, null, new String[]{"10000"});
        this.administration.reIndex();
        this._runAndVerifySearchForFieldRestricted(fieldName, operator, fieldValue);
    }

    private void _runAndVerifySearchForFieldRestricted(String fieldName, String operator, String fieldValue) {
        this.assertSearchWithResults("\"" + fieldName + "\" " + operator + " " + fieldValue, "HSP-1");
        this.assertSearchWithResults("\"" + fieldName + "\" is empty", "HSP-2");
    }

    private void _runAndVerifySearchForFieldNoRestrictions(String fieldName, String operator, String fieldValue) {
        this.assertSearchWithResults("\"" + fieldName + "\" " + operator + " " + fieldValue, "MKY-1", "HSP-1");
        this.assertSearchWithResults("\"" + fieldName + "\" is empty", "MKY-2", "HSP-2");
    }

    private void _rundAndVerifyFieldDoesntExist(String fieldName, String operator, String fieldValue) {
        this.assertSearchWithError("\"" + fieldName + "\" " + operator + " " + fieldValue, "Field '" + fieldName + "' does not exist or you do not have permission to view it.");
    }

    private void _runFilterAndVerifySearchNoRestrictions(int filterId) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        this.assertIssues("HSP-1", "MKY-1");
    }

    private void _runFilterAndVerifySearchRestricted(int filterId) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        this.assertIssues("HSP-1");
    }

    private void _runFilterAndVerifySearchRestricted(int filterId, String fieldName, String invalidValue) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value '" + invalidValue + "' does not exist for the field '" + fieldName + "'.");
    }

    private void _runFilterAndVerifyFieldDoesntExist(String field, int filterId) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        TestSearchConstrainedByConfiguration.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Field '" + field + "' does not exist or you do not have permission to view it.");
    }
}

