/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSanitiseSearchFilter
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSanitiseSearchFilter.xml");
    }

    public void testSanitiseIssueClause() throws Exception {
        this.runFilterWithIdAndVerifyJQL(10030, "Issue = \"ABC-4\" order by key ASC", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10031, "Issue != \"ABC-4\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10032, "Issue in (\"ABC-4\",\"ABC-3\")", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10033, "Issue not in (\"ABC-4\",\"ABC-3\")", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10034, "Issue <= \"ABC-4\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10035, "Issue < \"ABC-4\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10036, "Issue < \"ABC-3\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10037, "Issue >= \"ABC-1\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10038, "Issue > \"ABC-1\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10039, "Issue > \"ABC-4\"", "fieldJqlQuery");
        this.navigation.login("fred");
        this.runFilterWithIdAndVerifySanitisedJQL(10030, "Issue = 10015", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10031, "Issue != 10015", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10032, "Issue in (10015, ABC-3)", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10033, "Issue not in (10015, ABC-3)", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10034, "Issue <= 10015", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10035, "Issue < 10015", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifySanitisedJQL(10039, "Issue > 10015", "A value with ID '10015' does not exist for the field 'Issue'");
        this.runFilterWithIdAndVerifyJQL(10036, "Issue < \"ABC-3\"", "fieldJqlQuery");
        this.assertIssues("ABC-1", "ABC-2");
        this.runFilterWithIdAndVerifyJQL(10037, "Issue >= \"ABC-1\"", "fieldJqlQuery");
        this.assertIssues("ABC-1", "ABC-2", "ABC-3");
        this.runFilterWithIdAndVerifyJQL(10038, "Issue > \"ABC-1\"", "fieldJqlQuery");
        this.assertIssues("ABC-2", "ABC-3");
    }

    public void testSanitiseParentClause() throws Exception {
        this.runFilterWithIdAndVerifyJQL(10040, "Parent = \"MKY-1\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10041, "Parent != \"MKY-1\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10042, "Parent in (\"MKY-1\",\"HSP-1\")", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10043, "Parent not in (\"MKY-1\",\"HSP-1\")", "fieldJqlQuery");
        this.navigation.login("fred");
        this.runFilterWithIdAndVerifyJQL(10040, "Parent = \"MKY-1\"", "fieldJqlQuery");
        this.assertIssues("MKY-2");
        this.runFilterWithIdAndVerifyJQL(10041, "Parent != \"MKY-1\"", "fieldJqlQuery");
        this.assertIssues("ABC-1", "ABC-2", "ABC-3", "MKY-1");
        this.runFilterWithIdAndVerifySanitisedJQL(10042, "Parent in (MKY-1, 10000)", "A value with ID '10000' does not exist for the field 'Parent'");
        this.runFilterWithIdAndVerifySanitisedJQL(10043, "Parent not in (MKY-1, 10000)", "A value with ID '10000' does not exist for the field 'Parent'");
    }

    public void testSanitiseProjectClause() throws Exception {
        this.runFilterWithIdAndVerifyJQL(10044, "homosapien", "fieldpid");
        this.runFilterWithIdAndVerifyJQL(10045, "Project != \"Homosapien\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10046, "homosapien, monkey", "fieldpid");
        this.runFilterWithIdAndVerifyJQL(10047, "Project not in (\"Homosapien\",\"Monkey\")", "fieldJqlQuery");
        this.navigation.login("fred");
        this.runFilterWithIdAndVerifySanitisedJQL(10044, "Project = 10000", "A value with ID '10000' does not exist for the field 'Project'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10045, "Project != 10000", "A value with ID '10000' does not exist for the field 'Project'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10046, "Project in (10000, Monkey) ORDER BY type ASC", "A value with ID '10000' does not exist for the field 'Project'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10047, "Project not in (10000, Monkey)", "A value with ID '10000' does not exist for the field 'Project'.");
    }

    public void testSanitiseProjectPickerClause() throws Exception {
        this.runFilterWithIdAndVerifyJQL(10050, "homosapien", "fieldcustomfield_10000");
        this.runFilterWithIdAndVerifyJQL(10051, "ProjectPicker != \"Homosapien\"", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10052, "ProjectPicker in (\"Homosapien\", \"Monkey\")", "fieldJqlQuery");
        this.runFilterWithIdAndVerifyJQL(10053, "ProjectPicker not in (\"Homosapien\", \"Monkey\")", "fieldJqlQuery");
        this.navigation.login("fred");
        this.runFilterWithIdAndVerifySanitisedJQL(10050, "ProjectPicker = 10000", "A value with ID '10000' does not exist for the field 'ProjectPicker'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10051, "ProjectPicker != 10000", "A value with ID '10000' does not exist for the field 'ProjectPicker'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10052, "ProjectPicker in (10000, Monkey)", "A value with ID '10000' does not exist for the field 'ProjectPicker'.");
        this.runFilterWithIdAndVerifySanitisedJQL(10053, "ProjectPicker not in (10000, Monkey)", "A value with ID '10000' does not exist for the field 'ProjectPicker'.");
    }

    private void runFilterWithIdAndVerifyJQL(int filterId, String jqlString, String id) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        this.text.assertTextPresent(new IdLocator(this.tester, id), jqlString);
    }

    private void runFilterWithIdAndVerifySanitisedJQL(int filterId, String jqlString, String ... errors) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        this.text.assertTextPresent(new IdLocator(this.tester, "fieldJqlQuery"), jqlString);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.text.assertTextPresent(new IdLocator(this.tester, "jqltext"), jqlString);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errors);
    }
}

