/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestQueryTooComplex
extends FuncTestCase {
    private static final int CLAUSES = 70000;
    private String reallyBloodyLongQuery;
    private String statusjQlQuery;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.reallyBloodyLongQuery = this.createLongQuery();
        this.statusjQlQuery = "status was Open";
    }

    private String createLongQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("comment ~ monkey");
        for (int i = 0; i < 70000; ++i) {
            stringBuilder.append(" and comment ~ ").append(i);
        }
        return stringBuilder.toString();
    }

    public void testNewAdvancedSearchTooComplex() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.issueNavigator().createSearch(this.reallyBloodyLongQuery);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("One of the clauses in your search matches too many results. If a clause returns too many results, the entire search will fail. Please try refining or removing the clauses in your search and run it again.");
    }

    public void testSavedFilterTooComplex() throws Exception {
        this.administration.restoreData("TestQueryTooComplex.xml");
        this.navigation.manageFilters().goToDefault();
        this.text.assertTextPresent(new XPathLocator(this.tester, "//tr[@id='mf_10000']"), "Too Complex");
        this.tester.clickLink("filterlink_10000");
        TestQueryTooComplex.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        TestQueryTooComplex.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.EDIT), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("One of the clauses in your search matches too many results. If a clause returns too many results, the entire search will fail. Please try refining or removing the clauses in your search and run it again.");
    }

    public void testSearchRequestView() throws Exception {
        this.administration.restoreData("TestQueryTooComplex.xml");
        this.viewSearchRequestViewForSearchFilter(10000, 400, "One of the clauses in your search matches too many results. If a clause returns too many results, the entire search will fail. Please try refining or removing the clauses in your search and run it again.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewSearchRequestViewForSearchFilter(int filterId, int responseCode, String errorMessage) {
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=1000");
            WebResponse response = this.tester.getDialog().getResponse();
            TestQueryTooComplex.assertEquals((int)responseCode, (int)response.getResponseCode());
            this.tester.assertTextPresent(errorMessage);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    public void testChangeHistoryJqlTooComplex() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.issueNavigator().createSearch(this.statusjQlQuery);
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }
}

