/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebTable;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.TIME_ZONES})
public class TestJqlSearchWithTimeZones
extends AbstractJqlFuncTest {
    public static final String BERLIN_USER = "berlin";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestJqlSearchWithTimeZones.xml");
        this.administration.generalConfiguration().setDefaultUserTimeZone("Australia/Sydney");
    }

    public void testSearchResultsInIssueNavigatorSydneyTimeZone() throws Exception {
        String jqlString = "project = Bovine";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "17/Apr/11", "20/Apr/11", "04/Apr/11", "20/Apr/11", "13/Apr/11", "12/Apr/11 2:00 AM")));
        Assert.assertThat(this.issueNavigatorRow(2), CoreMatchers.equalTo(this.row("COW-15", "19/Apr/11", "18/Apr/11", "21/Apr/11", "", "", "")));
    }

    public void testSearchResultsInIssueNavigatorBerlinTimeZone() throws Exception {
        String jqlString = "project = Bovine";
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
        Assert.assertThat(this.issueNavigatorRow(2), CoreMatchers.equalTo(this.row("COW-15", "18/Apr/11", "17/Apr/11", "21/Apr/11", "", "", "")));
    }

    public void testSearchResultsInIssueNavigatorGMTMinus12TimeZone() throws Exception {
        String jqlString = "project = Bovine";
        this.navigation.login("gmtminus12");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 4:00 AM")));
        Assert.assertThat(this.issueNavigatorRow(2), CoreMatchers.equalTo(this.row("COW-15", "18/Apr/11", "17/Apr/11", "21/Apr/11", "", "", "")));
    }

    public void testJqlForCreatedDateField() throws Exception {
        String jqlString = "project = Bovine and createdDate < \"2011-04-17\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        TestJqlSearchWithTimeZones.assertNull((Object)table);
        this.tester.assertTextPresent("No matching issues found.");
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
    }

    public void testJqlForDueDateField() throws Exception {
        String jqlString = "project = Bovine and duedate = \"2011-04-04\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "17/Apr/11", "20/Apr/11", "04/Apr/11", "20/Apr/11", "13/Apr/11", "12/Apr/11 2:00 AM")));
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
    }

    public void testJqlForUpdatedField() throws Exception {
        String jqlString = "project = Bovine and updated < \"2011-04-20\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-15", "19/Apr/11", "18/Apr/11", "21/Apr/11", "", "", "")));
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
        Assert.assertThat(this.issueNavigatorRow(2), CoreMatchers.equalTo(this.row("COW-15", "18/Apr/11", "17/Apr/11", "21/Apr/11", "", "", "")));
    }

    public void testJqlForResolvedField() throws Exception {
        String jqlString = "project = Bovine and resolutiondate <= \"2011-04-20\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        TestJqlSearchWithTimeZones.assertNull((Object)table);
        this.tester.assertTextPresent("No matching issues found.");
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
    }

    public void testJqlDatePickerCustomField() throws Exception {
        String jqlString = "\"Review date\" = \"2011-04-13\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "17/Apr/11", "20/Apr/11", "04/Apr/11", "20/Apr/11", "13/Apr/11", "12/Apr/11 2:00 AM")));
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
    }

    public void testJqlDateTimeCustomField() throws Exception {
        String jqlString = "expires < \"2011-04-12\"";
        this.navigation.login("admin");
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        TestJqlSearchWithTimeZones.assertNull((Object)table);
        this.tester.assertTextPresent("No matching issues found.");
        this.navigation.login(BERLIN_USER);
        this.navigation.issueNavigator().createSearch(jqlString + " ORDER BY key DESC");
        Assert.assertThat(this.issueNavigatorRow(1), CoreMatchers.equalTo(this.row("COW-16", "16/Apr/11", "19/Apr/11", "04/Apr/11", "19/Apr/11", "13/Apr/11", "11/Apr/11 6:00 PM")));
    }

    ImmutableMap<String, String> issueNavigatorRow(int row) {
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        return ImmutableMap.builder().put((Object)"issueKey", (Object)table.getTableCell(row, 1).asText().trim()).put((Object)"createdDate", (Object)table.getTableCell(row, 8).asText().trim()).put((Object)"updatedDate", (Object)table.getTableCell(row, 9).asText().trim()).put((Object)"dueDate", (Object)table.getTableCell(row, 10).asText().trim()).put((Object)"resolvedDate", (Object)table.getTableCell(row, 11).asText().trim()).put((Object)"reviewDate", (Object)table.getTableCell(row, 12).asText().trim()).put((Object)"expires", (Object)table.getTableCell(row, 13).asText().trim()).build();
    }

    Map<String, String> row(String issueKey, String createdDate, String updatedDate, String dueDate, String resolvedDate, String reviewDate, String expires) {
        return ImmutableMap.builder().put((Object)"issueKey", (Object)issueKey).put((Object)"createdDate", (Object)createdDate).put((Object)"updatedDate", (Object)updatedDate).put((Object)"dueDate", (Object)dueDate).put((Object)"resolvedDate", (Object)resolvedDate).put((Object)"reviewDate", (Object)reviewDate).put((Object)"expires", (Object)expires).build();
    }
}

