/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestJqlIssueSecurityLevel
extends AbstractJqlFuncTest {
    private static final int ADMINISTRATOR_ROLE = 10002;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestJqlIssueSecurityLevel.xml");
    }

    public void testIssueSecurityLevel() throws Exception {
        this.assertSearchWithResults("assignee = currentUser()", "HSP-7", "HSP-6", "HSP-2", "HSP-1");
        this.navigation.login("fred");
        this.assertSearchWithResults("", "HSP-7", "HSP-6", "HSP-5", "HSP-1");
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Fred Normal");
        this.tester.submit("Assign");
        this.assertSearchWithResults("assignee = currentUser()", "HSP-7", "HSP-6", "HSP-1");
        this.navigation.login("fred");
        this.assertSearchWithResults("", "HSP-7", "HSP-6", "HSP-5", "HSP-2", "HSP-1");
        this.navigation.login("admin");
        this.administration.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.navigation.login("fred");
        this.assertSearchWithResults("", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.navigation.login("admin");
        this.administration.project().setProjectLead("homosapien", "fred");
        this.navigation.login("fred");
        this.assertSearchWithResults("", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
    }

    public void testIssueSecurityLevelClause() throws Exception {
        this.assertSearchWithError("level = \"admin project role\"", "The value 'admin project role' does not exist for the field 'level'.");
        this.administration.roles().addProjectRoleForUser("homosapien", "Administrators", "admin");
        this.assertSearchWithResults("level = \"current assignee\" or level is empty", "HSP-7", "HSP-6", "HSP-2", "HSP-1");
        this.assertSearchWithResults("level = \"group = something\" or level is empty", "HSP-7", "HSP-6", "HSP-4", "HSP-1");
        this.assertSearchWithResults("level = \"reporter\" or level is empty", "HSP-7", "HSP-6", "HSP-1");
        this.assertSearchWithError("level = \"single user = fred\" or level is empty", "The value 'single user = fred' does not exist for the field 'level'.");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Fred Normal");
        this.tester.submit("Assign");
        this.navigation.login("fred");
        this.assertSearchWithResults("level = \"single user = fred\"", new String[0]);
        this.assertSearchWithError("level = \"group = something\" or level is empty", "The value 'group = something' does not exist for the field 'level'.");
        this.assertSearchWithError("level = \"project lead\" or level is empty", "The value 'project lead' does not exist for the field 'level'.");
        this.navigation.login("admin");
        this.administration.project().setProjectLead("homosapien", "fred");
        this.navigation.login("fred");
        this.assertSearchWithResults("level = \"project lead\" or level is empty", "HSP-7", "HSP-6", "HSP-3", "HSP-1");
        this.assertSearchWithResults("level = \"reporter\" or level is empty", "HSP-7", "HSP-6", "HSP-5", "HSP-1");
        this.assertSearchWithResults("level = \"current assignee\" or level is empty", "HSP-7", "HSP-6", "HSP-2", "HSP-1");
    }
}

