/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestJqlInputFocus
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestJqlInputFocus.xml");
    }

    public void testJqlInputFocus() {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.clickLink("switchnavtype");
        this.assertJqlHasFocus(true);
        this.assertQueryWithResultingFocus("", true);
        this.assertQueryWithResultingFocus("", true);
        this.assertQueryWithResultingFocus("key > TEST-20", true);
        this.assertQueryWithResultingFocus("key > TEST-20", true);
        this.navigation.issue().gotoIssue("TEST-25");
        this.tester.clickLink("return-to-search");
        this.assertJqlHasFocus(false);
        this.assertQueryWithResultingFocus("key > TEST-10", true);
        this.tester.clickLink("viewfilter");
        this.tester.clickLink("editfilter");
        this.assertJqlHasFocus(true);
        this.tester.clickLink("new_filter");
        this.assertJqlHasFocus(true);
        this.assertQueryWithResultingFocus("key >", true);
        this.assertQueryWithResultingFocus("key >", true);
        this.assertQueryWithResultingFocus("key", true);
        this.assertQueryWithResultingFocus("key", true);
    }

    private void assertQueryWithResultingFocus(String query, boolean hasFocus) {
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", query);
        this.tester.submit();
        this.assertJqlHasFocus(hasFocus);
    }

    private void assertJqlHasFocus(boolean focused) {
        XPathLocator locator = new XPathLocator(this.tester, "//textarea[@id='jqltext' and contains(@class, 'focused')]");
        if (focused) {
            TestJqlInputFocus.assertTrue((boolean)locator.exists());
        } else {
            TestJqlInputFocus.assertFalse((boolean)locator.exists());
        }
    }
}

