/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestIssueNavigatorAdvancedUrlCombinations
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestInvalidAdvancedQuery.xml");
    }

    public void testInvalidAdvancedQuery() throws Exception {
        this.navigation.issueNavigator().gotoNavigator();
        this.navigation.issueNavigator().createSearch("project = monkey");
        this.tester.assertTextPresent("No matching issues found.");
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "project = blah");
        this.tester.submit();
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'blah' does not exist for the field 'project'.");
        this.assertJqlQuery("project = blah");
    }

    public void testUnparsableAdvancedQuery() throws Exception {
        this.navigation.issueNavigator().gotoNavigator();
        this.navigation.issueNavigator().createSearch("project = monkey");
        this.tester.assertTextPresent("No matching issues found.");
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "ljksd;fljsd;lfj;s");
        this.tester.submit();
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The character ';' is a reserved JQL character. You must enclose it in a string or use the escape '\\u003b' instead. (line 1, character 6)");
        this.assertJqlQuery("ljksd;fljsd;lfj;s");
    }

    public void testIssueNavigatorValidAdvancedQueryUrlNoActionParams() throws Exception {
        String jqlString = "jqlQuery=project+%3D+homosapien";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true");
        this.assertJqlQuery("project = homosapien");
        this.assertDisplayingIssuesText(1, 1, 1);
    }

    public void testIssueNavigatorValidAdvancedQueryUrlAndValidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+admin";
        String actionParams = "&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true" + actionParams + "&reset=true");
        this.assertJqlQuery("assignee = admin");
        this.assertDisplayingIssuesText(1, 1, 1);
    }

    public void testIssueNavigatorValidAdvancedQueryUrlAndInvalidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+admin";
        String actionParams = "&pid=10234";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true" + actionParams + "&reset=true");
        this.assertJqlQuery("assignee = admin");
        this.assertDisplayingIssuesText(1, 1, 1);
    }

    public void testIssueNavigatorInvalidAdvancedQueryUrlNoActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true");
        this.assertJqlQuery("assignee = Blah");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'Blah' does not exist for the field 'assignee'.");
    }

    public void testIssueNavigatorInvalidAdvancedQueryUrlAndValidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah";
        String actionParams = "&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + actionParams);
        this.assertJqlQuery("assignee = Blah");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'Blah' does not exist for the field 'assignee'.");
    }

    public void testIssueNavigatorInvalidAdvancedQueryUrlAndInvalidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah";
        String actionParams = "&pid=102344";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + actionParams);
        this.assertJqlQuery("assignee = Blah");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'Blah' does not exist for the field 'assignee'.");
    }

    public void testIssueNavigatorNotParseableAdvancedQueryUrlAndNoActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah+AND";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true");
        this.assertJqlQuery("assignee = Blah AND");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Expecting a field name at the end of the query.");
    }

    public void testIssueNavigatorNotParseableAdvancedQueryUrlAndValidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah+AND";
        String actionParams = "&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + actionParams);
        this.assertJqlQuery("assignee = Blah AND");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Expecting a field name at the end of the query.");
    }

    public void testIssueNavigatorNotParseableAdvancedQueryUrlAndInvalidActionParams() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blah+AND";
        String actionParams = "&pid=102344";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + actionParams);
        this.assertJqlQuery("assignee = Blah AND");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Expecting a field name at the end of the query.");
    }

    public void testIssueNavigatorDontReplaceStatement() throws Exception {
        this.navigation.issueNavigator().gotoNavigator();
        this.navigation.issueNavigator().createSearch("assignee is NULL");
        this.tester.assertTextPresent("No matching issues found.");
        this.assertJqlQuery("assignee is NULL");
    }

    public void testIssueNavigatorReplaceStatements() throws Exception {
        String jqlString = "jqlQuery=assignee+is+NULL";
        String actionParams = "&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + actionParams);
        this.assertJqlQuery("assignee is NULL");
        this.tester.assertTextPresent("No matching issues found.");
    }

    public void testIssueNavigatorValidAdvancedQueryAndSorting() throws Exception {
        String jqlString = "jqlQuery=assignee+is+NULL";
        String sorting = "&sorter/field=assignee&sorter/order=ASC";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + sorting);
        this.assertJqlQuery("assignee is NULL");
    }

    public void testIssueNavigatorInvalidAdvancedQueryAndSorting() throws Exception {
        String jqlString = "jqlQuery=assignee+%3D+Blub";
        String sorting = "&sorter/field=assignee&sorter/order=ASC";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + sorting);
        this.assertJqlQuery("assignee = Blub");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'Blub' does not exist for the field 'assignee'.");
    }

    public void testIssueNavigatorUnparsableAdvancedQueryAndSorting() throws Exception {
        String jqlString = "jqlQuery=assignee+bskldfsdkjhf+lskdfj209384";
        String sorting = "&sorter/field=assignee&sorter/order=ASC";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + sorting);
        this.assertJqlQuery("assignee bskldfsdkjhf lskdfj209384");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Expecting operator but got 'bskldfsdkjhf'. The valid operators are");
    }

    public void testIssueNavigatorUnparsableAdvancedQueryWithSorting() throws Exception {
        String jqlString = "jqlQuery=assignee+bskldfsdkjhf+lskdfj209384+ORDER+BY+assignee+ASC";
        String sorting = "&sorter/field=assignee&sorter/order=ASC&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + sorting);
        this.assertJqlQuery("assignee bskldfsdkjhf lskdfj209384 ORDER BY assignee ASC");
    }

    public void testIssueNavigatorNoAdvancedQueryWithParamFieldsAndSorting() throws Exception {
        String jqlString = "";
        String sorting = "&sorter/field=assignee&sorter/order=ASC&pid=10000";
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?" + jqlString + "&runQuery=true&reset=true" + sorting);
        this.assertJqlQuery("project = HSP ORDER BY assignee ASC");
    }

    private void assertJqlQuery(String expectedJQL) {
        XPathLocator locator = new XPathLocator(this.tester, "//textarea[@id='jqltext']");
        this.text.assertTextPresent(locator, expectedJQL);
    }

    private void assertDisplayingIssuesText(int pageStart, int pageEnd, int total) {
        this.tester.assertTextPresent(String.format("Displaying issues <span id=\"results-count-start\">%d</span> to %d of <strong id=\"results-count-total\">%d</strong> matching issues.", pageStart, pageEnd, total));
    }
}

