/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestFilters
extends FuncTestCase {
    public void testEditSomeOneElsesFilter() throws Exception {
        this.administration.restoreData("TestJqlFiltersUpdatingFilter.xml");
        this.navigation.login("fred");
        this.loadModifyFilter(10000, "reporter = admin", new String[]{"Reporter", "admin"}, new String[]{"Reload"}, new String[]{"Rename or Share", "Save", "Save as", "Subscriptions"});
    }

    public void testUpdatingFilters() throws Exception {
        this.administration.restoreData("TestJqlFiltersUpdatingFilter.xml");
        this.loadModifyFilter(10000, "reporter = admin", new String[]{"Reporter", "admin"});
        this.tester.clickLink("filtersave");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[contains(@class, 'aui')]"), "Old Search Request");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[contains(@class, 'aui')]"), "Updated Search Request");
        String q1 = "reporter = currentUser() or not assignee = admin";
        this.loadModifyFilter(10000, "reporter = currentUser() or not assignee = admin", new String[]{"JQL Query", "reporter = currentUser() or not assignee = admin"});
        this.checkJqlFilterDiff(Arrays.asList(new DiffCharSequence(DiffType.diffcontext, "reporter = currentUser()")), Arrays.asList(new DiffCharSequence(DiffType.diffcontext, "reporter = currentUser()"), new DiffCharSequence(DiffType.diffaddedchars, "or not assignee = admin")));
        this.loadModifyFilter(10001, "project = hsp", new String[]{"Project", "homosapien"});
        this.checkJqlFilterDiff(Arrays.asList(new DiffCharSequence(DiffType.diffremovedchars, "reporter"), new DiffCharSequence(DiffType.diffcontext, "="), new DiffCharSequence(DiffType.diffremovedchars, "currentUser() or assignee in membersOf(\"jira-users\")")), Arrays.asList(new DiffCharSequence(DiffType.diffaddedchars, "project"), new DiffCharSequence(DiffType.diffcontext, "="), new DiffCharSequence(DiffType.diffaddedchars, "hsp")));
        String q2 = "duedate = now() or assignee in (admin,fred)";
        this.loadModifyFilter(10001, "duedate = now() or assignee in (admin,fred)", new String[]{"JQL Query", "duedate = now() or assignee in (admin,fred)"});
        this.checkJqlFilterDiff(Arrays.asList(new DiffCharSequence(DiffType.diffremovedchars, "reporter"), new DiffCharSequence(DiffType.diffcontext, "="), new DiffCharSequence(DiffType.diffremovedchars, "currentUser"), new DiffCharSequence(DiffType.diffcontext, "() or assignee in"), new DiffCharSequence(DiffType.diffremovedchars, "membersOf"), new DiffCharSequence(DiffType.diffcontext, "("), new DiffCharSequence(DiffType.diffremovedchars, "\"jira-users\""), new DiffCharSequence(DiffType.diffcontext, ")")), Arrays.asList(new DiffCharSequence(DiffType.diffaddedchars, "duedate"), new DiffCharSequence(DiffType.diffcontext, "="), new DiffCharSequence(DiffType.diffaddedchars, "now"), new DiffCharSequence(DiffType.diffcontext, "() or assignee in"), new DiffCharSequence(DiffType.diffcontext, "("), new DiffCharSequence(DiffType.diffaddedchars, "admin,fred"), new DiffCharSequence(DiffType.diffcontext, ")")));
    }

    public void testRunFilterWithCustomFieldOptionWithNoAssociatedConfig() throws Exception {
        this.administration.restoreData("TestCustomFieldOptionsNoConfig.xml");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.assertTextPresent("No matching issues found.");
    }

    private void loadModifyFilter(int filterId, String newQuery, String[] summary) {
        this.loadModifyFilter(filterId, newQuery, summary, new String[]{"Rename or Share", "Save", "Save as", "Reload", "Subscriptions"}, new String[0]);
    }

    private void loadModifyFilter(int filterId, String newQuery, String[] summary, String[] visibleOperations, String[] hiddenOperations) {
        this.navigation.issueNavigator().loadFilter(filterId, null);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setFormElement("jqlQuery", newQuery);
        this.tester.submit();
        IdLocator editDescriptionLocator = new IdLocator(this.tester, "filter-description");
        this.text.assertTextPresent(editDescriptionLocator, "Filter modified since loading");
        this.navigation.issueNavigator().gotoViewMode();
        IdLocator viwDescriptionLocator = new IdLocator(this.tester, "filter-description");
        this.text.assertTextPresent(viwDescriptionLocator, "Filter modified since loading");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), summary);
        this.assertions.getTextAssertions().assertTextSequence(new IdLocator(this.tester, "filteroperations"), visibleOperations);
        for (String operation : hiddenOperations) {
            this.assertions.getTextAssertions().assertTextNotPresent(new IdLocator(this.tester, "filteroperations"), operation);
        }
    }

    private void checkJqlFilterDiff(List<DiffCharSequence> expectedOldSearchRequest, List<DiffCharSequence> expectedUpdatedSearchRequest) {
        this.tester.clickLink("filtersave");
        this.assertDiffSequence(new XPathLocator(this.tester, "//*[@id=\"dbJqlQuery\"]/span"), expectedOldSearchRequest);
        this.assertDiffSequence(new XPathLocator(this.tester, "//*[@id=\"currentJqlQuery\"]/span"), expectedUpdatedSearchRequest);
    }

    private void assertDiffSequence(XPathLocator xPathLocator, List<DiffCharSequence> diffSequenceList) {
        Node[] nodes = xPathLocator.getNodes();
        TestFilters.assertEquals((int)diffSequenceList.size(), (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            String expectedString = diffSequenceList.get((int)i).sequence;
            String actualString = DomKit.getRawText(nodes[i]);
            String whitespaceNormalized = actualString.replaceAll("[\\s\\xa0]+", " ").trim();
            TestFilters.assertEquals((String)expectedString, (String)whitespaceNormalized);
            String expectedType = diffSequenceList.get((int)i).type.toString();
            String actualType = DomKit.getRawText(nodes[i].getAttributes().getNamedItem("class"));
            TestFilters.assertEquals((String)expectedType, (String)actualType);
        }
    }

    public void testInvalidatedFilters() throws Exception {
        this.administration.restoreData("TestJqlFilters.xml");
        this.loadInvalidatedJqlFilter(10000, "project = homosapien", "The value 'homosapien' does not exist for the field 'project'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10001, "issuetype = Bug", "The value 'Bug' does not exist for the field 'issuetype'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10010, "resolution = Duplicate", "The value 'Duplicate' does not exist for the field 'resolution'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10011, "votes > 0", "Field 'votes' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10014, "workratio = 10", "Field 'workratio' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10020, "affectedVersion = \"1.0\"", "The value '1.0' does not exist for the field 'affectedVersion'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10021, "fixVersion = \"1.0\"", "The value '1.0' does not exist for the field 'fixVersion'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10022, "status = \"Not Used\"", "The value 'Not Used' does not exist for the field 'status'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10023, "key = \"MKY-1\"", "An issue with key 'MKY-1' does not exist for field 'key'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10024, "component = CompA", "The value 'CompA' does not exist for the field 'component'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10025, "issue in watchedIssues()", "Function 'watchedIssues' cannot be called as watching issues is currently disabled.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10026, "issue in votedIssues()", "Function 'votedIssues' cannot be called as voting on issues is currently disabled.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10027, "issue in linkedIssues(\"MKY-2\")", "Function 'linkedIssues' cannot be called as issue linking is currently disabled.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10028, "parent = \"MKY-2\"", "Field 'parent' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedFilter(10029, "type in standardIssueTypes()", "Function 'standardIssueTypes' is invalid as sub-tasks are currently disabled.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedFilter(10030, "type in subtaskIssueTypes()", "Function 'subTaskIssueTypes' is invalid as sub-tasks are currently disabled.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10032, "filter = 10031", "A value with ID '10031' does not exist for the field 'filter'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10034, "originalEstimate >= 5h", "Field 'originalEstimate' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10035, "remainingEstimate > 5h", "Field 'remainingEstimate' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10036, "timespent > 5h", "Field 'timespent' does not exist or you do not have permission to view it.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10038, "affectedVersion in releasedVersions(deleted)", "Could not resolve the project 'deleted' provided to function 'releasedVersions'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10039, "affectedVersion in unreleasedVersions(deleted)", "Could not resolve the project 'deleted' provided to function 'unreleasedVersions'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10040, "level = SL1", "The value 'SL1' does not exist for the field 'level'.", IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.loadInvalidatedJqlFilter(10012, "reporter = fred", "Could not find username: fred", IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.loadInvalidatedJqlFilter(10013, "assignee = fred", "Could not find username: fred", IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.loadInvalidatedJqlFilter(10033, "reporter in membersOf(\"jira-developers\")", "Could not find group: jira-developers", IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
    }

    public void testIllegalFilters() throws Exception {
        this.administration.restoreData("TestJqlIllegalFilters.xml");
        this.navigation.issueNavigator().loadFilter(10000L, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The operator '~' is not supported by the 'cs' field.");
    }

    public void testInvalidateFilterCascadeSelect() throws Exception {
        this.administration.restoreBlankInstance();
        this.addCustomField("myfield", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.navigation.issue().createIssue("monkey", "Bug", "bug 1");
        this.navigation.issueNavigator().createSearch("myfield in cascadeOption(\"None\")");
        long cssFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("css", "exact text search", false, null);
        this.navigation.issueNavigator().loadFilter(cssFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.addCustomField("myfield", "com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        this.assertInvalidFilterWithIssueKeys(cssFilterId, "myfield in cascadeOption(\"None\")", "The operator 'in' is not supported by the 'myfield' field.", "MKY-1");
    }

    public void testInvalidateFilterOperands() throws Exception {
        this.administration.restoreBlankInstance();
        this.addCustomField("myfield", "com.atlassian.jira.plugin.system.customfieldtypes:url");
        String issue = this.navigation.issue().createIssue("monkey", "Bug", "bug 1");
        this.navigation.issue().setFreeTextCustomField(issue, "customfield_10000", "http://www.example.com");
        this.navigation.issue().createIssue("monkey", "Bug", "bug 2");
        this.navigation.issueNavigator().createSearch("myfield = 'http://www.example.com'");
        long exactTextFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("field", "exact text search", false, null);
        this.navigation.issueNavigator().loadFilter(exactTextFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.addCustomField("myfield", "com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        this.assertInvalidFilterWithIssueKeys(exactTextFilterId, "myfield = 'http://www.example.com'", "The operator '=' is not supported by the 'myfield' field.", "MKY-1");
        this.addCustomField("myfield_2", "com.atlassian.jira.plugin.system.customfieldtypes:float");
        this.navigation.issue().setFreeTextCustomField(issue, "customfield_10002", "5");
        this.navigation.issueNavigator().createSearch("myfield_2 > 0");
        long gtFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("myfield2", "relational search", false, null);
        this.navigation.issueNavigator().createSearch("myfield_2 >= 0");
        long gteFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("myfield gte", "relational search", false, null);
        this.navigation.issueNavigator().createSearch("myfield_2 < 10");
        long ltFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("myfield lt", "relational search", false, null);
        this.navigation.issueNavigator().createSearch("myfield_2 <= 10");
        long lteFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("myfield lte", "relational search", false, null);
        this.navigation.issueNavigator().loadFilter(gtFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.navigation.issueNavigator().loadFilter(gteFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.navigation.issueNavigator().loadFilter(ltFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.navigation.issueNavigator().loadFilter(lteFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.addCustomField("myfield_2", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.assertInvalidFilterWithIssueKeys(gtFilterId, "myfield_2 > 0", "The operator '>' is not supported by the 'myfield_2' field.", "MKY-1");
        this.assertInvalidFilterWithIssueKeys(gteFilterId, "myfield_2 >= 0", "The operator '>=' is not supported by the 'myfield_2' field.", "MKY-1");
        this.assertInvalidFilterWithIssueKeys(ltFilterId, "myfield_2 < 10", "The operator '<' is not supported by the 'myfield_2' field.", "MKY-1");
        this.assertInvalidFilterWithIssueKeys(lteFilterId, "myfield_2 <= 10", "The operator '<=' is not supported by the 'myfield_2' field.", "MKY-1");
        this.addCustomField("myfield_3", "com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        this.navigation.issue().setFreeTextCustomField(issue, "customfield_10004", "freetext");
        this.navigation.issueNavigator().createSearch("myfield_3 ~ freetext");
        long likeFilterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("myfield3", "like search", false, null);
        this.navigation.issueNavigator().loadFilter(likeFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-1");
        this.addCustomField("myfield_3", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.assertInvalidFilterWithIssueKeys(likeFilterId, "myfield_3 ~ freetext", "The operator '~' is not supported by the 'myfield_3' field.", "MKY-1");
    }

    private void assertInvalidFilterWithIssueKeys(long filterId, String jql, String errorMessage, String ... issueKeys) {
        this.loadInvalidatedJqlFilter((int)filterId, jql, errorMessage, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.navigation.issueNavigator().loadFilter(filterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(issueKeys);
    }

    private void addCustomField(String fieldName, String customFieldName) {
        this.administration.customFields().addCustomField(customFieldName, fieldName);
        this.administration.reIndex();
    }

    public void testValidSimpleFiltersSummary() throws Exception {
        this.administration.restoreData("TestJqlFilters.xml");
        this.loadFilterAndCheckSummary(10050, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, "Project", "monkey", "Reporter", "admin");
        this.loadFilterAndCheckSummary(10050, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, "Project", "monkey", "Reporter", "admin");
    }

    public void testValidComplexFiltersSummary() throws Exception {
        this.administration.restoreData("TestJqlFilters.xml");
        this.loadFilterAndCheckSummary(10060, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, "JQL Query", "issuetype = 3 or fixVersion = 10030");
        this.loadFilterAndCheckSummary(10060, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, "JQL Query", "issuetype = 3 or fixVersion = 10030");
    }

    private void loadFilterAndCheckSummary(int filterId, IssueNavigatorNavigation.NavigatorEditMode fromMode, String ... summary) {
        this.navigation.issueNavigator().gotoNewMode(fromMode);
        this.navigation.issueNavigator().loadFilter(filterId, null);
        TestFilters.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), summary);
    }

    private void loadInvalidatedJqlFilter(int filterId, String jqlQuery, String errorMessage, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode) {
        this.loadInvalidatedFilter(filterId, jqlQuery, errorMessage, expectedEditMode);
    }

    private void loadInvalidatedFilter(int filterId, String summary, String errorMessage, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode) {
        this.navigation.issueNavigator().createSearch("");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().loadFilter(filterId, null);
        TestFilters.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.text.assertTextSequence(new IdLocator(this.tester, "issue-filter"), "Edit", "the current filter to correct errors");
        this.tester.clickLink("editfilter");
        TestFilters.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.EDIT), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        TestFilters.assertEquals((Object)((Object)expectedEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        if (this.navigation.issueNavigator().getCurrentEditMode().equals((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED)) {
            this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
            this.text.assertTextPresent(new XPathLocator(this.tester, "//textarea[@id='jqltext']"), summary);
        } else {
            this.text.assertTextPresent(this.tester.getDialog().getResponseText(), errorMessage);
        }
    }

    class DiffCharSequence {
        final DiffType type;
        final String sequence;

        public DiffCharSequence(DiffType type, String sequence) {
            this.type = type;
            this.sequence = sequence;
        }
    }

    static enum DiffType {
        diffremovedchars,
        diffcontext,
        diffaddedchars;

    }
}

