/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestAdvancedValidation
extends FuncTestCase {
    private static final int MAX_ERRORS = 10;

    public void testFunctionsInListCustomFields() throws Exception {
        this.administration.restoreData("TestAllCustomFields.xml");
        this._testOptionFieldFunctionInList("cascadeselect");
        this._testOptionFieldFunctionInList("multiselect");
        this._testOptionFieldFunctionInList("multiselectlist");
        this._testOptionFieldFunctionInList("multicheckboxes");
        this._testOptionFieldFunctionInList("radiobuttons");
        this._testOptionFieldFunctionInList("selectlist");
        this._testNumberFieldFunctionInList("numberfield");
        this._testNumberFieldFunctionInList("numberrange");
        this._testFieldFunctionInList("projectpicker");
        this._testGroupFieldFunctionInList("grouppicker");
        this._testGroupFieldFunctionInList("multigrouppicker");
        this._testDateFieldFunctionInList("datetime");
        this._testRelativeDateFieldFunctionInList("datepicker");
        this._testFieldFunctionInList("singleversionpicker");
        this._testFieldFunctionInList("versionpicker");
        this._testFieldFunctionInList("usergrouppicker");
        this._testFieldFunctionInList("userpicker");
        this._testFieldFunctionInList("multiuserpicker");
        this._testChangeHistory("status");
    }

    public void testFunctionsInListSystemFields() throws Exception {
        this.administration.restoreBlankInstance();
        this._testFieldFunctionInList("project");
        this._testFieldFunctionInList("status");
        this._testFieldFunctionInList("resolution");
        this._testFieldFunctionInList("priority");
        this._testFieldFunctionInList("affectedVersion");
        this._testFieldFunctionInList("fixVersion");
        this._testFieldFunctionInList("component");
        this._testFieldFunctionInList("type");
        this._testRelativeDateFieldFunctionInList("duedate");
        this._testDateFieldFunctionInList("created");
        this._testDateFieldFunctionInList("updated");
        this._testDateFieldFunctionInList("resolutiondate");
    }

    public void testMaximumValidationErrors() throws Exception {
        this.administration.restoreBlankInstance();
        String jqlString = this.createInvalidJql(30);
        this.navigation.issueNavigator().createSearch(jqlString);
        this.text.assertTextPresentNumOccurences(new XPathLocator(this.tester, "//div[@id='jqlerror']"), "The value 'nonexistent", 10);
    }

    private void _testNumberFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value provided by the function 'echo' for the field '" + field + "' is not a valid number.", "Value 'BLAH' for the '" + field + "' field is not a valid number.");
    }

    private void _testGroupFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A group provided by the function 'echo' for the field '" + field + "' does not exist.", "The group 'BLAH' for field '" + field + "' does not exist.");
    }

    private void _testFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value provided by the function 'echo' is invalid for the field '" + field + "'.", "The value 'BLAH' does not exist for the field '" + field + "'.");
    }

    private void _testDateFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A date for the field '" + field + "' provided by the function 'echo' is not valid.", "Date value 'BLAH' for field '" + field + "' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.");
    }

    private void _testRelativeDateFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A date for the field '" + field + "' provided by the function 'echo' is not valid.", "Date value 'BLAH' for field '" + field + "' is invalid. Valid formats include: 'YYYY/MM/DD', 'YYYY-MM-DD', or a period format e.g. '-5d', '4w 2d'.");
    }

    private void _testOptionFieldFunctionInList(String field) {
        this.navigation.issueNavigator().createSearch(field + " in (echo('a', 'b'), BLAH)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("An option provided by the function 'echo' for the field '" + field + "' does not exist.", "The option 'BLAH' for field '" + field + "' does not exist.");
    }

    private void _testChangeHistory(String field) {
        this.navigation.issueNavigator().createSearch(field + " was nonexistent");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'nonexistent' does not exist for the field '" + field + "'.");
    }

    private String createInvalidJql(int errors) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < errors; ++i) {
            builder.append("project = nonexistent");
            builder.append(i);
            if (i == errors - 1) continue;
            builder.append(" or ");
        }
        String jqlString = builder.toString();
        return jqlString;
    }
}

