/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestAdvancedSimple
extends AbstractJqlFuncTest {
    public void testJQLErrors() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("project = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("issuetype = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("summary ~ \"*INVALID\"", "Invalid start character '*'", TestAdvancedSimple.createFilterFormParam("query", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("comment ~ \"*INVALID\"", "Invalid start character '*'", TestAdvancedSimple.createFilterFormParam("query", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("description ~ \"*INVALID\"", "Invalid start character '*'", TestAdvancedSimple.createFilterFormParam("query", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("environment ~ \"*INVALID\"", "Invalid start character '*'", TestAdvancedSimple.createFilterFormParam("query", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("reporter = INVALID", "Could not find username: INVALID", TestAdvancedSimple.createFilterFormParam("reporter", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("assignee = INVALID", "Could not find username: INVALID", TestAdvancedSimple.createFilterFormParam("assignee", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("status = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("resolution = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("priority = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("created >= INVALID AND created <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("created:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("created:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("updated >= INVALID AND updated <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("updated:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("updated:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("due >= INVALID AND due <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("duedate:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("duedate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("resolved >= INVALID AND resolved <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("resolutiondate:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("resolutiondate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("workratio >= INVALID AND workratio <= INVALID", "The min limit must be specified using an integer", TestAdvancedSimple.createFilterFormParam("workratio:min", "INVALID"), TestAdvancedSimple.createFilterFormParam("workratio:max", "INVALID"));
    }

    public void testSystemWithOneProject() throws Exception {
        this.administration.restoreData("TestSwitchingWithOneProject.xml");
        this.assertFitsFilterForm("project = HSP AND fixVersion = 10000", TestAdvancedSimple.createFilterFormParam("fixfor", "10000"));
        this.assertTooComplex("fixVersion = 10000");
    }

    private void assertInvalidJqlAndSwitchToBasic(String invalidJqlQuery, String errorMessage, IssueNavigatorAssertions.FilterFormParam ... params) {
        this.navigation.issueNavigator().createSearch(invalidJqlQuery);
        IdLocator jqlErrorLocator = new IdLocator(this.tester, "jqlerror");
        TestAdvancedSimple.assertTrue((String)"No JQL Errors found", (jqlErrorLocator.getNodes().length > 0 ? 1 : 0) != 0);
        this.tester.clickLink("switchnavtype");
        for (IssueNavigatorAssertions.FilterFormParam param : params) {
            this.assertFilterFormValue(param);
        }
        this.text.assertTextPresent(new IdLocator(this.tester, "issue-filter"), errorMessage);
    }

    private void assertInvalidJqlAndSwitchToBasicDoesntFit(String invalidJqlQuery) {
        this.navigation.issueNavigator().createSearch(invalidJqlQuery);
        IdLocator jqlErrorLocator = new IdLocator(this.tester, "jqlerror");
        TestAdvancedSimple.assertTrue((String)"No JQL Errors found", (jqlErrorLocator.getNodes().length > 0 ? 1 : 0) != 0);
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }
}

