/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS, Category.SECURITY})
public class TestSearchRequestViewSecurity
extends FuncTestCase {
    private static final String SR_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html";
    private static final String SR_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml";
    private static final String SR_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc";
    private static final String SR_EXCEL_ALL_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls";
    private static final String SR_EXCEL_CURRENT_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls";
    private static final String SR_GLOBAL_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10010/SearchRequest-10010.doc";
    private static final String SR_GLOBAL_EXCEL_ALL_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-all-fields/10010/SearchRequest-10010.xls";
    private static final String SR_GLOBAL_EXCEL_CURRENT_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-current-fields/10010/SearchRequest-10010.xls";
    private static final String SR_RSS_COMMENTS_FAILED = "/sr/jira.issueviews:searchrequest-comments-rss/10001/SearchRequest-10000.xml";
    private static final String SR_PRINTABLE_FAILED = "/sr/jira.issueviews:searchrequest-printable/10001/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_FAILED = "/sr/jira.issueviews:searchrequest-fullcontent/10001/SearchRequest-10000.html";
    private static final String SR_XML_FAILED = "/sr/jira.issueviews:searchrequest-xml/10001/SearchRequest-10000.xml";
    private static final String SR_RSS_FAILED = "/sr/jira.issueviews:searchrequest-rss/10001/SearchRequest-10000.xml";
    private static final String SR_WORD_FAILED = "/sr/jira.issueviews:searchrequest-word/10001/SearchRequest-10000.doc";
    private static final String SR_EXCEL_ALL_FAILED = "/sr/jira.issueviews:searchrequest-excel-all-fields/10001/SearchRequest-10000.xls";
    private static final String SR_EXCEL_CURRENT_FAILED = "/sr/jira.issueviews:searchrequest-excel-current-fields/10001/SearchRequest-10000.xls";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSearchRequestViewSecurity.xml");
    }

    public void testGlobalSearchRequestRequiresNoLogin() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_PRINTABLE_SUCCESS);
        this.text.assertTextPresent(this.locator.page(), "HSP-1");
        this.text.assertTextPresent(this.locator.page(), "Bug 01");
        this.text.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_FULL_CONTENT_SUCCESS);
        this.text.assertTextPresent(this.locator.page(), "HSP-1");
        this.text.assertTextPresent(this.locator.page(), "Bug 01");
        this.text.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        try {
            this.tester.gotoPage(SR_GLOBAL_RSS_SUCCESS);
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.fail((String)("Exception occurred: " + re));
        }
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        try {
            this.tester.gotoPage(SR_GLOBAL_RSS_COMMENTS_SUCCESS);
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.fail((String)("Exception occurred: " + re));
        }
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_WORD_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-word", (String)this.tester.getDialog().getResponse().getContentType());
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_EXCEL_ALL_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.tester.getDialog().getResponse().getContentType());
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_EXCEL_CURRENT_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.tester.getDialog().getResponse().getContentType());
    }

    public void testErrorsWithGzipFilter() {
        this.administration.generalConfiguration().turnOnGZipCompression();
        this.navigation.logout();
        this.navigation.gotoPage(SR_PRINTABLE_SUCCESS);
        this.text.assertTextPresent(this.locator.page(), "You must log in to access this page.");
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-printable/10002/SearchRequest-10002.html");
        this.text.assertTextPresent(this.locator.page(), "Error processing Search Request");
    }

    public void testLoginRequiredSuccess() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.navigation.logout();
        this.tester.gotoPage(SR_PRINTABLE_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        this.text.assertTextPresent(this.locator.page(), "HSP-1");
        this.text.assertTextPresent(this.locator.page(), "Bug 01");
        this.text.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_FULL_CONTENT_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        this.text.assertTextPresent(this.locator.page(), "HSP-1");
        this.text.assertTextPresent(this.locator.page(), "Bug 01");
        this.text.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for non-existance of xpath [" + xpath + "]");
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(SR_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'0.92')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        try {
            this.tester.gotoPage(SR_RSS_SUCCESS);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((boolean)re.getMessage().contains("AuthorizationRequiredException"));
            this.log("Received auth challenge!");
        }
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        try {
            this.tester.gotoPage(SR_RSS_COMMENTS_SUCCESS);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((boolean)re.getMessage().contains("AuthorizationRequiredException"));
            this.log("Received auth challenge!");
        }
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_WORD_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-word", (String)this.tester.getDialog().getResponse().getContentType());
        this.navigation.logout();
        this.tester.gotoPage(SR_EXCEL_ALL_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.tester.getDialog().getResponse().getContentType());
        this.navigation.logout();
        this.tester.gotoPage(SR_EXCEL_CURRENT_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.tester.getDialog().getResponse().getContentType());
    }

    public void testLoginRequiredAndSearchRequestDoesntExist() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_FAILED, SR_FULL_CONTENT_FAILED, SR_XML_FAILED, SR_RSS_FAILED, SR_RSS_COMMENTS_FAILED, SR_WORD_FAILED, SR_EXCEL_ALL_FAILED, SR_EXCEL_CURRENT_FAILED, "admin");
    }

    public void testLoginRequiredAndInvalidPermission() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_SUCCESS, SR_FULL_CONTENT_SUCCESS, SR_XML_SUCCESS, SR_RSS_SUCCESS, SR_RSS_COMMENTS_SUCCESS, SR_WORD_SUCCESS, SR_EXCEL_ALL_SUCCESS, SR_EXCEL_CURRENT_SUCCESS, "fred");
    }

    private void loginFromErrorPage(String username, String password) {
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    private void checkNoLoginPageAndClickLink() {
        this.text.assertTextPresent(this.locator.page(), "You must log in to access this page.");
    }

    private void checkErrorProcessingSearchRequest() {
        this.text.assertTextPresent(this.locator.page(), "Error processing Search Request");
        this.text.assertTextPresent(this.locator.page(), "The saved filter you are trying to view no longer exists or you do not have access rights to view it.");
    }

    private void checkLoginSearchRequestDoesntExist(String url, String username, String password) {
        this.navigation.logout();
        this.tester.gotoPage(url);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(username, password);
        this.checkErrorProcessingSearchRequest();
    }

    private void checkLoginInvalidSRorPermission(String printable, String fullContent, String xml, String rss, String rssComments, String word, String excelAll, String excelCurrent, String usernamePassword) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.checkLoginSearchRequestDoesntExist(printable, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(fullContent, usernamePassword, usernamePassword);
        this.navigation.logout();
        this.tester.gotoPage(xml);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.log("Testing for non-existance of xpath [" + xpath + "]");
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.navigation.logout();
        try {
            this.tester.gotoPage(rss);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((boolean)re.getMessage().contains("AuthorizationRequiredException"));
            this.log("Received auth challenge!");
        }
        try {
            this.tester.gotoPage(rss + "?os_username=admin&os_password=admin");
        }
        catch (RuntimeException e) {
            TestSearchRequestViewSecurity.assertTrue((boolean)e.getMessage().contains("Error on HTTP request: 403"));
            this.log("recieved 403 error");
        }
        this.navigation.logout();
        try {
            this.tester.gotoPage(rssComments);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((boolean)re.getMessage().contains("AuthorizationRequiredException"));
            this.log("Received auth challenge!");
        }
        try {
            this.tester.gotoPage(rssComments + "?os_username=admin&os_password=admin");
        }
        catch (RuntimeException e) {
            TestSearchRequestViewSecurity.assertTrue((boolean)e.getMessage().contains("Error on HTTP request: 403"));
            this.log("recieved 403 error");
        }
        this.checkLoginSearchRequestDoesntExist(word, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(excelAll, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(excelCurrent, usernamePassword, usernamePassword);
    }

    private static final class ContentTypes {
        private static final String XML = "text/xml";
        private static final String RSS = "application/rss+xml";
        private static final String WORD = "application/vnd.ms-word";
        private static final String EXCEL = "application/vnd.ms-excel";

        private ContentTypes() {
        }
    }
}

