/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.log4j.Logger;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestNavigationBarWebFragment
extends JIRAWebTest {
    public static final Logger log = Logger.getLogger(TestNavigationBarWebFragment.class);

    public TestNavigationBarWebFragment(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestNavigationBarWebFragment.xml");
    }

    @Override
    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testNavigationBarWebFragment() {
        this.login("admin", "admin");
        this.assertLinkPresent("home_link");
        this._checkBrowseAndFindIssueLinksVisiblity();
        this._checkCreateIssueLinkVisiblity();
        this._checkAdminLinkVisiblityToProjectAdmin();
        this._checkAdminLinkVisiblityToSystemAdmin();
    }

    public void _checkBrowseAndFindIssueLinksVisiblity() {
        this.assertLinkPresent("browse_link");
        this.assertLinkPresent("find_link");
        this.removeBrowsePermission();
        this.assertLinkNotPresent("browse_link");
        this.assertLinkNotPresent("find_link");
        this.addBrowsePermission();
        this.getNavigation().gotoDashboard();
        this.assertLinkPresent("find_link");
        this.assertLinkPresent("browse_link");
        this.assertLinkPresentWithText("Projects");
        this.gotoPage("/plugins/servlet/project-config/HSP/summary");
        this.navigation.gotoDashboard();
        this.assertLinkPresent("browse_link");
        this.assertLinkPresentWithText("Projects");
    }

    public void _checkCreateIssueLinkVisiblity() {
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.assertLinkPresent("create_link");
        this.removeCreatePermission();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.assertLinkNotPresent("create_link");
        this.addCreatePermission();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.assertLinkPresent("create_link");
    }

    public void _checkAdminLinkVisiblityToProjectAdmin() {
        this.login("project_admin", "project_admin");
        this.assertLinkPresent("admin_link");
        this.login("admin", "admin");
        this.removeProjectAdminPermission();
        this.navigation.gotoDashboard();
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("project_admin", "project_admin");
        this.assertLinkNotPresent("admin_link");
        this.logout();
        this.login("admin", "admin");
        this.addProjectAdminPermission();
        this.navigation.gotoDashboard();
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("project_admin", "project_admin");
        this.assertLinkPresent("admin_link");
    }

    public void _checkAdminLinkVisiblityToSystemAdmin() {
        this.login("system_admin", "system_admin");
        this.assertLinkPresent("admin_link");
        this.login("admin", "admin");
        this.removeUserFromGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("system_admin", "system_admin");
        this.assertLinkNotPresent("admin_link");
        this.login("admin", "admin");
        this.addUserToGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        this.assertLinkPresent("admin_link");
        this.login("system_admin", "system_admin");
        this.assertLinkPresent("admin_link");
    }

    public void removeBrowsePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_10_10000");
        this.submit("Delete");
    }

    public void removeCreatePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_11_10000");
        this.submit("Delete");
    }

    public void removeProjectAdminPermission() {
        this.navigation.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_23_jira-developers");
        this.submit("Delete");
    }

    public void addBrowsePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-users");
        this.submit(" Add ");
    }

    public void addCreatePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_11");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-users");
        this.submit(" Add ");
    }

    public void addProjectAdminPermission() {
        this.navigation.gotoAdminSection("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_23");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-developers");
        this.submit(" Add ");
    }
}

