/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorXmlView;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestIssueNavigatorXmlView
extends AbstractTestIssueNavigatorXmlView {
    public TestIssueNavigatorXmlView(String name) {
        super(name);
    }

    public void testIssueNavigatorXmlViewAbsoluteIcon() {
        TextAssertionsImpl text = new TextAssertionsImpl();
        this.restoreData("TestIssueXmlViewAbsoluteIcon.xml");
        this.gotoFilterById(10000L);
        this.tester.clickLink("xml");
        text.assertRegexNoMatch(this.getDialog().getResponseText(), "iconUrl=\"http://.*http://.*\"");
        text.assertRegexNoMatch(this.getDialog().getResponseText(), "iconUrl=\".*\\?x=y&z=a");
        text.assertRegexMatch(this.getDialog().getResponseText(), "iconUrl=\".*\\?x=y&amp;z=a");
    }

    public void testIssueNavigatorXmlViewLinksToFilter() throws IOException, ParserConfigurationException, SAXException, TransformerException, DocumentException {
        this.getNavigation().issueNavigator().displayAllIssues();
        this.selectOption("type", "New Feature");
        this.submit("show");
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        String filterId = Integer.toString(this.saveFilter("xmlview", ""));
        this.gotoFilter("xmlview");
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        this.clickLinkWithText("XML");
        String previousViewUrl = this.assertAndGetLinkToFilterWithId(filterId);
        this.gotoPage(previousViewUrl);
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
    }

    public void testIssueXmlView() {
        this.reconfigureTimetracking("pretty");
        this.execIssueXmlView();
    }

    public void testIssueXmlViewDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execIssueXmlView();
    }

    public void testIssueXmlViewHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execIssueXmlView();
    }

    private void execIssueXmlView() {
        TestIssueNavigatorXmlView.log("Issue Navigator: Test that the IssueView XML page correctly shows the custom field information.");
        try {
            for (AbstractTestIssueNavigatorView.Item item : this.items) {
                String key = (String)item.getAttributeMap().get("key");
                TestIssueNavigatorXmlView.log("testing item key = " + key + "...");
                this.beginAt("/secure/Dashboard.jspa");
                this.clickLink("find_link");
                this.submit("show");
                this.clickLinkWithText(key);
                this.clickLinkWithText("XML");
                String responseText = this.getDialog().getResponse().getText();
                Document doc = XMLUnit.buildControlDocument((String)responseText);
                String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "')][description='" + "This file is an XML representation of an issue" + "'][language='" + "en-uk" + "']";
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathExists((String)xpath, (Document)doc);
                this.execTestOnAttributes(item, doc);
                this.execTestOnComments(item, doc);
                this.execTestOnLinks(item, doc);
                this.execTestOnComponents(item, doc);
                this.execTestOnCustomFields(item, doc);
                this.execTestOnAttachements(item, doc);
            }
        }
        catch (Exception e) {
            TestIssueNavigatorXmlView.log("Failed to parse the XML for the custom field.", e);
            TestIssueNavigatorXmlView.fail();
        }
    }

    public void testXMLViewAllItems() {
        this.reconfigureTimetracking("pretty");
        this.execXMLViewAllItems();
    }

    public void testXMLViewAllItemsDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execXMLViewAllItems();
    }

    public void testXMLViewAllItemsHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execXMLViewAllItems();
    }

    public void execXMLViewAllItems() {
        TestIssueNavigatorXmlView.log("Issue Navigator: Test that the XML page correctly shows the custom field information.");
        this.beginAt("/secure/IssueNavigator!switchView.jspa?navType=simple&reset=true");
        this.submit("show");
        this.clickLink("xml");
        try {
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=project+%3D+HSP" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                TestIssueNavigatorXmlView.log("testing item...");
                AbstractTestIssueNavigatorView.Item item = (AbstractTestIssueNavigatorView.Item)i.next();
                this.execTestOnAttributes(item, doc);
                this.execTestOnComments(item, doc);
                this.execTestOnLinks(item, doc);
                this.execTestOnComponents(item, doc);
                this.execTestOnCustomFields(item, doc);
                this.execTestOnAttachements(item, doc);
            }
        }
        catch (Exception e) {
            TestIssueNavigatorXmlView.log("Failed to parse the XML for the custom field.", e);
            TestIssueNavigatorXmlView.fail();
        }
    }

    public void testIssueXMLViewForIssueCountTag() {
        TestIssueNavigatorXmlView.log("Issue Navigator: Test that the XML page shows correct values for the <issue> tag");
        int start = 0;
        for (int tempMax = 0; tempMax < this.items.size() + 3; ++tempMax) {
            if (tempMax > this.items.size()) {
                start = this.items.size() / 2;
            }
            this.checkIssueCountTag(start, tempMax);
        }
    }

    private void execTestOnLinks(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        AbstractTestIssueNavigatorView.IssueLinks links = item.getLinks();
        if (links != null) {
            String xxpath;
            String key = item.getAttribute("key");
            String xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "'][name='" + links.getName() + "']";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            if (links.getOutLinks() != null && !links.getOutLinks().isEmpty()) {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/outwardlinks[@description='" + links.getOutDesc() + "']";
                for (AbstractTestIssueNavigatorView.IssueLink link : links.getOutLinks()) {
                    xxpath = xpath + "/issuelink/issuekey[@id='" + link.getId() + "'][.='" + link.getLink() + "']";
                    TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xxpath);
                    XMLAssert.assertXpathExists((String)xxpath, (Document)doc);
                }
            } else {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/outwardlinks";
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            }
            if (links.getInLinks() != null && !links.getInLinks().isEmpty()) {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/inwardlinks[@description='" + links.getInDesc() + "']";
                for (AbstractTestIssueNavigatorView.IssueLink link : links.getInLinks()) {
                    xxpath = xpath + "/issuelink/issuekey[@id='" + link.getId() + "'][.='" + link.getLink() + "']";
                    TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xxpath);
                    XMLAssert.assertXpathExists((String)xxpath, (Document)doc);
                }
            } else {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/inwardlinks";
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            }
        }
    }

    private void execTestOnAttributes(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        Map attributeMap = item.getAttributeMap();
        if (!attributeMap.isEmpty()) {
            StringBuffer xpath = new StringBuffer("//item");
            for (Map.Entry entry : attributeMap.entrySet()) {
                String key = (String)entry.getKey();
                if ("created".equals(key) || "updated".equals(key) || "due".equals(key) || "resolved".equals(key)) {
                    xpath.append("[");
                    xpath.append(key);
                    xpath.append("=*");
                    xpath.append("]");
                    continue;
                }
                if ("timeoriginalestimateDays".equals(key) || "timeoriginalestimateHours".equals(key) || "timeoriginalestimate".equals(key)) {
                    if (!("timeoriginalestimateDays".equals(key) && "days".equals(this.timeFormat) || "timeoriginalestimateHours".equals(key) && "hours".equals(this.timeFormat)) && (!"timeoriginalestimate".equals(key) || !"pretty".equals(this.timeFormat))) continue;
                    xpath.append("[");
                    xpath.append("timeoriginalestimate");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                if ("timespentDays".equals(key) || "timespentHours".equals(key) || "timespent".equals(key)) {
                    if (!("timespentDays".equals(key) && "days".equals(this.timeFormat) || "timespentHours".equals(key) && "hours".equals(this.timeFormat)) && (!"timespent".equals(key) || !"pretty".equals(this.timeFormat))) continue;
                    xpath.append("[");
                    xpath.append("timespent");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                if ("timeestimateDays".equals(key) || "timeestimateHours".equals(key) || "timeestimate".equals(key)) {
                    if (!("timeestimateDays".equals(key) && "days".equals(this.timeFormat) || "timeestimateHours".equals(key) && "hours".equals(this.timeFormat)) && (!"timeestimate".equals(key) || !"pretty".equals(this.timeFormat))) continue;
                    xpath.append("[");
                    xpath.append("timeestimate");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                xpath.append("[");
                xpath.append(key);
                xpath.append("='");
                xpath.append(entry.getValue());
                xpath.append("'");
                xpath.append("]");
            }
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            Map allAttributesMap = item.getAllAttributeAttributesMap();
            Iterator i = allAttributesMap.entrySet().iterator();
            while (i.hasNext()) {
                xpath = new StringBuffer("//item/");
                Map.Entry attributeEntry = i.next();
                xpath.append(attributeEntry.getKey());
                Map attributeAttributes = (Map)attributeEntry.getValue();
                for (Map.Entry attEntry : attributeAttributes.entrySet()) {
                    xpath.append("[@");
                    xpath.append(attEntry.getKey());
                    xpath.append("='");
                    xpath.append(attEntry.getValue());
                    xpath.append("']");
                }
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        }
    }

    private void execTestOnComments(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List commentList = item.getComments();
        if (commentList != null && !commentList.isEmpty()) {
            for (AbstractTestIssueNavigatorView.Comment comment : commentList) {
                StringBuffer xpath = new StringBuffer();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("']/comments/comment");
                xpath.append("[@author='");
                xpath.append(comment.getAuthor());
                xpath.append("'][@created]");
                if (StringUtils.isNotBlank((String)comment.getLevel())) {
                    xpath.append("[@grouplevel='");
                    xpath.append(comment.getLevel());
                    xpath.append("']");
                }
                xpath.append("[. = '");
                xpath.append(comment.getValue());
                xpath.append("']");
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/comments";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnAttachements(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List attachmentList = item.getAttachments();
        if (attachmentList != null && !attachmentList.isEmpty()) {
            for (String attachment : attachmentList) {
                StringBuffer xpath = new StringBuffer();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("']/attachments/attachment");
                xpath.append("[@name='");
                xpath.append(attachment);
                xpath.append("']");
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/attachments/attachment";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnComponents(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List componentList = item.getComponents();
        if (componentList != null && !componentList.isEmpty()) {
            for (String component : componentList) {
                StringBuffer xpath = new StringBuffer();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("'][component='");
                xpath.append(component);
                xpath.append("']");
                TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/component";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnCustomFields(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List customFieldList = item.getCustomFields();
        for (AbstractTestIssueNavigatorView.CustomField customField : customFieldList) {
            StringBuffer xpath = new StringBuffer();
            xpath.append("//item/customfields/customfield[@id='");
            xpath.append(customField.getId());
            xpath.append("'][customfieldname='");
            xpath.append(customField.getName());
            xpath.append("'][customfieldvalues");
            String customFieldKey = customField.getKey();
            if ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(customFieldKey) || "com.atlassian.jira.plugin.system.customfieldtypes:datepicker".equals(customFieldKey)) {
                Iterator j = customField.getValues().iterator();
                while (j.hasNext()) {
                    xpath.append("[customfieldvalue=*]");
                    j.next();
                }
            } else {
                for (AbstractTestIssueNavigatorView.CustomField.Value value : customField.getValues()) {
                    xpath.append("[customfieldvalue='");
                    xpath.append(value.getValue());
                    xpath.append("']");
                }
            }
            xpath.append("]");
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
        }
    }

    private void checkIssueCountTag(int start, int tempMax) {
        this.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&pager/start=" + start + "&tempMax=" + tempMax);
        try {
            String responseText = this.getDialog().getResponse().getText();
            int end = Math.min(start + tempMax, this.items.size());
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//issue[@start='" + start + "']" + "[@end='" + end + "']" + "[@total='" + this.items.size() + "']";
            TestIssueNavigatorXmlView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        }
        catch (Exception e) {
            TestIssueNavigatorXmlView.log("Failed to parse the rss for issue counts", e);
            TestIssueNavigatorXmlView.fail();
        }
    }
}

