/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorXmlView;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebResponseUtil;
import java.io.IOException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorRssView
extends AbstractTestIssueNavigatorXmlView {
    protected static final String XML_LINK_COMMENT_AFTER_12APR = "updated+%3E%3D+2006-04-12";
    protected static final String XML_LINK_COMMENT_BEFORE_16APR = "updated+%3C%3D+2006-04-16";
    protected static final String[] XML_LINK_COMMENT_23_25NOV = new String[]{"updated+%3C%3D+2006-11-25", "updated+%3E%3D+2006-11-23"};
    protected static final String[] XML_LINK_COMMENT_12_16APR = new String[]{"updated+%3E%3D+2006-04-12", "updated+%3C%3D+2006-04-16"};

    public TestIssueNavigatorRssView(String name) {
        super(name);
    }

    public void testCommentsRssFeedUpdated() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.restoreData("TestSearchRequestViewsAndIssueViews.xml");
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        this.grantGroupPermission(34, "jira-users");
        this.getNavigation().issueNavigator().gotoNavigator();
        this.setFormElement("updated:previous", "-2d");
        this.submit("show");
        this.assertTextPresent("No matching issues found.");
        this.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?pid=10000&updated%3Aprevious=-2d&sorter/field=issuekey&sorter/order=DESC&tempMax=1000");
        WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html");
        String xpath = "//item";
        String responseText = this.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue("HSP-11");
        this.clickLink("edit_comment_10000");
        this.setWorkingForm("comment-edit");
        String newDescription = "RSS rocks!";
        this.setFormElement("comment", "RSS rocks!");
        this.submit("Save");
        this.clickLink("find_link");
        this.setFormElement("updated:previous", "-2d");
        this.submit("show");
        this.clickLink("rssComments");
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        String NEW_XML_LINK_COMMENT = "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=project+%3D+HSP+AND+updated+%3E%3D+-2d";
        xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=project+%3D+HSP+AND+updated+%3E%3D+-2d" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        AbstractTestIssueNavigatorView.Item item = this.commentItem3;
        xpath = "//item[title='" + item.getAttribute("title") + "']" + "[contains(link,'" + item.getAttribute("link") + "')]" + "[contains(description, '" + "RSS rocks!" + "')]" + "[contains(description, '" + item.getAttribute("description_link_profile") + "')]" + "[contains(description, 'Edited by')]" + "[contains(description, '" + item.getAttribute("description_link_issue") + "')]";
        TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
    }

    public void testRssIssuesViewHaveCorrectLinkToTheFilter() throws DocumentException {
        this._testRssFeedsHaveCorrectLinkToTheFilter("rssIssues");
    }

    public void testRssCommentsViewHaveCorrectLinkToTheFilter() throws DocumentException {
        this._testRssFeedsHaveCorrectLinkToTheFilter("rssComments");
    }

    public void _testRssFeedsHaveCorrectLinkToTheFilter(String rssView) throws DocumentException {
        TestIssueNavigatorRssView.log("Issue Navigator RSS : Test that both comment and issues RSS have correct links to the filter");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.selectOption("type", "New Feature");
        this.submit("show");
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        String filterId = Integer.toString(this.saveFilter("rssview", ""));
        this.gotoFilter("rssview");
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        this.clickLink(rssView);
        String previousViewUrl = this.assertAndGetLinkToFilterWithId(filterId);
        this.gotoPage(previousViewUrl);
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
    }

    public void testRssIssueFeedWithSubtaskTimeTracking() {
        TestIssueNavigatorRssView.log("Issue Navigator RSS : Test that the RSS page shows time tracking items for an issue feed");
        this.displayAllIssues();
        this.clickLink("rssIssues");
        this.assertTextSequence(new String[]{"HSP-12", "Remaining Estimate:", "Not Specified", "Time Spent:", "Not Specified", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"HSP-11", "Remaining Estimate:", "30 minutes", "Time Spent:", "3 hours, 20 minutes", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"HSP-10", "Remaining Estimate:", "1 day", "Time Spent:", "Not Specified", "Original Estimate:", "1 day"});
        this.assertTextNotPresent(" Remaining Estimate");
        this.assertTextNotPresent(" Time Spent");
        this.assertTextNotPresent(" Original Estimate");
        this.goBackFromRssView();
        this.activateSubTasks();
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
        this.displayAllIssues();
        this.clickLink("rssIssues");
        this.assertTextSequence(new String[]{"HSP-12", "Remaining Estimate:", "Not Specified", "Time Spent:", "Not Specified", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"HSP-11", "Remaining Estimate:", "30 minutes", "Time Spent:", "3 hours, 20 minutes", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"HSP-10", " Remaining Estimate:", "1 day, 30 minutes", "Remaining Estimate:", "1 day", " Time Spent:", "3 hours, 20 minutes", "Time Spent:", "Not Specified", " Original Estimate:", "1 day", "Original Estimate:", "1 day"});
        this.goBackFromRssView();
        this.deactivateTimeTracking();
        this.displayAllIssues();
        this.clickLink("rssIssues");
        this.assertTextNotPresent("Remaining Estimate");
        this.assertTextNotPresent("Time Spent");
        this.assertTextNotPresent("Original Estimate");
    }

    public void testRedirectRegex() {
        Pattern pattern = Pattern.compile(".*\\?&.*");
        ArrayList<String> urls = new ArrayList<String>(){
            {
                this.add("/secure/IssueNavigator.jspa?reset=true&decorator=none&view=rss");
                this.add("/secure/IssueNavigator.jspa?reset=true&view=rss&decorator=none");
                this.add("/secure/IssueNavigator.jspa?view=rss&reset=true&decorator=none");
            }
        };
        for (String url : urls) {
            this.gotoPage(url);
            URL responseUrl = this.getDialog().getResponse().getURL();
            TestIssueNavigatorRssView.assertFalse((boolean)pattern.matcher(responseUrl.toString()).matches());
        }
    }

    public void testRssIssueFeed() {
        TestIssueNavigatorRssView.log("Issue Navigator RSS : Test that the RSS page shows all required items for an issue feed");
        this.displayAllIssues();
        this.clickLink("rssIssues");
        try {
            String responseText = this.getDialog().getResponse().getText();
            this.checkRssResponseHeaders(this.getDialog().getResponse());
            this.checkPubDatesRFC822(responseText);
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            xpath = "//rss[contains(@version,'2.0')]";
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            for (AbstractTestIssueNavigatorView.Item item : this.items) {
                String xPath = "//item[title='" + item.getAttribute("title") + "']" + "[contains(link,'" + item.getAttribute("link") + "')]" + "[contains(guid,'" + item.getAttribute("link") + "')]" + "[contains(author,'" + item.getAttribute("reporter") + "')]";
                TestIssueNavigatorRssView.log("Searching for existence of xpath " + xPath);
                XMLAssert.assertXpathExists((String)xPath, (Document)doc);
            }
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    public void testCommentRssFeedForIssues() {
        TestIssueNavigatorRssView.log("Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.displayAllIssues();
        this.clickLink("rssComments");
        try {
            String responseText = this.getDialog().getResponse().getText();
            this.checkRssResponseHeaders(this.getDialog().getResponse());
            this.checkPubDatesRFC822(responseText);
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            for (AbstractTestIssueNavigatorView.Item item : this.commentItems) {
                String xPath = "//item[title='" + item.getAttribute("title") + "']" + "[contains(link,'" + item.getAttribute("link") + "')]" + "[contains(pubDate, '" + item.getAttribute("pubDate") + "')]" + "[contains(description, '" + item.getAttribute("description") + "')]" + "[contains(description, '" + item.getAttribute("description_link_profile") + "')]" + "[not(contains(description, 'Edited by'))]" + "[contains(description, '" + item.getAttribute("description_link_issue") + "')]";
                TestIssueNavigatorRssView.log("Searching for existence of xpath " + xPath);
                XMLAssert.assertXpathExists((String)xPath, (Document)doc);
            }
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    public void testCommentRssFeedForIssuesTempMax() {
        TestIssueNavigatorRssView.log("Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&tempMax=1");
        try {
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true&amp;jqlQuery=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            String xPathItem1 = "//item[contains(description, 'no comment')]";
            String xPathItem2 = "//item[contains(description, 'Developers, developers, developers!')]";
            String xPathItem3 = "//item[contains(description, 'This is my first comment')]";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xPathItem1);
            XMLAssert.assertXpathExists((String)xPathItem1, (Document)doc);
            TestIssueNavigatorRssView.log("Searching for absence of xpath " + xPathItem2);
            XMLAssert.assertXpathNotExists((String)xPathItem2, (Document)doc);
            TestIssueNavigatorRssView.log("Searching for absence of xpath " + xPathItem3);
            XMLAssert.assertXpathNotExists((String)xPathItem3, (Document)doc);
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    public void testCommentRssFeedForIssuesWithAbsoluteDateRange() {
        this.restoreData("TestIssueNavigatorRssCommentsFeed.xml");
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        TestIssueNavigatorRssView.log("Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.displayAllIssues();
        this.setFormElement("updated:after", "12/Apr/06");
        this.submit("show");
        this.clickLink("rssComments");
        this.checkComments(XML_LINK_COMMENT_AFTER_12APR, false, true, false, true);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:before", "16/Apr/06");
        this.submit("show");
        this.clickLink("rssComments");
        this.checkComments(XML_LINK_COMMENT_BEFORE_16APR, true, true, true, false);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:after", "23/Nov/06");
        this.setFormElement("updated:before", "25/Nov/06");
        this.submit("show");
        this.clickLink("rssComments");
        this.checkComments(XML_LINK_COMMENT_23_25NOV, false, false, false, false);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:after", "20/Nov/06");
        this.setFormElement("updated:before", "23/Nov/06");
        this.submit("show");
        this.assertTextPresent("No matching issues found.");
        this.assertLinkNotPresent("rssComments");
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:after", "12/Apr/06");
        this.setFormElement("updated:before", "16/Apr/06");
        this.submit("show");
        this.clickLink("rssComments");
        this.checkComments(XML_LINK_COMMENT_12_16APR, false, true, false, false);
    }

    public void testCommentRssFeedForIssuesWithRelativeDateRange() {
        this.restoreData("TestIssueNavigatorRssCommentsFeed.xml");
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        this.displayAllIssues();
        this.setFormElement("updated:previous", this.dateToRelativeString(2006, 4, 17));
        this.submit("show");
        this.clickLink("rssComments");
        this.checkCommentsOnly(false, false, false, true);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:next", this.dateToRelativeString(2006, 4, 17));
        this.submit("show");
        this.clickLink("rssComments");
        this.checkCommentsOnly(true, true, true, false);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:previous", this.dateToRelativeString(2006, 11, 23));
        this.setFormElement("updated:next", this.dateToRelativeString(2006, 11, 25));
        this.submit("show");
        this.clickLink("rssComments");
        this.checkCommentsOnly(false, false, false, false);
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:previous", this.dateToRelativeString(2006, 11, 20));
        this.setFormElement("updated:next", this.dateToRelativeString(2006, 11, 23));
        this.submit("show");
        this.assertTextPresent("No matching issues found.");
        this.assertLinkNotPresent("rssComments");
        this.goBackFromRssView();
        this.displayAllIssues();
        this.setFormElement("updated:previous", this.dateToRelativeString(2006, 4, 10));
        this.setFormElement("updated:next", this.dateToRelativeString(2006, 4, 17));
        this.submit("show");
        this.clickLink("rssComments");
        this.checkCommentsOnly(false, true, false, false);
    }

    public void testRssIssueFeedForIssueCountTag() {
        TestIssueNavigatorRssView.log("Issue Navigator RSS : Test that the RSS page shows correct values for the <issue> tag");
        int start = 0;
        for (int tempMax = 0; tempMax < this.items.size() + 3; ++tempMax) {
            if (tempMax > this.items.size()) {
                start = this.items.size() / 2;
            }
            this.checkIssueCountTag(start, tempMax);
        }
    }

    public void testRssIssueFeedForXssDescription() {
        this.restoreData("TestSearchRequestViewsAndIssueViewsXss.xml");
        this.goToFilterWithHtmlInDescription();
        this.tester.clickLink("rssIssues");
        this.assertTextNotPresent("&trade;");
    }

    public void testRssCommentFeedForXssDescription() {
        this.restoreData("TestSearchRequestViewsAndIssueViewsXss.xml");
        this.goToFilterWithHtmlInDescription();
        this.tester.clickLink("rssComments");
        this.assertTextNotPresent("&trade;");
    }

    public void testXmlIssueFeedForXssDescription() {
        this.restoreData("TestSearchRequestViewsAndIssueViewsXss.xml");
        this.goToFilterWithHtmlInDescription();
        this.tester.clickLink("xml");
        this.assertTextNotPresent("&trade;");
    }

    private void goToFilterWithHtmlInDescription() {
        this.tester.gotoPage("/secure/EditFilter!default.jspa?returnUrl=ManageFilters.jspa&filterId=10000");
        this.tester.setFormElement("filterName", "all issues &trade;");
        this.tester.setFormElement("filterDescription", "&trade;");
        this.tester.submit("Save");
        this.tester.clickLink("filterlink_10000");
    }

    private String dateToRelativeString(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        int h = cal.get(11);
        int m = cal.get(12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(11, 0);
        long today = cal.getTimeInMillis();
        cal.set(year, month - 1, date);
        long days = (today - cal.getTimeInMillis()) / 86400000L;
        if (days > 0L) {
            return "-" + days + "d " + h + "h " + m + "m";
        }
        return -days + "d " + h + "h " + m + "m";
    }

    private void checkComments(String link, boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) {
        try {
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='Your Company JIRA'][contains(link,'" + link + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            this.checkCommentsOnly(hasComment1, hasComment2, hasComment3, hasComment4);
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    private void checkCommentsOnly(boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) {
        try {
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            this.checkXpath(hasComment1, this.commentItem1, doc);
            this.checkXpath(hasComment2, this.commentItem2, doc);
            this.checkXpath(hasComment3, this.commentItem3, doc);
            this.checkXpath(hasComment4, this.commentItem4, doc);
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    private void checkComments(String[] links, boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) {
        try {
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            StringBuffer sb = new StringBuffer();
            sb.append("//channel[title='");
            sb.append("Your Company JIRA");
            sb.append("']");
            for (int i = 0; i < links.length; ++i) {
                String link = links[i];
                sb.append("[contains(link,'");
                sb.append(link);
                sb.append("')]");
            }
            sb.append("[description='");
            sb.append("An XML representation of a search request");
            sb.append("'][language='");
            sb.append("en-uk");
            sb.append("']");
            String xpath = sb.toString();
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            this.checkCommentsOnly(hasComment1, hasComment2, hasComment3, hasComment4);
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for comments", e);
            TestIssueNavigatorRssView.fail();
        }
    }

    private void checkXpath(boolean expected, AbstractTestIssueNavigatorView.Item comment, Document doc) throws TransformerException {
        String xPath = "//item[title='" + comment.getAttribute("title") + "']" + "[contains(link,'" + comment.getAttribute("link") + "')]" + "[contains(pubDate, '" + comment.getAttribute("pubDate") + "')]" + "[contains(description, '" + comment.getAttribute("description") + "')]" + "[contains(description, '" + comment.getAttribute("description_link_profile") + "')]" + "[contains(description, '" + comment.getAttribute("description_link_issue") + "')]";
        if (expected) {
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xPath);
            XMLAssert.assertXpathExists((String)xPath, (Document)doc);
        } else {
            TestIssueNavigatorRssView.log("Searching for non-existence of xpath " + xPath);
            XMLAssert.assertXpathNotExists((String)xPath, (Document)doc);
        }
    }

    private void goBackFromRssView() {
        this.gotoPage("/secure/project/ViewProjects.jspa");
    }

    private void checkRssResponseHeaders(WebResponse response) {
        String contentType = response.getHeaderField("content-type");
        TestIssueNavigatorRssView.assertEquals((String)"", (String)response.getHeaderField("Pragma"));
        this.assertResponseCanBeCached();
        String cacheControl = response.getHeaderField("Cache-Control");
        TestIssueNavigatorRssView.assertTrue((cacheControl.indexOf("private") > -1 ? 1 : 0) != 0);
        TestIssueNavigatorRssView.assertTrue((cacheControl.indexOf("must-revalidate") > -1 ? 1 : 0) != 0);
        TestIssueNavigatorRssView.assertTrue((cacheControl.indexOf("max-age") > -1 ? 1 : 0) != 0);
        TestIssueNavigatorRssView.assertTrue((String)"RSS response should be Content-Type: application/rss+xml", (contentType.indexOf("application/rss+xml") >= 0 ? 1 : 0) != 0);
    }

    private void checkPubDatesRFC822(String responseText) {
        SimpleDateFormat rcf822Format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        int si = responseText.indexOf("<pubDate>");
        while (si != -1) {
            int ei = responseText.indexOf("</pubDate>", si);
            TestIssueNavigatorRssView.assertTrue((String)"missing pubDate element", (ei != -1 ? 1 : 0) != 0);
            String dateStr = responseText.substring(si + "<pubDate>".length(), ei);
            ParsePosition pp = new ParsePosition(0);
            Date dt = rcf822Format.parse(dateStr, pp);
            TestIssueNavigatorRssView.assertEquals((String)"Rfc822 date parse failure", (int)-1, (int)pp.getErrorIndex());
            TestIssueNavigatorRssView.assertNotNull((String)"Rfc822 date parse failure", (Object)dt);
            si = responseText.indexOf("<pubDate>", ei);
        }
    }

    private void checkIssueCountTag(int start, int tempMax) {
        this.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&pager/start=" + start + "&tempMax=" + tempMax);
        try {
            String responseText = this.getDialog().getResponse().getText();
            int end = Math.min(start + tempMax, this.items.size());
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//issue[@start='" + start + "']" + "[@end='" + end + "']" + "[@total='" + this.items.size() + "']";
            TestIssueNavigatorRssView.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        }
        catch (Exception e) {
            TestIssueNavigatorRssView.log("Failed to parse the rss for issue counts", e);
            TestIssueNavigatorRssView.fail();
        }
    }
}

