/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebLink;
import java.net.URL;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorFullContentView
extends AbstractTestIssueNavigatorView {
    private URL baseUrl;

    public TestIssueNavigatorFullContentView(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.baseUrl = this.getEnvironmentData().getBaseUrl();
    }

    @Override
    public void tearDown() {
        this.baseUrl = null;
        super.tearDown();
    }

    public void testFullContentViewItem1() {
        this.getNavigation().issueNavigator().displayAllIssues();
        this.selectOption("status", "Open");
        this.submit("show");
        this.goToView();
        AbstractTestIssueNavigatorView.Item item = this.item1;
        this.verifyCommons(item);
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("duplicates", "HSP-10");
        this.assertTextPresentBeforeText("HSP-10", "Big 01");
        this.assertTextPresentBeforeText("Big 01", "Resolved");
        this.assertTextPresentBeforeText("CascadingSelectField", "value 01");
        this.assertTextPresentBeforeText("CascadingSelectField", "value 013");
        this.assertLinkPresentWithText("New Version 5");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/IssueNavigator.jspa", "fixfor=10000", "reset=true", "mode=hide", "sorter/order=ASC", "sorter/field=priority", "pid=10000"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "dev");
        this.assertLinkPresentWithText("HSP-10");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-10", true);
        this.assertLinkNotPresentWithText("HSP-11");
        this.assertLinkNotPresentWithText("HSP-12");
        this.assertSingleVersionPicker("New Version 5", "10000");
        this.assertVersionPicker("New Version 2", "10003");
        this.assertVersionPicker("New Version 4", "10001");
    }

    public void testFullContentViewItem1DaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.testFullContentViewItem1();
    }

    public void testFullContentViewItem1HoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.testFullContentViewItem1();
    }

    protected void goToView() {
        this.clickLink("fullContent");
    }

    public void testFullContentViewItem2() {
        this.getNavigation().issueNavigator().displayAllIssues();
        this.selectOption("status", "In Progress");
        this.submit("show");
        this.goToView();
        AbstractTestIssueNavigatorView.Item item = this.item2;
        this.verifyCommons(item);
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 4");
        this.assertTextPresentBeforeText("duplicates", "HSP-10");
        this.assertTextPresentBeforeText("HSP-10", "Big 01");
        this.assertTextPresentBeforeText("Big 01", "Resolved");
        this.assertTextPresentBeforeText("CascadingSelectField", "value 05");
        this.assertTextPresentBeforeText("ProjectPickerField", "homosapien");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        this.assertLinkPresentWithText("New Version 4");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/IssueNavigator.jspa", "fixfor=10001", "reset=true", "mode=hide", "sorter/order=ASC", "sorter/field=priority", "pid=10000"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "admin");
        this.assertLinkPresentWithText("HSP-10");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-10", true);
        this.assertLinkNotPresentWithText("HSP-11");
        this.assertLinkNotPresentWithText("HSP-12");
        this.assertSingleVersionPicker("New Version 5", "10000");
        this.assertVersionPicker("New Version 5", "10000");
    }

    public void testFullContentViewItem2DaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.testFullContentViewItem2();
    }

    public void testFullContentViewItem2HoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.testFullContentViewItem2();
    }

    public void testFullContentViewItem3() {
        this.getNavigation().issueNavigator().displayAllIssues();
        this.selectOption("status", "Resolved");
        this.submit("show");
        this.goToView();
        AbstractTestIssueNavigatorView.Item item = this.item3;
        this.verifyCommons(item);
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 4");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("duplicates", "HSP-11");
        this.assertTextPresentBeforeText("HSP-11", "Minor Bug 01");
        this.assertTextPresentBeforeText("Minor Bug 01", "In Progress");
        this.assertTextPresentBeforeText("is duplicated by", "HSP-11");
        this.assertTextPresentBeforeText("HSP-11", "Minor Bug 01");
        this.assertTextPresentBeforeText("Minor Bug 01", "In Progress");
        this.assertTextPresentBeforeText("is duplicated by", "HSP-12");
        this.assertTextPresentBeforeText("HSP-12", "Feature 00");
        this.assertTextPresentBeforeText("Feature 00", "Open");
        this.assertTextPresentBeforeText("CascadingSelectField", "value 01");
        this.assertTextPresentBeforeText("value 01", "value 013");
        this.assertTextPresentBeforeText("GroupPickerField", "jira-developers");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/admin/user/ViewGroup.jspa", "name=jira-developers"});
        this.assertLinkPresentWithText("New Version 4");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/IssueNavigator.jspa", "version=10001", "reset=true", "mode=hide", "sorter/order=ASC", "sorter/field=priority", "pid=10000"});
        this.assertLinkPresentWithText("New Version 5");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/IssueNavigator.jspa", "fixfor=10000", "reset=true", "mode=hide", "sorter/order=ASC", "sorter/field=priority", "pid=10000"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "dev");
        this.assertLinkNotPresentWithText("HSP-10");
        this.assertLinkPresentWithText("HSP-11");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-11", true);
        this.assertLinkPresentWithText("HSP-12");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-12", true);
        this.assertSingleVersionPicker("New Version 5", "10000");
        this.assertVersionPicker("New Version 2", "10003");
        this.assertVersionPicker("New Version 4", "10001");
    }

    public void testFullContentViewItem3DaysFormat() {
        this.reconfigureTimetracking("days");
        this.testFullContentViewItem3();
    }

    public void testFullContentViewItem3HoursFormat() {
        this.reconfigureTimetracking("hours");
        this.testFullContentViewItem3();
    }

    public void testFullContentViewItem1NullPriority() {
        this.restoreData("TestSearchRequestViewsAndIssueViewsWithPriorityNull.xml");
        this.clickLink("find_link");
        this.selectOption("status", "Resolved");
        this.submit("show");
        this.goToView();
        this.assertTextNotPresent("Priority");
    }

    private void assertCustomField(AbstractTestIssueNavigatorView.Item item, String title, String cfName) {
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName(cfName);
        if (customField == null) {
            this.assertTextNotPresent(title);
        } else {
            this.assertTextPresent(title);
        }
    }

    private void assertAttribute(AbstractTestIssueNavigatorView.Item item, String title, String attName) {
        String attribute = item.getAttribute(attName);
        if (attribute == null || attribute.length() == 0) {
            this.assertTextNotPresent(title);
        } else {
            this.assertTextPresent(title);
        }
    }

    private void assertProjectPickerField(AbstractTestIssueNavigatorView.Item item) {
        String title = "ProjectPickerField";
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName("ProjectPickerField");
        if (customField == null) {
            this.assertTextNotPresent("ProjectPickerField");
        } else {
            this.assertTextPresentBeforeText("ProjectPickerField", "homosapien");
            this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        }
    }

    private void assertCustomFieldValues(AbstractTestIssueNavigatorView.Item item, String title, String cfName) {
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName(cfName);
        if (customField == null) {
            this.assertTextNotPresent(title);
        } else {
            List values = customField.getValues();
            if (values != null) {
                for (AbstractTestIssueNavigatorView.CustomField.Value value : values) {
                    this.assertTextPresentBeforeText(title, value.getValue());
                }
            }
        }
    }

    private void verifyCommons(AbstractTestIssueNavigatorView.Item item) {
        this.assertTextPresent(item.getAttribute("key"));
        this.assertLinkPresentWithText(item.getAttribute("summary"));
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/" + item.getAttribute("key"), false);
        this.assertTextPresentBeforeText("Created", "Updated");
        this.assertTextPresentBeforeText("Status", item.getAttribute("status"));
        this.assertTextPresentBeforeText("Project", "homosapien");
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        this.assertTextPresentBeforeText("Type", item.getAttribute("type"));
        this.assertTextPresentBeforeText("Priority", item.getAttribute("priority"));
        this.assertTextPresentBeforeText("Reporter", item.getAttribute("reporter"));
        this.assertTextPresentBeforeText("Assignee", item.getAttribute("assignee"));
        this.assertTextPresentBeforeText("Resolution", item.getAttribute("resolution"));
        this.assertAttribute(item, "Description", "description");
        this.assertUserProfileLink(item.getAttribute("reporter"), "admin");
        if ("days".equals(this.timeFormat)) {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimateDays"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespentDays"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimateDays"));
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimateHours"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespentHours"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimateHours"));
        } else {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimate"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespent"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimate"));
        }
        this.assertComponents(item);
        this.assertComments(item);
        this.assertAttachments(item);
        this.assertCustomField(item, "DateTimeField", "DateTimeField");
        this.assertCustomFieldValues(item, "MultiCheckboxesField", "MultiCheckboxesField");
        this.assertCustomFieldValues(item, "MultiSelectField", "MultiSelectField");
        this.assertCustomFieldValues(item, "RadioButtonsField", "RadioButtonsField");
        this.assertCustomFieldValues(item, "SelectList", "SelectList");
        this.assertCustomFieldValues(item, "TextField255", "TextField255");
        this.assertCustomField(item, "DatePickerField", "DatePickerField");
        this.assertCustomFieldValues(item, "FreeTextField", "FreeTextField");
        this.assertProjectPickerField(item);
    }

    private void assertAttachments(AbstractTestIssueNavigatorView.Item item) {
        List attachments = item.getAttachments();
        if (attachments.isEmpty()) {
            this.assertTextNotPresent("Attachments");
        } else {
            for (String attachment : attachments) {
                this.assertTextPresentBeforeText("Attachments", attachment);
            }
        }
    }

    private void assertComments(AbstractTestIssueNavigatorView.Item item) {
        List comments = item.getComments();
        if (comments.isEmpty()) {
            this.assertTextNotPresent("Comments");
        } else {
            for (AbstractTestIssueNavigatorView.Comment comment : comments) {
                this.assertTextPresentBeforeText("Comments", comment.getValue());
            }
        }
    }

    private void assertComponents(AbstractTestIssueNavigatorView.Item item) {
        List components = item.getComponents();
        if (components.isEmpty()) {
            this.assertTextPresentBeforeText("Component/s", "None");
        } else {
            for (String component : components) {
                this.assertTextPresentBeforeText("Component/s", component);
            }
        }
    }

    private void assertTimeUnknownIfNotSet(String title, String attribute) {
        if (attribute == null) {
            this.assertTextPresentBeforeText(title, "Not Specified");
        } else {
            this.assertTextPresentBeforeText(title, attribute);
        }
    }

    private void assertUserProfileLink(String title, String user) {
        this.assertLinkPresentWithText(title);
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/ViewProfile.jspa", "name=" + user});
    }

    private void assertSingleVersionPicker(String title, String value) {
        this.assertCustonFieldLink(title, value, "10017");
    }

    private void assertVersionPicker(String title, String value) {
        this.assertCustonFieldLink(title, value, "10019");
    }

    private void assertCustonFieldLink(String title, String value, String customFieldId) {
        this.assertLinkPresentWithText(title);
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/IssueNavigator.jspa", "customfield_" + customFieldId + "=" + value, "reset=true", "mode=hide", "sorter/order=ASC", "sorter/field=priority", "pid=10000"});
    }

    private void assertLinkPresentWithUrl(String url, boolean exactMatch) {
        if (url != null) {
            try {
                WebLink[] links = this.getDialog().getResponse().getLinks();
                for (int i = 0; i < links.length; ++i) {
                    WebLink link = links[i];
                    String urlString = link.getURLString();
                    if (!(exactMatch ? url.equals(urlString) : urlString != null && urlString.indexOf(url) >= 0)) continue;
                    return;
                }
                TestIssueNavigatorFullContentView.fail((String)("Link '" + url + "' not found in response"));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private void assertLinkPresent(String[] urlParts) {
        if (urlParts != null) {
            try {
                WebLink[] links = this.getDialog().getResponse().getLinks();
                TestIssueNavigatorFullContentView.assertTrue((String)("Link with '" + urlParts + "' not found in response"), (boolean)this.anyLinkContainsAllParts(links, urlParts));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    private boolean anyLinkContainsAllParts(WebLink[] links, String[] urlParts) {
        boolean result = false;
        for (int i = 0; i < links.length; ++i) {
            WebLink link = links[i];
            if (!this.linkContainsAllParts(link.getURLString(), urlParts)) continue;
            return true;
        }
        return result;
    }

    private boolean linkContainsAllParts(String link, String[] urlParts) {
        boolean result = true;
        if (link != null) {
            for (int j = 0; j < urlParts.length; ++j) {
                String urlPart = urlParts[j];
                if (link.indexOf(urlPart) >= 0) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void initFieldColumnMap() {
    }

    public void testTimeTracking() throws SAXException {
        this.activateSubTasks();
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
        this.displayAllIssues();
        this.goToView();
        this.assertTextSequence(new String[]{" Remaining Estimate:", "1 day, 30 minutes", "Remaining Estimate:", "1 day", " Time Spent:", "3 hours, 20 minutes", "Time Spent:", "Not Specified", " Original Estimate:", "1 day", "Original Estimate:", "1 day"});
    }
}

