/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestIssueNavigatorFilterSummary
extends FuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueNavigatorFilterSummary.xml");
    }

    @Override
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
        super.tearDownTest();
    }

    public void testProjectInfoInSummaryPane() {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("filterlink_10000");
        this.tester.assertLinkPresentWithText("\" onclick=\"alert(123)");
        this.tester.assertLinkPresentWithText("homosapien");
        this.tester.assertLinkPresentWithText("Invisible Project");
        this.tester.assertLinkPresentWithText("monkey");
        this.navigation.logout();
        this.navigation.login("blind", "blind");
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("filterlink_10000");
        this.tester.assertLinkNotPresentWithText("\" onclick=\"alert(123)");
        this.tester.assertLinkNotPresentWithText("homosapien");
        this.tester.assertLinkNotPresentWithText("Invisible Project");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.tester.assertTextNotPresent("homosapien");
        this.tester.assertTextNotPresent("Invisible Project");
        this.tester.assertTextNotPresent("monkey");
        this.tester.assertTextNotPresent("Project (id=10000)</span>,");
        this.tester.assertTextNotPresent("Project (id=10001)</span>,");
        this.tester.assertTextNotPresent("Project (id=10010)");
        this.tester.assertTextNotPresent("JQL Query: project in (");
        this.text.assertRegexMatch(this.tester.getDialog().getResponseText(), "project in \\(.*10020.*\\)");
        this.text.assertRegexMatch(this.tester.getDialog().getResponseText(), "project in \\(.*10000.*\\)");
        this.text.assertRegexMatch(this.tester.getDialog().getResponseText(), "project in \\(.*10010.*\\)");
        this.text.assertRegexMatch(this.tester.getDialog().getResponseText(), "project in \\(.*10001.*\\)");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }
}

