/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.ISSUES})
public class TestIssueNavigatorEncoding
extends FuncTestCase {
    private static final String PROJECT_14_INCH_MONITORS = "14&quot; monitors";
    private static final String PROJECT_SCRIPT_HACK = "&lt;script&gt;alert(&quot;hack&quot;)&lt;/script&gt;";

    public void testProjectNameIsEncoded() throws Exception {
        this.administration.restoreData("TestIssueNavigatorEncoding.xml");
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.assertTextPresent("<option title=\"14&quot; monitors\" value=\"10000\">14&quot; monitors</option>");
        this.tester.assertTextPresent("<option title=\"&lt;script&gt;alert(&quot;hack&quot;)&lt;/script&gt;\" value=\"10010\">&lt;script&gt;alert(&quot;hack&quot;)&lt;/script&gt;</option>");
    }

    public void testHtmlCustomFieldValuesNotDoubleEncoded() {
        this.administration.restoreData("TestXssCustomFields.xml");
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10010");
        this.tester.assertTextPresent("Fields with HTML Values");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator.getHTML(), new String[]{"My Multi Checkbox", "<b>My Option</b>", "My Multi Select", "<b>My Option 2</b>", "My Radio Buttons", "<b>My Option 3</b>", "My Select List", "<b>My Option</b>"});
        this.text.assertTextNotPresent(pageLocator.getHTML(), "&lt;b&gt;My Option&lt;/b&gt;");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "&lt;b&gt;My Option 2&lt;/b&gt;");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "&lt;b&gt;My Option 3&lt;/b&gt;");
    }

    public void testCustomFieldValuesThatShouldBeEncoded() {
        this.administration.restoreData("TestXssCustomFields.xml");
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10020");
        this.tester.assertTextPresent("Fields that should be encoded");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator.getHTML(), new String[]{"My Free Text", "&lt;xxx&gt;freetext&lt;/xxx&gt;", "My Group", "&lt;xxx&gt;delta&lt;/xxx&gt;", "My Multi Group", "&lt;xxx&gt;gamma&lt;/xxx&gt;", "My Multi User", "&lt;xxx&gt;alpha&lt;/xxx&gt;", "My Text", "&lt;xxx&gt;smalltext&lt;/xxx&gt;", "My User", "&lt;xxx&gt;beta&lt;/xxx&gt;"});
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>freetext</xxx>");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>gamma</xxx>");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>alpha</xxx>");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>smalltext</xxx>");
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>beta</xxx>");
        this.tester.setFormElement("searchString", " ");
        this.tester.submit();
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.text.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
        this.tester.clickLinkWithText("HSP-1");
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.text.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
    }

    public void testCustomFieldLabelsEncoded() {
        this.administration.restoreData("TestIssueNavigatorCustomFieldLabelXss.xml");
        this.navigation.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10030");
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
        this.navigation.issueNavigator().displayAllIssues();
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
        this.navigation.gotoPage("/secure/ViewUserIssueColumns!default.jspa");
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
    }

    private void assertCustomFieldLabelEncoded(Locator locator) {
        this.text.assertTextPresent(locator.getHTML(), "&quot;&gt;&lt;iframe src=&quot;http://www.google.com&quot;&gt;&lt;/iframe&gt;&lt;a href=&quot;#&quot; rel=&quot;");
        this.text.assertTextNotPresent(locator.getHTML(), "\"><iframe src=\"http://www.google.com\"></iframe><a href=\"#\" rel=\"");
    }
}

