/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorColumnLinks
extends FuncTestCase {
    public void testColumnLinks() {
        this.administration.restoreData("TestIssueNavigatorColumnLinks.xml");
        this.navigation.issueNavigator().hideActionsColumn();
        this._testColumnLinksInIssueNavigator();
        this._testColumnLinksInUserIssueColumns();
    }

    public void _testColumnLinksInIssueNavigator() {
        this.log("Checking the linkage of column values in the Issue Navigator");
        this.navigation.issueNavigator().displayAllIssues();
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        for (int col = 1; col < table.getColumnCount(); ++col) {
            for (int row = 4; row <= 5; ++row) {
                WebLink[] links;
                TableCell cell = table.getTableCell(row, col);
                String cellString = "Cell (" + row + ", " + col + ")";
                if (this.shouldColumnHaveLink(col)) {
                    links = cell.getLinks();
                    TestIssueNavigatorColumnLinks.assertTrue((String)(cellString + " should have a link: " + cell.asText().trim()), (links.length > 0 ? 1 : 0) != 0);
                    for (int i = 0; i < links.length; ++i) {
                        WebLink link = links[i];
                        String valueName = link.asText();
                        String url = link.getURLString();
                        this.log(cellString + " has a link with text '" + valueName + "' and URL '" + url + "'. Following link ...");
                        this.tester.gotoPage(this.trimUrl(url));
                        this.tester.assertTextPresent(valueName);
                    }
                    continue;
                }
                links = cell.getLinks();
                TestIssueNavigatorColumnLinks.assertTrue((String)(cellString + " should not have any links: " + cell.asText().trim()), (links.length == 0 ? 1 : 0) != 0);
                this.log(cellString + " has no links. Next cell ...");
            }
        }
    }

    public void _testColumnLinksInUserIssueColumns() {
        this.log("Checking the linkage of column values in the User Issue Columns screen");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("Configure");
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        for (int col = 1; col < table.getColumnCount(); ++col) {
            for (int row = 4; row <= 5; ++row) {
                TableCell cell = table.getTableCell(row, col);
                String cellString = "Cell (" + row + ", " + col + ")";
                WebLink[] links = cell.getLinks();
                TestIssueNavigatorColumnLinks.assertTrue((String)(cellString + " should not have any links: " + cell.asText().trim()), (links.length == 0 ? 1 : 0) != 0);
                this.log(cellString + " has no links. Next cell ...");
            }
        }
    }

    private boolean shouldColumnHaveLink(int col) {
        if (col < 1 || col > 15) {
            throw new IllegalArgumentException("Specify column between 1 and 15");
        }
        return col <= 4 || col == 9 || col == 10 || col >= 12;
    }

    private String trimUrl(String url) {
        if (url.startsWith(this.getEnvironmentData().getContext())) {
            return url.substring(this.getEnvironmentData().getContext().length());
        }
        return url;
    }
}

