/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask641
extends FuncTestCase {
    public static final String ROWF_PROJECT_NAME = "readOnlyWorkflowTest";
    public static final String ROWF_PROJECT_KEY = "ROWFT";
    public static final String ROWF_ISSUE_KEY = "ROWFT-1";

    public void testUpgrade() {
        this.setupJIRAFromScratch();
        this.createProjectWithOneIssue();
        this.navigation.issue().viewIssue(ROWF_ISSUE_KEY);
        this.tester.assertLinkPresentWithText("View Workflow");
        this.administration.permissionSchemes().defaultScheme().removePermission(45, "10000");
        this.navigation.issue().viewIssue(ROWF_ISSUE_KEY);
        this.tester.assertLinkNotPresentWithText("View Workflow");
    }

    private void setupJIRAFromScratch() {
        this.administration.restoreNotSetupInstance();
        this.tester.gotoPage("secure/Setup.jspa");
        this.tester.assertTextPresent("Step 2 of 4: Application properties");
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4: Administrator account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4: Email Notification");
        this.log("Noemail");
        this.tester.submit("finish");
        this.log("Noemail");
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.disableWebSudo();
        this.navigation.login("admin");
    }

    private void createProjectWithOneIssue() {
        this.administration.project().addProject(ROWF_PROJECT_NAME, ROWF_PROJECT_KEY, "admin");
        this.navigation.browseProject(ROWF_PROJECT_KEY);
        this.navigation.issue().goToCreateIssueForm(ROWF_PROJECT_NAME, "Bug");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.setWorkingForm("issue-create");
        this.tester.setFormElement("summary", "Test Issue for ReadOnly Workflow");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit();
    }
}

