/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask552
extends FuncTestCase {
    private static final String CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR = "custom-fields";

    public void testUpgrade() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552.xml");
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.assertTextPresent("View Custom Fields");
        WebTable customFieldsTable = new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR).getTable();
        TestUpgradeTask552.assertEquals((int)3, (int)customFieldsTable.getRowCount());
        this.text.assertTextPresent(new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR), "Epic");
        this.text.assertTextPresent(new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR), "Tags");
        this.navigation.gotoAdminSection("issue_field_columns");
        this.tester.assertTextPresent("Issue Navigator Default Columns");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Labels");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 12), "Epic");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 13), "Tags");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Configure");
        this.tester.assertTextPresent("Issue Navigator Columns");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "The table below shows issue fields in order of appearance in", "your", "Issue Navigator.");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Labels");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 12), "Epic");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("filterlink_10011");
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextPresent("custom field that becomes system field");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Labels");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 12), "Tags");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("edit_filter_10011");
        this.tester.assertTextPresent("custom field that becomes system field");
        this.tester.clickLink("editfilter");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "1", "of", "1", "matching issues");
        this.tester.assertTextInElement("jqltext", "labels in (homer, marge) AND labels in (homer) AND tags not in (white)");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("edit_filter_10010");
        this.tester.assertTextPresent("custom field that remains a custom field");
        this.tester.clickLink("editfilter");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "2", "of", "2", "matching issues");
        this.tester.assertTextInElement("jqltext", "Epic in (apple, mango) and cf[10005] = blue");
        this.navigation.login("admin");
        this.navigation.gotoPage("/secure/admin/ConfigureFieldScreen.jspa?id=10000");
        this.tester.assertTextPresent("Custom LBL screen");
        TableLocator fieldTableLocator = new TableLocator(this.tester, "field_table");
        this.text.assertTextPresent(fieldTableLocator, "Epic");
        this.text.assertTextPresent(fieldTableLocator, "Labels");
        this.text.assertTextNotPresent(fieldTableLocator, "6.");
        this.navigation.gotoPage("/secure/admin/ConfigureFieldLayout!default.jspa?id=10000");
        this.tester.assertTextPresent("Req Labels Config");
        TableLocator fieldConfigTableLocator = new TableLocator(this.tester, "field_table");
        TestUpgradeTask552.assertEquals((int)20, (int)fieldConfigTableLocator.getTable().getRowCount());
        this.text.assertTextPresent(fieldConfigTableLocator, "Epic");
        this.text.assertTextPresent(fieldConfigTableLocator, "Labels");
        this.text.assertTextPresent(fieldConfigTableLocator, "Tags");
    }

    public void testUpgradeNoSystemField() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552NoSystemField.xml");
        this.navigation.gotoAdminSection("view_custom_fields");
        this.text.assertTextPresent("Epic/Theme");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent("Epic/Theme");
        this.text.assertTextSequence(new IdLocator(this.tester, "customfield_10000-val"), "This", "a", "is", "test");
    }

    public void testUpgradeSystemField() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552SystemField.xml");
        this.navigation.issue().viewIssue("UPG-2");
        this.text.assertTextPresent("Labels");
        this.text.assertTextPresent("TestLabel");
        this.text.assertTextPresent(new IdLocator(this.tester, "labels-10001-value"), "two");
    }
}

