/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestSignup
extends JIRAWebTest {
    public TestSignup(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testSignupLinkNotPresentIfJiraNotPublic() throws Exception {
        boolean enabled = true;
        this.enablePublicMode(true);
        this.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
        this.login("admin", "admin");
        enabled = false;
        this.enablePublicMode(false);
        this.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
        this.login("admin", "admin");
        enabled = true;
        this.enablePublicMode(true);
        this.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
    }

    public void testSignupLinkNotPresentIfJiraNotPublicEditIssue() throws Exception {
        this.addProject("Test", "TST", "admin");
        String issueKey = this.addIssue("Test", "TST", "Bug", "Nam lobortis; nulla et sollicitudin");
        String issueId = this.getIssueIdWithIssueKey(issueKey);
        boolean enabled = true;
        this.enablePublicMode(true);
        this.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
        this.login("admin", "admin");
        enabled = false;
        this.enablePublicMode(false);
        this.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
        this.login("admin", "admin");
        enabled = true;
        this.enablePublicMode(true);
        this.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
    }

    private void assertCommonMessageOnPage(boolean enabled, String page) {
        this.gotoPage(page);
        if (enabled) {
            this.assertTextSequence(new String[]{"Not a member?", "Sign up", "for an account."});
            this.assertTextNotPresent("to request an account.");
        } else {
            this.assertTextNotPresent("for an account");
            this.assertTextSequence(new String[]{"Not a member?", "To request an account, please contact your", "JIRA administrators"});
            this.assertLinkWithTextExists("JIRA administrators");
        }
    }

    private void assertMessageOnEditIssue(boolean enabled, String issueId) {
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        if (enabled) {
            this.assertTextPresent("You are not logged in, and do not have the permissions required to act on the selected issue as a guest.");
            this.assertTextSequence(new String[]{"Please", "login", "or", "sign up", "for an account."});
            this.assertLinkWithTextExists("sign up");
        } else {
            this.assertTextNotPresent("for an account");
        }
    }

    private void assertMessageOnLoginPage(boolean enabled) {
        this.assertCommonMessageOnPage(enabled, "/login.jsp");
    }

    private void assertMessageOnBrowseProjects(boolean enabled) {
        this.gotoPage("/secure/project/BrowseProjects.jspa");
        if (enabled) {
            this.assertTextSequence(new String[]{"To browse projects, first", "login", "or", "sign up", "for an account."});
            this.assertLinkWithTextExists("sign up");
        } else {
            this.assertTextNotPresent("for an account.");
        }
    }

    private void assertMessageOnViewProjects(boolean enabled) {
        this.gotoPage("/secure/project/ViewProjects.jspa");
        if (enabled) {
            this.assertTextSequence(new String[]{"If you", "log in", "or", "sign up", "for an account, you might be able to see more here."});
            this.assertLinkWithTextExists("sign up");
        } else {
            this.assertTextNotPresent("for an account, you might be able to see more here.");
        }
    }

    private void enablePublicMode(boolean enable) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.selectOption("mode", enable ? "Public" : "Private");
        this.submit("Update");
    }

    public void testEnableCaptcha() {
        this.toggleCaptcha(true);
        this.logout();
        this.beginAt("/captcha");
        this.beginAt("/");
        this.tester.gotoPage("login.jsp");
        this.clickLink("signup");
        this.assertFormElementPresent("captcha");
        this.setFormElement("username", "test");
        this.setFormElement("fullname", "test");
        this.setFormElement("email", "test@test.com");
        this.setFormElement("captcha", "");
        this.submit();
        this.assertTextPresent("Please enter the word as shown below");
    }

    public void testDisableCaptcha() {
        this.toggleCaptcha(false);
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.tester.gotoPage("login.jsp");
        this.clickLink("signup");
        this.assertFormElementNotPresent("captcha");
        this.setFormElement("username", "test");
        this.setFormElement("fullname", "test");
        this.setFormElement("password", "password");
        this.setFormElement("confirm", "password");
        this.setFormElement("email", "test@test.com");
        this.submit();
        this.assertTextNotPresent("You must enter the text exactly as it appears in the picture.");
        this.assertTextPresent("You have successfully signed up.");
    }

    public void testStayInTouchLink() {
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.tester.gotoPage("login.jsp");
        this.clickLink("signup");
        this.setFormElement("username", "test");
        this.setFormElement("fullname", "test");
        this.setFormElement("password", "password");
        this.setFormElement("confirm", "password");
        this.setFormElement("email", "test@test.com");
        this.submit();
        this.assertTextPresent("Stay connected with Atlassian. Subscribe to");
        this.assertLinkWithTextUrlEndsWith("blogs, newsletters, forums and more", "http://www.atlassian.com/about/connected.jsp?s_kwcid=jira-stayintouch");
    }

    private void toggleCaptcha(boolean enable) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("captcha", String.valueOf(enable));
        this.submit("Update");
    }

    public void testEmptyData() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "");
        this.tester.setFormElement("fullname", "");
        this.tester.setFormElement("email", "");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a username.");
        this.tester.assertTextPresent("You must specify a password and a confirmation password.");
        this.tester.assertTextPresent("You must specify a full name.");
        this.tester.assertTextPresent("You must specify an email address.");
    }

    public void testNoPasswordSet() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a password and a confirmation password.");
        this.tester.assertTextNotPresent("You must specify a username.");
        this.tester.assertTextNotPresent("You must specify a full name.");
        this.tester.assertTextNotPresent("You must specify an email address.");
    }

    public void testSignUpDuplicateUser() {
        this.checkSuccessUserCreate();
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("A user with that username already exists.");
    }

    public void testCreateUserSuccess() {
        this.checkSuccessUserCreate();
    }

    private void checkSuccessUserCreate() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You have successfully signed up. If you forget your password, you can have it emailed to you.");
    }

    public void testSignUpUsernameUppercase() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "User");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("The username must be all lowercase.");
    }

    public void testCreateUserInvalidEmail() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "User");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user.email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    public void testCreateUserWIthLeadingOrTrailingSpaces() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        String untrimmedUserName = "   andres  ";
        this.tester.setFormElement("username", "   andres  ");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up.");
        this.navigation.loginAttempt("   andres  ", "password");
        this.tester.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
        this.navigation.loginAttempt("   andres  ".trim(), "password");
        this.tester.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("Dashboard.jspa");
    }

    public void testCreateUserFieldsExceed255() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        String username = StringUtils.repeat((String)"abcdefgh", (int)32);
        String fullname = StringUtils.repeat((String)"ABCDEFGH", (int)32);
        String email = StringUtils.repeat((String)"x", (int)246) + "@email.com";
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", fullname);
        this.tester.setFormElement("email", email);
        this.tester.submit();
        this.assertTextPresent("The username must not exceed 255 characters in length.");
        this.assertTextPresent("The full name must not exceed 255 characters in length.");
        this.assertTextPresent("The email address must not exceed 255 characters in length.");
        this.tester.setFormElement("username", username.substring(0, 255));
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("fullname", fullname.substring(0, 255));
        this.tester.setFormElement("email", email.substring(0, 255));
        this.tester.submit();
        this.assertTextNotPresent("The username must not exceed 255 characters in length.");
        this.assertTextNotPresent("The full name must not exceed 255 characters in length.");
        this.assertTextNotPresent("The email address must not exceed 255 characters in length.");
        this.login(username.substring(0, 255), "password");
        this.assertTextPresent(fullname.substring(0, 255));
    }

    public void testCreateUserPassword() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/Signup!default.jspa");
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("To sign up for JIRA simply enter your details below.");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("confirm", "confirm");
        this.tester.submit();
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "abc");
        this.tester.setFormElement("confirm", "def");
        this.tester.submit();
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You have successfully signed up. If you forget your password, you can have it emailed to you.");
    }
}

