/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestRememberMeCookie
extends FuncTestCase {
    private static final String USER_LAGONIL = "lagonil";
    private static final String SERAPH_REMEMBERME_COOKIE = "seraph.rememberme.cookie";

    public void testRememberMeCookieWorks() {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.administration.usersAndGroups().addUser(USER_LAGONIL);
        this.navigation.logout();
        this.navigation.login(USER_LAGONIL, USER_LAGONIL, true);
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresentWithText(USER_LAGONIL);
        String seraphCookie = this.tester.getDialog().getWebClient().getCookieValue(SERAPH_REMEMBERME_COOKIE);
        TestRememberMeCookie.assertNotNull((String)"Didnt find cookie as expected", (Object)seraphCookie);
        TestRememberMeCookie.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (seraphCookie.indexOf(">") >= 0 ? 1 : 0) != 0);
        TestRememberMeCookie.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (seraphCookie.indexOf("<") >= 0 ? 1 : 0) != 0);
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkNotPresent("find_link");
        this.tester.assertLinkNotPresentWithText(USER_LAGONIL);
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getDialog().getWebClient().addCookie(SERAPH_REMEMBERME_COOKIE, seraphCookie);
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresentWithText(USER_LAGONIL);
    }
}

