/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestReleaseNotes
extends FuncTestCase {
    public void testHtmlEscaping() throws IOException {
        this.administration.restoreData("TestReleaseNotes.xml");
        this.tester.gotoPage("/ConfigureReleaseNote.jspa?projectId=10000");
        this.tester.selectOption("version", "New Version 4");
        this.tester.selectOption("styleName", "Html");
        this.tester.submit("Create");
        this.text.assertTextPresent("Release Notes - &amp;quot;homosapien&amp;quot; - Version New Version 4");
        this.text.assertTextPresent("Bugs &amp;amp; Things");
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.text.assertTextPresent("<li>[<a href='" + baseUrl + "browse/HSP-1'>HSP-1</a>] -         Chevrons - &amp;gt;&amp;gt;&amp;gt; &amp;lt;&amp;lt;&amp;lt;");
        this.text.assertTextPresent("<li>[<a href='" + baseUrl + "browse/HSP-2'>HSP-2</a>] -         Ampersands - &amp;amp; &amp;amp; &amp;amp; &amp;amp; &amp;amp;");
        this.text.assertTextPresent("<li>[<a href='" + baseUrl + "browse/HSP-3'>HSP-3</a>] -         Quotes - &amp;quot; &amp;quot; &amp;quot; &amp;#39; &amp;#39; &amp;#39;  &amp;quot; &amp;quot; &amp;quot;");
    }
}

