/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.SAXException;

@WebTest(value={Category.DEV_MODE, Category.PLATFORM_COMPATIBILITY})
public class TestPlatformCompatibility
extends RestFuncTest {
    private static final String PLATFORM_CTK_PLUGIN_KEY = "com.atlassian.refapp.ctk";
    private boolean shouldRun;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.shouldRun = this.isPlatformCtkPluginInstalled();
        if (this.shouldRun) {
            this.administration.project().addProject("tautomerism", "TTM", "admin");
            this.navigation.issue().createIssue("tautomerism", "Bug", "jira blah blah");
            this.administration.reIndex();
            this.navigation.logout();
        }
    }

    public void testCtk() throws IOException, SAXException, JSONException {
        if (this.shouldRun) {
            this.log.log("found platform-ctk plugin. run it now!!");
            WebResponse response = this.GET("/rest/functest/1.0/junit/runTests?outdir=target/runtest", (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            TestPlatformCompatibility.assertEquals((String)"application/json", (String)response.getContentType());
            TestPlatformCompatibility.assertEquals((String)"UTF-8", (String)response.getCharacterSet());
            JSONObject contents = new JSONObject(response.getText());
            TestPlatformCompatibility.assertEquals((String)("Test result:" + contents.getString("output")), (int)0, (int)Integer.parseInt(contents.getString("result")));
        } else {
            this.log.log("platform-ctk plugin not found. skipped the test");
        }
    }

    private boolean isPlatformCtkPluginInstalled() {
        this.navigation.gotoAdmin();
        return this.administration.plugins().isPluginInstalled(PLATFORM_CTK_PLUGIN_KEY);
    }
}

