/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.SystemTenantOnly;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.apache.log4j.Logger;

@SystemTenantOnly
@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SETUP})
public class TestJohnsonFiltersWhileNotSetup
extends JIRAWebTest {
    private static final Logger log = Logger.getLogger(TestJohnsonFiltersWhileNotSetup.class);

    public TestJohnsonFiltersWhileNotSetup(String name) {
        super(name);
    }

    public void test503Only() throws IOException {
        this.assert503Only("/rpc/trackback/fooobar");
        this.assert503Only("/si/whatever");
        this.assert503Only("/sr/whatever");
        this.assert503Only("/download/*");
        this.assert503Only("/plugins/servlet/*");
        this.assert503Only("/secure/attachment/blah-tricky.gif");
        this.assert503Only("/rest/some/rest");
        this.assert503Only("/rest/a");
    }

    public void testNotSetupMessage() {
        this.beginAt("/browse/ABC-123");
        WebResponse webResponse = this.getDialog().getResponse();
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)"should be a 200 response", (int)200, (int)webResponse.getResponseCode());
        this.assertTextPresent("JIRA Setup");
        this.assertTextPresent("Step 1 of 4");
    }

    private void assert503Only(String atUrl) throws IOException {
        try {
            this.beginAt(atUrl);
        }
        catch (RuntimeException re) {
            log.warn((Object)"Not able to properly assert the response code, using crude (websphere) workaround instead");
            TestJohnsonFiltersWhileNotSetup.assertTrue((re.getMessage().indexOf("IOException") != -1 ? 1 : 0) != 0);
            TestJohnsonFiltersWhileNotSetup.assertTrue((re.getMessage().indexOf("503") != -1 ? 1 : 0) != 0);
            return;
        }
        WebResponse webResponse = this.getDialog().getResponse();
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)("expected service unavailable response for url: '" + atUrl + "'"), (int)503, (int)webResponse.getResponseCode());
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)("should be no content for this url: '" + atUrl + "'"), (int)0, (int)webResponse.getText().length());
    }

    @Override
    public void setUp() {
        log.info((Object)("not running normal test setup for " + this.getName()));
        this.getTestContext().setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void tearDown() {
        log.info((Object)("not running normal test teardown for " + this.getName()));
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }
}

