/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.Iterator;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestDateRangePicker
extends JIRAWebTest {
    private static final String URL = "/secure/popups/DateRangePicker.jspa";

    public TestDateRangePicker(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testAllMissingValues() {
        Map params = EasyMap.build((Object)"formName", (Object)"", (Object)"previousFieldName", (Object)"", (Object)"nextFieldName", (Object)"", (Object)"fieldId", (Object)"");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
    }

    public void testMissingValuesAndInvalidFieldId() {
        Map params = EasyMap.build((Object)"formName", (Object)"", (Object)"previousFieldName", (Object)"", (Object)"nextFieldName", (Object)"", (Object)"fieldId", (Object)"DOESNOTEXIST");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
        params = EasyMap.build((Object)"formName", (Object)"", (Object)"previousFieldName", (Object)"", (Object)"nextFieldName", (Object)"", (Object)"fieldId", (Object)"NOSUCHTHING");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
    }

    public void testMissingValues() {
        Map params = EasyMap.build((Object)"formName", (Object)"f", (Object)"previousFieldName", (Object)"pfn", (Object)"nextFieldName", (Object)"nfn", (Object)"fieldId", (Object)"");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
        params = EasyMap.build((Object)"formName", (Object)"f", (Object)"previousFieldName", (Object)"", (Object)"nextFieldName", (Object)"nfn", (Object)"fieldId", (Object)"");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
        params = EasyMap.build((Object)"formName", (Object)"", (Object)"previousFieldName", (Object)"pfn", (Object)"nextFieldName", (Object)"nfn", (Object)"fieldId", (Object)"");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
        params = EasyMap.build((Object)"formName", (Object)"f", (Object)"previousFieldName", (Object)"pfn", (Object)"nextFieldName", (Object)"", (Object)"fieldId", (Object)"");
        this.gotoDateRangePicker(params);
        this.assertValuesOrErrorMessages(params);
    }

    public void testNoErrors() {
        Map params = EasyMap.build((Object)"formName", (Object)"f", (Object)"previousFieldName", (Object)"pfn", (Object)"nextFieldName", (Object)"nfn", (Object)"fieldId", (Object)"environment");
        this.gotoDateRangePicker(params);
        this.assertNoErrorMessages(params);
    }

    private void gotoDateRangePicker(Map params) {
        StringBuffer url = new StringBuffer();
        for (Map.Entry entry : params.entrySet()) {
            url.append("&");
            url.append(entry.getKey());
            url.append("=");
            url.append(entry.getValue());
        }
        url.replace(0, 1, "?");
        this.gotoPage(URL + url.toString());
    }

    private void assertNoErrorMessages(Map params) {
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            this.assertFieldErrorMessageNotPresent((String)i.next());
        }
    }

    private void assertValuesOrErrorMessages(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            String paramName = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            this.assertValueOrErrorMessage(paramName, paramValue);
        }
    }

    private void assertValueOrErrorMessage(String paramName, String paramValue) {
        boolean valueNotSet;
        boolean bl = valueNotSet = paramValue.length() == 0;
        if ("fieldId".equals(paramName)) {
            if (valueNotSet) {
                this.assertTextNotPresent("Invalid field! Field with ID = " + paramValue + " not found!");
            } else {
                this.assertTextPresent("Invalid field! Field with ID = " + paramValue + " not found!");
            }
        }
        if (valueNotSet) {
            this.assertFieldErrorMessagePresent(paramName);
        } else {
            this.assertFieldErrorMessageNotPresent(paramName);
        }
    }

    private void assertFieldErrorMessagePresent(String field) {
        this.assertTextPresent("Value for " + field + " field was not set!");
    }

    private void assertFieldErrorMessageNotPresent(String field) {
        this.assertTextNotPresent("Value for " + field + " field was not set!");
    }
}

