/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestDateInputValidationOnCreateIssue
extends FuncTestCase {
    private static final String ISSUE_SUMMARY_FORM_ELEMENT = "summary";
    private static final String ISSUE_DUE_DATE_FORM_ELEMENT = "duedate";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testDueDateInputValidation() {
        this._testDueDateValidationWith("00/ABC/07");
        this._testDueDateValidationWith("A/06/07");
        this._testDueDateValidationWith("30/00/07");
        this._testDueDateValidationWith("XX/XX/XX");
        this._testDueDateValidationWith("0/00/07");
        this._testDueDateValidationWith("-15/JUL/07");
        this._testDueDateValidationWith("50/JAN/07");
        this._testDueDateValidationWith("163/06/07");
        this._testDueDateValidationWith("50/JAN/06");
        this._testDueDateValidationWith("100/FEB/05");
        this._testDueDateValidationWith("32/DEC/06");
    }

    public void _testDueDateValidationWith(String dueDate) {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement(ISSUE_SUMMARY_FORM_ELEMENT, "Testing Date");
        this.tester.setFormElement(ISSUE_DUE_DATE_FORM_ELEMENT, dueDate);
        this.tester.submit("Create");
        this.text.assertTextPresent(this.locator.page(), "You did not enter a valid date");
    }
}

