/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.SETUP})
public class TestDatabaseSetup
extends FuncTestCase {
    public void testAll() {
        if (this.getEnvironmentData().getProperty("databaseType") != null) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            this._testDirectJdbcSuccessful();
            this._testDirectJdbcMissingHostname();
            this._testDirectJdbcMissingPortNumber();
            this._testDirectJdbcInvalidPort();
            this._testDirectJdbcIncorrectPort();
            this._testDirectJdbcMissingUsername();
            this._testDirectJdbcInvalidCredential();
            this.configureDirectJdbc();
        } else {
            FuncTestOut.log("Skipping TestDatabaseSetup: Internal DB configured.");
        }
    }

    @Override
    protected boolean shouldSkipSetup() {
        return true;
    }

    private void configureDirectJdbc() {
        JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.getEnvironmentData());
        this.assertions.getTextAssertions().assertTextPresent("Step 2 of 4:");
    }

    private void _testDirectJdbcSuccessful() {
        this.fillValidDirectJdbcValues();
        this.assertTestConnectionSuccessful();
    }

    private void _testDirectJdbcMissingHostname() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcHostname", "");
        this.tester.setFormElement("testingConnection", "true");
        this.tester.submit();
        this.assertions.getTextAssertions().assertTextPresent("Hostname required");
    }

    private void _testDirectJdbcMissingPortNumber() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcPort", "");
        this.tester.setFormElement("testingConnection", "true");
        this.tester.submit();
        this.assertions.getTextAssertions().assertTextPresent("Port required");
    }

    private void _testDirectJdbcInvalidPort() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcPort", "not-a-number");
        this.assertTestConnectionFailed();
    }

    private void _testDirectJdbcIncorrectPort() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcPort", "999");
        this.assertTestConnectionFailed();
    }

    private void _testDirectJdbcInvalidCredential() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcPassword", this.getEnvironmentData().getProperty("password") + "extra-text-to-invalidate-password");
        this.assertTestConnectionFailed();
    }

    private void _testDirectJdbcMissingUsername() {
        this.fillValidDirectJdbcValues();
        this.tester.setFormElement("jdbcUsername", "");
        this.tester.setFormElement("testingConnection", "true");
        this.tester.submit();
        this.assertions.getTextAssertions().assertTextPresent("Username required");
    }

    private void fillValidDirectJdbcValues() {
        this.navigation.gotoPage("/");
        this.assertions.getTextAssertions().assertTextPresent("Database Configuration");
        this.tester.checkCheckbox("databaseOption", "EXTERNAL");
        this.tester.setFormElement("databaseType", this.getEnvironmentData().getProperty("databaseType"));
        this.tester.setFormElement("jdbcHostname", this.environmentData.getProperty("db.host"));
        this.tester.setFormElement("jdbcPort", this.environmentData.getProperty("db.port"));
        this.tester.setFormElement("jdbcSid", this.environmentData.getProperty("db.instance"));
        this.tester.setFormElement("jdbcDatabase", this.environmentData.getProperty("db.instance"));
        this.tester.setFormElement("jdbcUsername", this.getEnvironmentData().getProperty("username"));
        this.tester.setFormElement("jdbcPassword", this.getEnvironmentData().getProperty("password"));
        this.tester.setFormElement("schemaName", this.getEnvironmentData().getProperty("schema-name"));
    }

    private void assertTestConnectionSuccessful() {
        this.tester.setFormElement("testingConnection", "true");
        this.tester.submit();
        this.assertions.getTextAssertions().assertTextPresent("The database connection test was successful.");
    }

    private void assertTestConnectionFailed() {
        this.tester.setFormElement("testingConnection", "true");
        this.tester.submit();
        this.assertions.getTextAssertions().assertTextPresent("Error connecting to database");
    }
}

