/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestLicenseMessages
extends FuncTestCase {
    private static final String URL_WWW_ATLASSIAN_COM_ORDER = "http://www.atlassian.com/order";
    private static final String URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL = "http://www.atlassian.com/software/jira/expiredevaluation.jsp";
    private static final String URL_MY_ATLASSIAN_COM = "http://my.atlassian.com/";
    private static final String URL_CONTACT_ATLASSIAN = "http://www.atlassian.com/contact";
    private static final List<LicenseInfo> switchableLicenses = new ArrayList<LicenseInfo>();
    private static final List<DataLicenseInfo> dataLicenses = new ArrayList<DataLicenseInfo>();
    private static final String[] NOT_EXPIRED_MESSAGES = new String[]{"JIRA support and updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period will expire in ", "If you wish to have access to support and updates, please "};
    private static final String[] EXPIRED_MESSAGES = new String[]{"JIRA support and updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period has expired.", "If you wish to have access to support and updates, please "};
    private static final String[] EXPIRED_MESSAGES_DEPRECATED = new String[]{"JIRA updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period has expired.", "If you wish to have access to support and updates, please "};
    private static final String[] NOT_EXPIRED_MESSAGES_DEPRECATED = new String[]{"JIRA updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period will expire in ", "If you wish to have access to support and updates, please "};

    private static DataLicenseInfo createDeprecatedDataLicense(String name) {
        return new DataLicenseInfo("TestLicenseMessagesNewBuildOldLicense" + name + ".xml", EXPIRED_MESSAGES_DEPRECATED, NOT_EXPIRED_MESSAGES_DEPRECATED, new LicenseInfoUrl[]{new LicenseInfoUrl("contact Atlassian", URL_CONTACT_ATLASSIAN)});
    }

    private static DataLicenseInfo createNonCommercialDataLicense(String name) {
        return new DataLicenseInfo("TestLicenseMessagesNewBuildOldLicense" + name + ".xml", EXPIRED_MESSAGES, NOT_EXPIRED_MESSAGES, new LicenseInfoUrl[]{new LicenseInfoUrl("renew your maintenance", URL_MY_ATLASSIAN_COM)});
    }

    private static DataLicenseInfo createCommercialDataLicense(String name) {
        return new DataLicenseInfo("TestLicenseMessagesNewBuildOldLicense" + name + ".xml", EXPIRED_MESSAGES, NOT_EXPIRED_MESSAGES, new LicenseInfoUrl[]{new LicenseInfoUrl("renew your maintenance", URL_WWW_ATLASSIAN_COM_ORDER)});
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testSwitchableLicenses() throws Exception {
        for (LicenseInfo licenseInfo : switchableLicenses) {
            this.log("Testing license for " + licenseInfo.description);
            this.administration.switchToLicense(licenseInfo.license, licenseInfo.description);
            this.assertLicense(licenseInfo);
            if (!licenseInfo.license.equals(LicenseKeys.V2_EVAL_EXPIRED.getLicenseString())) continue;
            this.tester.gotoPage("secure/CreateIssue!default.jspa");
            this.assertCantCreateIssues();
            this.tester.gotoPage("secure/CreateIssue.jspa?pid=10000&issuetype=1");
            this.assertCantCreateIssues();
        }
    }

    private void assertCantCreateIssues() {
        CssLocator locator = new CssLocator(this.tester, ".aui-message.error");
        this.text.assertTextPresent(locator, "You will not be able to create new issues because your JIRA evaluation period has expired, please contact your JIRA administrators.");
    }

    public void testNewBuildOldLicenses() throws Exception {
        File importDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        long now = System.currentTimeMillis();
        String timestampNow = "" + now;
        String timestampExpired = "" + (now - 31L * DateUtils.DAY_MILLIS);
        for (DataLicenseInfo info : dataLicenses) {
            this.log("Testing license with file " + info.dataFile);
            this.modifyTimestampAndRestore(importDirectory, info.dataFile, timestampExpired);
            this.navigation.gotoAdminSection("license_details");
            this.assertDataLicense(info.expiredMessages, info.urls);
            this.modifyTimestampAndRestore(importDirectory, info.dataFile, timestampNow);
            this.navigation.gotoAdminSection("license_details");
            this.assertDataLicense(info.notExpiredMessages, info.urls);
        }
    }

    private String replaceTokenWith(String s, String replacement) {
        if (s == null) {
            return null;
        }
        String token = "TIMESTAMPTOCHANGE";
        int index = s.indexOf("TIMESTAMPTOCHANGE");
        if (index < 0) {
            TestLicenseMessages.fail((String)"Replacement token 'TIMESTAMPTOCHANGE' not found");
        }
        return s.substring(0, index) + replacement + s.substring(index + "TIMESTAMPTOCHANGE".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyTimestampAndRestore(File importDirectory, String fileName, String timestamp) throws Exception {
        this.log("Modifying timestamp for backup data at " + fileName);
        File data = new File(this.getEnvironmentData().getXMLDataLocation(), fileName);
        FileReader fileReader = null;
        char[] buff = null;
        try {
            fileReader = new FileReader(data);
            int length = (int)data.length();
            buff = new char[length];
            fileReader.read(buff);
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        String xml = this.replaceTokenWith(new String(buff), timestamp);
        File newData = null;
        try {
            newData = File.createTempFile(fileName, ".xml", importDirectory);
            FileWriter of = new FileWriter(newData);
            of.write(xml);
            of.close();
            this.log("Restoring data '" + newData.getAbsolutePath() + "'");
            this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("filename", newData.getName());
            this.tester.submit();
            this.administration.waitForRestore();
            this.tester.assertTextPresent("Your project has been successfully imported");
            this.navigation.disableWebSudo();
            this.navigation.login("admin", "admin");
            this.administration.generalConfiguration().setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        }
        finally {
            if (newData != null && newData.exists()) {
                newData.delete();
            }
        }
    }

    private void assertLicense(LicenseInfo licenseInfo) {
        int i;
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator, licenseInfo.messages);
        for (i = 0; i < licenseInfo.notMessages.length; ++i) {
            String notMessage = licenseInfo.notMessages[i];
            this.text.assertTextNotPresent(pageLocator, notMessage);
        }
        for (i = 0; i < licenseInfo.urls.length; ++i) {
            LicenseInfoUrl licenseInfoUrl = licenseInfo.urls[i];
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(licenseInfoUrl.text, licenseInfoUrl.url);
        }
    }

    private void assertDataLicense(String[] messages, LicenseInfoUrl[] urls) {
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator, messages);
        for (int i = 0; i < urls.length; ++i) {
            LicenseInfoUrl licenseInfoUrl = urls[i];
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(licenseInfoUrl.text, licenseInfoUrl.url);
        }
    }

    private static LicenseInfo createSupportedLicense(String key, String description) {
        return new LicenseInfo(key, description, new String[]{"(Support and updates available until "}, new String[]{"JIRA support and updates for this license ended on ", "JIRA support and updates created after ", "are not valid for this license."}, new LicenseInfoUrl[0]);
    }

    private static LicenseInfo createUnsupportedLicense(String key, String description) {
        return new LicenseInfo(key, description, new String[]{"(Updates available until "}, new String[]{"JIRA updates for this license ended on ", "JIRA updates created after ", "are not valid for this license."}, new LicenseInfoUrl[0]);
    }

    static {
        switchableLicenses.add(new LicenseInfo(LicenseKeys.V2_EVAL_EXPIRED.getLicenseString(), "Evaluation", new String[]{"(Your evaluation has expired.)", "Your JIRA evaluation period expired on ", "You are not able to create new issues in JIRA.", "To reactivate JIRA, please "}, new String[0], new LicenseInfoUrl[]{new LicenseInfoUrl("purchase JIRA", URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL)}));
        switchableLicenses.add(new LicenseInfo(LicenseKeys.V2_COMMERCIAL.getLicenseString(), "Commercial Server", new String[]{"(Support and updates available until "}, new String[]{"JIRA support and updates for this license ended on ", "JIRA updates created after ", "are not valid for this license."}, new LicenseInfoUrl[0]));
        switchableLicenses.add(TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_COMMUNITY.getLicenseString(), "Community"));
        switchableLicenses.add(TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_DEVELOPER.getLicenseString(), "Developer"));
        switchableLicenses.add(TestLicenseMessages.createUnsupportedLicense(LicenseKeys.V2_PERSONAL.getLicenseString(), "Personal"));
        switchableLicenses.add(TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_OPEN_SOURCE.getLicenseString(), "Open Source"));
        switchableLicenses.add(TestLicenseMessages.createUnsupportedLicense(LicenseKeys.V2_DEMO.getLicenseString(), "Demonstration"));
        dataLicenses.add(TestLicenseMessages.createCommercialDataLicense("Full"));
        dataLicenses.add(TestLicenseMessages.createNonCommercialDataLicense("Community"));
        dataLicenses.add(TestLicenseMessages.createDeprecatedDataLicense("Demo"));
    }

    private static class LicenseInfoUrl {
        String text;
        String url;

        private LicenseInfoUrl(String text, String url) {
            this.text = text;
            this.url = url;
        }
    }

    private static class DataLicenseInfo {
        final String dataFile;
        final String[] expiredMessages;
        final String[] notExpiredMessages;
        final LicenseInfoUrl[] urls;

        private DataLicenseInfo(String dataFile, String[] expiredMessages, String[] notExpiredMessages, LicenseInfoUrl[] urls) {
            this.dataFile = dataFile;
            this.expiredMessages = expiredMessages;
            this.notExpiredMessages = notExpiredMessages;
            this.urls = urls;
        }
    }

    private static class LicenseInfo {
        final String license;
        final String description;
        final String[] messages;
        final String[] notMessages;
        final LicenseInfoUrl[] urls;

        private LicenseInfo(String license, String description, String[] messages, String[] notMessages, LicenseInfoUrl[] urls) {
            this.license = license;
            this.description = description;
            this.messages = messages;
            this.notMessages = notMessages;
            this.urls = urls;
        }
    }
}

