/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestLicenseFooters
extends JIRAWebTest {
    public TestLicenseFooters(String name) {
        super(name);
    }

    public void testEnterpriseCommunityLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_COMMUNITY.getLicenseString());
        this.assertTextPresentBeforeText("Powered by a free Atlassian", "community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseCommunityLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_COMMUNITY.getLicenseString());
            this.logout();
            this.assertTextPresentBeforeText("Powered by a free Atlassian", "community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseDeveloperLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_DEVELOPER.getLicenseString());
        this.assertTextPresentBeforeText("This", "site is for non-production use only.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseDeveloperLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_DEVELOPER.getLicenseString());
            this.logout();
            this.assertTextPresentBeforeText("This", "site is for non-production use only.");
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterprisePersonalLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_PERSONAL.getLicenseString());
        this.assertTextSequence(new String[]{"A", "free bug tracker", "for up to three users? Try", "JIRA Personal", "Edition."});
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        this.assertTextNotPresent("site is for non-production use only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterprisePersonalLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_PERSONAL.getLicenseString());
            this.logout();
            this.assertTextSequence(new String[]{"A", "free bug tracker", "for up to three users? Try", "JIRA Personal", "Edition."});
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
            this.assertTextNotPresent("site is for non-production use only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseOpenSourceLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_OPEN_SOURCE.getLicenseString());
        this.assertTextPresentBeforeText("Powered by a free Atlassian", "open source license for Atlassian.");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseOpenSourceLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_OPEN_SOURCE.getLicenseString());
            this.logout();
            this.assertTextPresentBeforeText("Powered by a free Atlassian", "open source license for Atlassian.");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseDemonstrationLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_DEMO.getLicenseString());
        this.assertTextPresentBeforeText("This JIRA site is for demonstration purposes only.", "bug tracking software for your team.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseDemonstrationLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_DEMO.getLicenseString());
            this.logout();
            this.assertTextPresentBeforeText("This JIRA site is for demonstration purposes only.", "bug tracking software for your team.");
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_COMMERCIAL.getLicenseString());
            this.logout();
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseEvaluationLicense() {
        this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_EVAL_EXPIRED.getLicenseString());
        this.navigation.gotoAdminSection("license_details");
        this.assertTextPresent("(Your evaluation has expired.)");
        this.navigation.gotoPage("secure/BrowseProjects.jspa");
        this.assertTextSequence(new String[]{"Powered by a free Atlassian", "JIRA evaluation license", "Please consider", "purchasing it", "today"});
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        this.assertTextNotPresent("for up to three users? Try");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseEvaluationLicenseLoggedOut() {
        try {
            this.restoreDataWithLicense("blankprojects.xml", LicenseKeys.V2_EVAL_EXPIRED.getLicenseString());
            this.logout();
            this.assertTextSequence(new String[]{"Powered by a free Atlassian", "JIRA evaluation license", "Please consider", "purchasing it", "today"});
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
            this.assertTextNotPresent("for up to three users? Try");
        }
        finally {
            this.login("admin", "admin");
        }
    }
}

