/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.jelly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.JELLY})
public class TestJellyLogin
extends FuncTestCase {
    private static final String THIS_IS_A_FIRST_COMMENT = "This is a first comment";
    private static final String BILL_PASSWORD = "bill";
    private static final String BILL_USERNAME = "bill";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestJellyLogin.xml");
    }

    public void testBillCanLoginButCantCreateACommentTagButFredCan() {
        this.assertIssueInitialState();
        this.runLoginAndAddCommentScript("bill", "bill", THIS_IS_A_FIRST_COMMENT);
        this.assertIssueInitialState();
        this.runLoginAndAddCommentScript("fred", "fred", THIS_IS_A_FIRST_COMMENT);
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new WebPageLocator(this.tester), THIS_IS_A_FIRST_COMMENT);
    }

    private void runLoginAndAddCommentScript(String userName, String password, String comment) {
        String script = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:Login username=\"" + userName + "\" password=\"" + password + "\">\n" + "     <jira:AddComment issue-key=\"HSP-1\" comment=\"" + comment + ".\"/>\n" + "  </jira:Login>" + "</JiraJelly>";
        this.administration.runJellyScript(script);
    }

    private void assertIssueInitialState() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), THIS_IS_A_FIRST_COMMENT);
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created", "2:21 PM", "Updated", "2:21 PM");
    }
}

