/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.jelly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionClient;

@WebTest(value={Category.FUNC_TEST, Category.JELLY})
public class TestJellyCreateIssue
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCreateIssue() {
        VersionClient versionClient = new VersionClient(this.environmentData);
        Version version = new Version();
        version.project("HSP").name("v1");
        Version newVersion = versionClient.create(version);
        version.project("HSP").name("v2");
        newVersion = versionClient.create(version);
        version.project("HSP").name("v3");
        newVersion = versionClient.create(version);
        version.project("HSP").name("v4");
        newVersion = versionClient.create(version);
        version.project("HSP").name("v5");
        newVersion = versionClient.create(version);
        String jellyScript = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n\n<jira:CreateIssue\nproject-key=\"HSP\"\nsummary=\"All versions\"\npriority=\"Minor\"\nversions=\"v1,v2,v3,v4,v5\"\nfixVersions=\"v1,v2,v3,v4,v5\"\nassignee=\"admin\"\nreporter=\"admin\"\ndescription=\"My test Description\"\nduedate=\"04/Jul/07 12:16 PM\"\ncreated=\"2008-05-12 13:03:33\"\nupdated=\"2008-07-11 22:40:06\"\nduplicateSummary=\"ignore\"\n/>\n\n</JiraJelly>";
        this.administration.runJellyScript(jellyScript);
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-1");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Affects Version/s:", "v1", "v2", "v3", "v4", "v5");
        this.text.assertTextSequence(locator, "Fix Version/s:", "v1", "v2", "v3", "v4", "v5");
        this.navigation.gotoAdmin();
        jellyScript = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n\n<jira:CreateIssue\nproject-key=\"HSP\"\nsummary=\"All versions\"\npriority=\"Minor\"\nversions=\"v1,v2,v4,v5\"\nfixVersions=\"v1,v2,v3,v5\"\nassignee=\"admin\"\nreporter=\"admin\"\ndescription=\"My test Description\"\nduedate=\"04/Jul/07 12:16 PM\"\ncreated=\"2008-05-12 13:03:33\"\nupdated=\"2008-07-11 22:40:06\"\nduplicateSummary=\"ignore\"\n/>\n\n</JiraJelly>";
        this.administration.runJellyScript(jellyScript);
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-2");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Affects Version/s:", "v1", "v2", "v4", "v5");
        this.text.assertTextSequence(locator, "Fix Version/s:", "v1", "v2", "v3", "v5");
    }
}

