/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
public class TestMoveIssueForEnterprise
extends JIRAWebTest {
    private static final String MOVE_CONFIRM_TABLE = "move_confirm_table";
    private static final int CHANGE_TYPE_INDEX = 0;
    private static final int PREVIOUS_VALUE_INDEX = 1;
    private static final int NEW_VALUE_INDEX = 2;
    private static final String FIELD_STATUS = "Status:";
    private static final String SPAN_TAG_END = "</span>";

    public TestMoveIssueForEnterprise(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.removeWorkflow();
    }

    @Override
    public void tearDown() {
        this.removeWorkflow();
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToNoScheme() {
        this.restoreData("TestMoveIssueWithIssueSecurityLevel.xml");
        this.gotoIssue("HSP-8");
        this.clickLink("move-issue");
        this.selectOption("pid", "test");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Move");
        this.assertTextNotPresent("Level 1");
        this.assertTextPresent("subtask 1");
        this.clickLinkWithText("subtask 1");
        this.assertTextNotPresent("Level 1");
    }

    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToSameScheme() {
        this.restoreData("TestMoveIssueWithIssueSecurityLevel.xml");
        this.gotoIssue("HSP-8");
        this.clickLink("move-issue");
        this.selectOption("pid", "SameSchemeProject");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Move");
        this.assertTextPresent("Level 1");
        this.assertTextPresent("subtask 1");
        this.clickLinkWithText("subtask 1");
        this.assertTextPresent("Level 1");
    }

    public void testMoveIssueWithSubtaskFromIssueSecuritySchemeToDifferentScheme() {
        this.restoreData("TestMoveIssueWithIssueSecurityLevel.xml");
        this.gotoIssue("HSP-8");
        this.clickLink("move-issue");
        this.selectOption("pid", "monkey");
        this.submit("Next >>");
        this.selectOption("security", "Level 2");
        this.submit("Next >>");
        this.submit("Move");
        this.assertTextPresent("Level 2");
        this.assertTextPresent("subtask 1");
        this.clickLinkWithText("subtask 1");
        this.assertTextPresent("Level 2");
    }

    public void testMoveIssueWithSubtaskFromNoSchemeToIssueSecurityScheme() {
        this.restoreData("TestMoveIssueWithIssueSecurityLevel.xml");
        this.gotoIssue("TST-1");
        this.clickLink("move-issue");
        this.selectOption("pid", "monkey");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Move");
        this.assertTextNotPresent("Level 2");
        this.assertTextPresent("subtask 2");
        this.clickLinkWithText("subtask 2");
        this.assertTextNotPresent("Level 2");
    }

    public void testMoveIssueWithSubtaskFromNoSchemeToIssueSecuritySchemeRequired() {
        this.restoreData("TestMoveIssueWithIssueSecurityLevel.xml");
        this.gotoIssue("TST-1");
        this.clickLink("move-issue");
        this.selectOption("pid", "homosapien");
        this.submit("Next >>");
        this.selectOption("security", "Level 1");
        this.submit("Next >>");
        this.submit("Move");
        this.assertTextPresent("Level 1");
        this.assertTextPresent("subtask 2");
        this.clickLinkWithText("subtask 2");
        this.assertTextPresent("Level 1");
    }

    public void testMoveIssueForEnterprise() {
        if (this.projectExists("homosapien")) {
            TestMoveIssueForEnterprise.log("Project 'homosapien' exists");
        } else {
            this.addProject("homosapien", "HSP", "admin");
        }
        if (this.projectExists("neanderthal")) {
            TestMoveIssueForEnterprise.log("Project 'neanderthal' exists");
        } else {
            this.addProject("neanderthal", "NDT", "admin");
        }
        this.moveOperationToSameProjectAndType();
        this.moveIssueWithWorkflow();
        this.moveIssueWithMultipleWorkflowInScheme();
    }

    public void moveIssueWithMultipleWorkflowInScheme() {
        TestMoveIssueForEnterprise.log("Move Operation: Moving issue to a different issueType with a different workflow that has different status.");
        this.createWorkflowWithDifferentWorkflows();
        String issueKey = this.addIssue("neanderthal", "NDT", "Bug", "test moving issue between workflows", "Minor", null, null, null, "Administrator", "test environment 1", "An issue to move between workflow statuses", null, null, null);
        this.gotoIssue(issueKey);
        this.clickLinkWithText("Resolve Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextPresent("Resolved");
        this.clickLink("move-issue");
        this.selectOption("issuetype", "Improvement");
        this.submit();
        this.assertTextPresent("Move Issue: Select Status");
        this.selectOption("beanTargetStatusId", "Approved");
        this.submit();
        this.assertTextPresent("Move Issue: Update Fields");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Move Issue: Confirm");
        this.getDialog().setWorkingForm("jiraform");
        this.confirmChangesToBeMade("Bug", "Improvement");
        this.confirmChangesToBeMade("Resolved", "Approved");
        this.confirmWorkflowMovement("Copied Workflow", "New Workflow For Testing");
        this.submit("Move");
        this.assertTextPresentBeforeText(FIELD_STATUS, "Approved");
        this.assertLinkPresentWithText("neanderthal");
        this.clickLinkWithText("Reopen Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextPresentBeforeText(FIELD_STATUS, "Open");
        this.assertLinkPresentWithText("Approve Issue");
        this.clickLinkWithText("Approve Issue");
        this.assertTextPresentBeforeText(FIELD_STATUS, "Approved");
        this.deleteIssue(issueKey);
    }

    private void confirmWorkflowMovement(String oldWorkflow, String newWorkFlow) {
        this.assertTextPresent("Move Issue: Confirm");
        this.assertTextPresentBeforeText("(" + oldWorkflow + ")" + SPAN_TAG_END, "(" + newWorkFlow + ")" + SPAN_TAG_END);
    }

    private void confirmChangesToBeMade(String oldValue, String newValue) {
        this.assertTextPresent("Move Issue: Confirm");
        this.assertTextPresentBeforeText(oldValue + SPAN_TAG_END, newValue + SPAN_TAG_END);
    }

    private void createWorkflowWithDifferentWorkflows() {
        TestMoveIssueForEnterprise.log("Creating workflow");
        this.addWorkFlowScheme("New Workflow Scheme", "Workflow scheme to test move issue");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow with default statuses");
        this.addWorkFlow("New Workflow For Testing", "this workflow has one status Open only");
        this.addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.addStep("New Workflow For Testing", "Approved", "Approved");
        this.addTransition("New Workflow For Testing", "Open", "Approve Issue", "", "Approved", null);
        this.addTransition("New Workflow For Testing", "Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.assignWorkflowScheme("New Workflow Scheme", "New Feature", "Copied Workflow");
        this.assignWorkflowScheme("New Workflow Scheme", "Task", "Copied Workflow");
        this.assignWorkflowScheme("New Workflow Scheme", "Improvement", "New Workflow For Testing");
        this.associateWorkFlowSchemeToProject("neanderthal", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "New Workflow Scheme");
    }

    public void moveOperationToSameProjectAndType() {
        TestMoveIssueForEnterprise.log("Move Operation: Test the error checking for moving an issue to the same project and issue type");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test move issue", "Trivial", null, null, null, null, "test environment 5", "test description to be moved to another project", null, null, null);
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.setFormElement("issuetype", "1");
        this.submit();
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("You must select a different project or issue type to complete a move operation.");
    }

    public void moveIssueWithWorkflow() {
        TestMoveIssueForEnterprise.log("Move Operation: Moving issue to project without the same status.");
        this.createWorkflow();
        this.performMoveIssue();
        this.removeWorkflow();
    }

    private void removeWorkflow() {
        TestMoveIssueForEnterprise.log("Removing workflow");
        if (this.projectExists("neanderthal")) {
            this.associateWorkFlowSchemeToProject("neanderthal", "Default");
        }
        this.deleteWorkFlowScheme("New Workflow Scheme");
        this.deleteWorkFlow("Copied Workflow");
        this.deleteWorkFlow("New Workflow For Testing");
    }

    private void createWorkflow() {
        TestMoveIssueForEnterprise.log("Creating workflow");
        this.addWorkFlowScheme("New Workflow Scheme", "Workflow scheme to test move issue");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow with approved status");
        this.addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.addStep("Copied Workflow", "Approved", "Approved");
        this.addTransition("Copied Workflow", "Resolved", "Approve Issue", "", "Approved", null);
        this.addTransition("Copied Workflow", "Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.addTransition("Copied Workflow", "Approved", "Close Issue", "", "Closed", null);
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.associateWorkFlowSchemeToProject("neanderthal", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "New Workflow Scheme");
    }

    private void performMoveIssue() {
        String issueKey = this.addIssue("neanderthal", "NDT", "Bug", "test moving issue between workflows", "Minor", null, null, null, "Administrator", "test environment 1", "An issue to move between workflow statuses", null, null, null);
        this.gotoIssue(issueKey);
        this.clickLinkWithText("Resolve Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextPresent("Resolved");
        this.clickLinkWithText("Approve Issue");
        this.clickLink("move-issue");
        this.selectOption("pid", "homosapien");
        this.submit();
        this.assertTextPresent("Move Issue: Select Status");
        this.selectOption("beanTargetStatusId", "Open");
        this.submit();
        this.assertTextPresent("Move Issue: Update Fields");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.checkMoveConfirmTable();
        this.getDialog().setWorkingForm("jiraform");
        this.submit("Move");
        this.assertTextPresent("Open");
        this.assertLinkPresentWithText("homosapien");
        this.deleteIssue(issueKey);
    }

    private void checkMoveConfirmTable() {
        this.assertTextPresent("Move Issue: Confirm");
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID(MOVE_CONFIRM_TABLE);
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (field.indexOf("Status") <= -1) continue;
                String previousCell = fieldTable.getCellAsText(i, 1);
                String newCell = fieldTable.getCellAsText(i, 2);
                TestMoveIssueForEnterprise.assertTrue((previousCell.indexOf("Approved") != -1 ? 1 : 0) != 0);
                TestMoveIssueForEnterprise.assertTrue((newCell.indexOf("Open") != -1 ? 1 : 0) != 0);
                return;
            }
            TestMoveIssueForEnterprise.fail((String)"Cannot find field with id 'Status'.");
        }
        catch (SAXException e) {
            TestMoveIssueForEnterprise.fail((String)"Cannot find table with id 'move_confirm_table'.");
            e.printStackTrace();
        }
    }
}

