/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.StrictTextCell;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUES, Category.MOVE_ISSUE})
public class TestMoveIssueAndRemoveFieldsEnterprise
extends JIRAWebTest {
    public TestMoveIssueAndRemoveFieldsEnterprise(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestMoveIssueAndRemoveFieldsEnterprise.xml");
    }

    public void testMoveIssueType() throws SAXException {
        this.gotoIssue("RAT-13");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        this.text.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        this.text.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("<b>Step 1 of 4</b>: Choose the project and issue type to move to ...");
        this.selectOption("issuetype", "Task");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("<b>Step 3 of 4</b>: Update the fields of the issue to relate to the new project.");
        this.assertTextPresent("Step 2 is not required.");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("Move Issue: Confirm");
        this.assertTextPresent("<b>Step 4 of 4</b>: Confirm the move with all of the details you have just configured.");
        WebTable moveConfirmTable = this.getTable("move_confirm_table");
        this.assertTableCellHasText("move_confirm_table", 0, 1, "Original Value (before move)");
        this.assertTableCellHasText("move_confirm_table", 0, 2, "New Value (after move)");
        this.assertTableCellHasText("move_confirm_table", 1, 0, "Project");
        this.assertTableCellHasText("move_confirm_table", 1, 1, "Rattus");
        this.assertTableCellHasText("move_confirm_table", 1, 2, "Rattus");
        this.assertTableHasMatchingRow(moveConfirmTable, "Type", "Bug", "Task");
        this.assertTableHasMatchingRow(moveConfirmTable, "Priority", "Minor", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Security Level", "Level KingRat", "");
        this.submit("Move");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        IdLocator locator = new IdLocator(this.tester, "assignee-val");
        this.text.assertTextPresent(locator, "Mahatma Gandhi");
        locator = new IdLocator(this.tester, "priority-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        locator = new IdLocator(this.tester, "fixfor-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        locator = new IdLocator(this.tester, "versions-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        locator = new IdLocator(this.tester, "security-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        this.tester.gotoPage("/plugins/servlet/project-config/RAT/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Hidden Treasure FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.gotoIssue("RAT-13");
        locator = new IdLocator(this.tester, "key-val");
        this.text.assertTextPresent(locator, "RAT-13");
        locator = new IdLocator(this.tester, "assignee-val");
        this.text.assertTextPresent(locator, "Mahatma Gandhi");
        locator = new IdLocator(this.tester, "priority-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        locator = new IdLocator(this.tester, "security-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.gotoIssue("RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        locator = new IdLocator(this.tester, "security-val");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((locator.getNodes().length == 0 ? 1 : 0) != 0);
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasNoImage(issueTable, 2, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 13).trim());
    }

    public void testMoveIssueTypeOnSubtask() throws SAXException {
        this.gotoIssue("RAT-14");
        this.clickLink("move-issue");
        this.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("Choose the sub-task type to move to ...");
        this.submit("Next >>");
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertTextPresent("Confirm the move with all of the details you have just configured.");
        WebTable table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Sub-task", "Limited Subtask");
        this.assertTextNotPresent("Security Level");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(table, "Priority", "Minor", "");
        this.submit("Move");
        this.assertTextPresent("RAT-14");
        this.assertTextNotPresent("Security");
        this.assertTextNotPresent("Random Shit");
        this.assertTextNotPresent("Priority");
        this.assertTextNotPresent("Fix Version");
        this.assertTextNotPresent("Affects Version");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.gotoIssue("RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(1, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    public void testMoveProject() throws SAXException {
        this.gotoIssue("RAT-13");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        this.text.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        this.text.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("<b>Step 1 of 4</b>: Choose the project and issue type to move to ...");
        this.selectOption("pid", "Porcine");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("<b>Step 3 of 4</b>: Update the fields of the issue to relate to the new project.");
        this.assertTextPresent("Step 2 is not required.");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: RAT-13");
        this.assertTextPresent("Move Issue: Confirm");
        this.assertTextPresent("<b>Step 4 of 4</b>: Confirm the move with all of the details you have just configured.");
        WebTable moveConfirmTable = this.getTable("move_confirm_table");
        this.assertTableCellHasText("move_confirm_table", 0, 1, "Original Value (before move)");
        this.assertTableCellHasText("move_confirm_table", 0, 2, "New Value (after move)");
        this.assertTableCellHasText("move_confirm_table", 1, 0, "Project");
        this.assertTableCellHasText("move_confirm_table", 1, 1, "Rattus");
        this.assertTableCellHasText("move_confirm_table", 1, 2, "Porcine");
        this.assertTableHasMatchingRow(moveConfirmTable, "Type", "Bug", "Bug");
        this.assertTableHasMatchingRow(moveConfirmTable, "Priority", "Minor", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(moveConfirmTable, "Security Level", "Level KingRat", "");
        this.submit("Move");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.tester.gotoPage("/plugins/servlet/project-config/PIG/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Bug is Limited FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.gotoIssue("PIG-15");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.gotoIssue("PIG-16");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-16");
        this.assertTextNotPresent("Security");
        this.assertTextNotPresent("Level KingRat");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 4, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 4, 1, "PIG-16");
        this.assertTableCellHasImageInContext(issueTable, 4, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(4, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(4, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(4, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 5, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 5, 1, "PIG-15");
        this.assertTableCellHasNoImage(issueTable, 5, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(5, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(5, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(5, 13).trim());
    }

    public void testBulkMoveIssueType() throws SAXException {
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 2, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, "/images/icons/priority_blocker.gif");
        this.assertTableCellHasText("issuetable", 3, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 12, "v0.9");
        this.assertTableCellHasText("issuetable", 3, 13, "v0.1");
        this.clickLink("bulkedit_all");
        this.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.checkCheckbox("bulkedit_10050", "on");
        this.checkCheckbox("bulkedit_10040", "on");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.assertTextPresent("Choose the operation you wish to perform on the selected <strong>2</strong> issue(s)");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertTextPresent("Move Issues: Select Projects and Issue Types");
        this.selectOption("10022_1_issuetype", "Task");
        this.submit("Next");
        this.assertTextPresent("Move Issues:");
        this.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Task'");
        this.submit("Next");
        this.assertTextPresent("Move Issues: Confirmation");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Task");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.submit("Next");
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasNoImage(issueTable, 2, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        this.assertTableCellHasNoImage(issueTable, 3, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 13).trim());
        this.tester.gotoPage("/plugins/servlet/project-config/RAT/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Hidden Treasure FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.displayAllIssues();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasNoImage(issueTable, 2, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        this.assertTableCellHasNoImage(issueTable, 3, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 13).trim());
    }

    public void testBulkMoveIssueTypeOnSubtask() throws SAXException {
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 2, 13, "v1.0");
        this.clickLink("bulkedit_all");
        this.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.checkCheckbox("bulkedit_10060", "on");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Move Issues: Select Projects and Issue Types");
        this.selectOption("10022_5_10022_issuetype", "Limited Subtask");
        this.submit("Next");
        this.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Limited Subtask'");
        this.submit("Next");
        this.assertTextPresent("Move Issues: Confirmation");
        this.assertTextPresent("Step 4 of 4");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTextNotPresent("Security");
        this.submit("Next");
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertTableCellHasNoText(issueTable, 1, 11);
        this.assertTableCellHasNoText(issueTable, 1, 12);
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 2, 13, "v1.0");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.displayAllIssues();
        issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasNoText(issueTable, 1, 12);
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 2, 13, "v1.0");
    }

    public void testBulkMoveProject() throws SAXException {
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasText("issuetable", 2, 2, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, 2, 5, "/images/icons/priority_minor.gif");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 2, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        this.assertTableCellHasText("issuetable", 3, 2, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, "/images/icons/priority_blocker.gif");
        this.assertTableCellHasText("issuetable", 3, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 12, "v0.9");
        this.assertTableCellHasText("issuetable", 3, 13, "v0.1");
        this.clickLink("bulkedit_all");
        this.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.checkCheckbox("bulkedit_10040", "on");
        this.checkCheckbox("bulkedit_10050", "on");
        this.submit("Next");
        this.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.assertTextPresent("Choose the operation you wish to perform on the selected <strong>2</strong> issue(s)");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertTextPresent("Move Issues: Select Projects and Issue Types");
        this.selectOption("10022_1_pid", "Porcine");
        this.submit("Next");
        this.assertTextPresent("Move Issues:");
        this.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.submit("Next");
        this.assertTextPresent("Move Issues:");
        this.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Bug'");
        this.submit("Next");
        this.assertTextPresent("Move Issues:");
        this.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Sub-task'");
        this.submit("Next");
        this.assertTextPresent("Move Issues: Confirmation");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Porcine");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Bug");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.submit("Next");
        issueTable = this.getTable("issuetable");
        int rowNum = this.findIssueRowNum(issueTable, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", rowNum, 1, "PIG-1");
        this.assertTableCellHasText("issuetable", rowNum, 2, "Uncle Matty");
        this.assertTableCellHasNoImage(issueTable, rowNum, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 13).trim());
        rowNum = this.findIssueRowNum(issueTable, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", rowNum, 1, "PIG-1");
        this.assertTableCellHasText("issuetable", rowNum, 2, "One of them is \"Fatty\"");
        this.assertTableCellHasNoImage(issueTable, rowNum, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "PIG-17");
        this.assertTableCellHasText("issuetable", 3, 2, "Get Uncle Matty a new Leg");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 13).trim());
        this.tester.gotoPage("/plugins/servlet/project-config/PIG/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Bug is Limited FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.displayAllIssues();
        issueTable = this.getTable("issuetable");
        rowNum = this.findIssueRowNum(issueTable, "Uncle Matty");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", rowNum, 1, "PIG-1");
        this.assertTableCellHasText("issuetable", rowNum, 2, "Uncle Matty");
        this.assertTableCellHasNoImage(issueTable, rowNum, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 13).trim());
        rowNum = this.findIssueRowNum(issueTable, "One of them is \"Fatty\"");
        this.assertTableCellHasImageInContext(issueTable, rowNum, 0, "/images/icons/bug.gif");
        this.assertTableCellHasText("issuetable", rowNum, 1, "PIG-1");
        this.assertTableCellHasText("issuetable", rowNum, 2, "One of them is \"Fatty\"");
        this.assertTableCellHasNoImage(issueTable, rowNum, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(rowNum, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "PIG-17");
        this.assertTableCellHasText("issuetable", 3, 2, "Get Uncle Matty a new Leg");
        this.assertTableCellHasImageInContext(issueTable, 3, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 13).trim());
        this.gotoIssue("PIG-15");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-15");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.gotoIssue("PIG-17");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "PIG-17");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
    }

    private int findIssueRowNum(WebTable issueTable, String key) {
        for (int rowNum = 0; rowNum < issueTable.getRowCount(); ++rowNum) {
            if (!key.equals(issueTable.getCellAsText(rowNum, 2).trim())) continue;
            return rowNum;
        }
        return -1;
    }

    public void testBulkMigrate_AltersIssue() throws SAXException {
        this.gotoAdmin();
        this.gotoPage("/plugins/servlet/project-config/RAT/issuetypes");
        this.clickLink("project-config-issuetype-scheme-change");
        this.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "Bugless Scheme");
        this.submit(" OK ");
        this.assertTextPresent("Issue Type Migration: Overview (Step 1 of 4)");
        this.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration: Select Issue Type (Step 2 of 4)");
        this.selectOption("issuetype", "Task");
        this.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration: Update Fields (Step 3 of 4)");
        this.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration: Confirmation (Step 4 of 4)");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Task");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Random Shit");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Security Level");
        this.submit("nextBtn");
        this.gotoPage("/plugins/servlet/project-config/RAT/issuetypes");
        this.assertions.assertNodeByIdHasText("project-config-header-name", "Rattus");
        this.assertions.assertNodeByIdHasText("project-config-issuetype-scheme-name", "Bugless Scheme");
        this.tester.gotoPage("/plugins/servlet/project-config/RAT/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Hidden Treasure FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasImageInContext(issueTable, 1, 5, "/images/icons/priority_minor.gif");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 1, 12, "v1.1");
        this.assertTableCellHasText("issuetable", 1, 13, "v1.0");
        this.assertTableCellHasImageInContext(issueTable, 2, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-13");
        this.assertTableCellHasNoImage(issueTable, 2, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(2, 13).trim());
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        this.assertTableCellHasNoImage(issueTable, 3, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 12).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 13).trim());
        this.gotoIssue("RAT-13");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-13");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.gotoIssue("RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "priority-val"), "Minor");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "v1.0");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "v1.1");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
    }

    public void testBulkMigrate_AltersSubtask() throws SAXException {
        this.gotoAdmin();
        this.gotoPage("/plugins/servlet/project-config/RAT/issuetypes");
        this.clickLink("project-config-issuetype-scheme-change");
        this.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "No Subtask Scheme");
        this.submit(" OK ");
        this.assertTextPresent("Overview (Step 1 of 4)");
        this.submit("nextBtn");
        this.assertTextPresent("Select Issue Type (Step 2 of 4)");
        this.submit("nextBtn");
        this.assertTextPresent("Update Fields (Step 3 of 4)");
        this.assertTextPresent("All field values will be retained.");
        this.submit("nextBtn");
        this.assertTextPresent("Confirmation (Step 4 of 4)");
        WebTable move_confirm_table = this.getTable("move_confirm_table");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Project", "Rattus");
        this.assertTableHasMatchingRow(move_confirm_table, "Target Issue Type", "Limited Subtask");
        WebTable removed_fields_table = this.getTable("removed_fields_table");
        this.assertTableHasMatchingRow(removed_fields_table, "Priority");
        this.assertTableHasMatchingRow(removed_fields_table, "Affects Version/s");
        this.assertTableHasMatchingRow(removed_fields_table, "Fix Version/s");
        this.assertTextNotPresent("Security Level");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"Too many rows in the removed_fields_table: Are we including Security Level?", (int)4, (int)removed_fields_table.getRowCount());
        this.submit("nextBtn");
        this.gotoPage("/plugins/servlet/project-config/RAT/issuetypes");
        this.assertions.assertNodeByIdHasText("project-config-header-name", "Rattus");
        this.assertions.assertNodeByIdHasText("project-config-issuetype-scheme-name", "No Subtask Scheme");
        this.tester.gotoPage("/plugins/servlet/project-config/RAT/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Hidden Treasure FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasNoImage(issueTable, 1, 5);
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasNoText(issueTable, 1, 12);
        this.assertTableCellHasNoText(issueTable, 1, 13);
        this.gotoIssue("RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level KingRat");
    }

    public void testConvertSubtaskToIssue() throws SAXException {
        this.gotoIssue("RAT-14");
        this.clickLink("subtask-to-issue");
        this.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.selectOption("issuetype", "Task");
        this.submit("Next >>");
        this.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Update the fields of the issue to relate to the new issue type ...");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextPresent("Confirm the conversion with all of the details you have just configured.");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Sub-task", "Task");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v1.0", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v1.1", "");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "");
        this.assertTableHasMatchingRow(table, "Priority", "Minor", "");
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.changeProjectRatToDefaultFieldConfiguration();
        this.gotoIssue("RAT-14");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-14");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/task.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasNoImage(issueTable, 1, 5);
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    public void testConvertIssueToSubtaskOfIssueWithNoSecurity() throws SAXException {
        this.gotoIssue("RAT-12");
        this.assertTextPresent("Security Level");
        this.assertTextPresent("Level KingRat");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "RAT-10");
        this.selectOption("issuetype", "Limited Subtask");
        this.submit("Next >>");
        this.assertTextPresent("Convert Issue to Sub-task: RAT-12");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Bug", "Limited Subtask");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "None");
        this.assertTableHasMatchingRow(table, "Random Shit", "asdf", "");
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.changeProjectRatToDefaultFieldConfiguration();
        this.gotoIssue("RAT-12");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(3, 12).trim().equals(""));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(3, 13).trim().equals(""));
    }

    public void testConvertIssueToSubtaskOfIssueWithSecurity() throws SAXException {
        this.gotoIssue("RAT-12");
        this.assertTextPresent("Security Level");
        this.assertTextPresent("Level KingRat");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "RAT-11");
        this.selectOption("issuetype", "Limited Subtask");
        this.submit("Next >>");
        this.assertTextPresent("Convert Issue to Sub-task: RAT-12");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        WebTable table = this.getTable("convert_confirm_table");
        this.assertTableHasMatchingRow(table, "Type", "Bug", "Limited Subtask");
        this.assertTableHasMatchingRow(table, "Security Level", "Level KingRat", "Level Mouse");
        this.assertTableHasMatchingRow(table, "Affects Version/s", "v0.1", "");
        this.assertTableHasMatchingRow(table, "Fix Version/s", "v0.9", "");
        this.assertTableHasMatchingRow(table, "Priority", "Blocker", "");
        this.assertTableHasMatchingRow(table, "Random Shit", "asdf", "");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"Too many rows in summary table - is Security level listed twice?", (int)7, (int)table.getRowCount());
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "security-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "priority-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "fixfor-val").getNodes().length == 0 ? 1 : 0) != 0);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((new IdLocator(this.tester, "versions-val").getNodes().length == 0 ? 1 : 0) != 0);
        this.assertTextNotPresent("Random Shit");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.gotoIssue("RAT-12");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "RAT-12");
        this.text.assertTextPresent(new IdLocator(this.tester, "versions-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "fixfor-val"), "None");
        this.text.assertTextPresent(new IdLocator(this.tester, "security-val"), "Level Mouse");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 3, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-12");
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)"Level Mouse", (String)issueTable.getCellAsText(3, 11).trim());
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(3, 12).trim().equals(""));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(3, 13).trim().equals(""));
    }

    public void testMoveSubtaskToNewParentWithHiddenSecurity() throws SAXException {
        this.gotoIssue("RAT-10");
        this.clickLink("move-issue");
        this.selectOption("issuetype", "Task");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Move");
        this.gotoIssue("RAT-14");
        this.assertTextPresent("RAT-14");
        this.assertTextPresent("Security Level");
        this.assertTextPresent("Level KingRat");
        this.clickLink("move-issue");
        this.assertTextPresent("Choose the operation you wish to perform");
        this.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Select a new parent issue for this subtask.");
        this.setFormElement("parentIssue", "RAT-10");
        this.submit("Change Parent");
        this.assertTextPresent("RAT-14");
        this.assertTextNotPresent("Security Level");
        this.assertTextNotPresent("Level KingRat");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/issue_subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasNoText(issueTable, 1, 11);
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals("v1.1"));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals("v1.0"));
    }

    public void testMoveSubtaskWithHiddenSecurityToNewParent() throws SAXException {
        this.gotoIssue("RAT-14");
        this.clickLink("move-issue");
        this.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Choose the sub-task type to move to");
        this.submit("Next >>");
        this.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.submit("Next >>");
        this.assertTextPresent("Confirm the move with all of the details you have just configured.");
        this.submit("Move");
        this.clickLink("move-issue");
        this.assertTextPresent("Choose the operation you wish to perform");
        this.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Select a new parent issue for this subtask.");
        this.setFormElement("parentIssue", "RAT-11");
        this.submit("Change Parent");
        this.assertTextPresent("RAT-14");
        this.assertTextNotPresent("Security Level");
        this.assertTextNotPresent("Level Mouse");
        this.assertTextNotPresent("Level KingRat");
        this.changeProjectRatToDefaultFieldConfiguration();
        this.gotoIssue("RAT-14");
        this.assertTextPresent("RAT-14");
        this.assertTextPresent("Security Level");
        this.assertTextPresent("Level Mouse");
        this.displayAllIssues();
        WebTable issueTable = this.getTable("issuetable");
        this.assertTableCellHasImageInContext(issueTable, 1, 0, "/images/icons/subtask.gif");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-14");
        this.assertTableCellHasText("issueTable", 1, 11, "Level Mouse");
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 12).trim().equals(""));
        TestMoveIssueAndRemoveFieldsEnterprise.assertTrue((boolean)issueTable.getCellAsText(1, 13).trim().equals(""));
    }

    private void assertTableCellHasNoText(WebTable webTable, int row, int column) {
        String actual = webTable.getCellAsText(row, column).trim();
        TestMoveIssueAndRemoveFieldsEnterprise.assertEquals((String)("Table cell at [" + row + ", " + column + "] was expected to have no text, but was '" + actual + "'"), (String)"", (String)actual);
    }

    private void changeProjectRatToDefaultFieldConfiguration() {
        this.tester.gotoPage("/plugins/servlet/project-config/RAT/fields");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "Hidden Treasure FC Scheme");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
        this.assertions.assertNodeByIdHasText("project-config-fields-scheme-name", "System Default Field Configuration");
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1) {
        this.assertTableHasMatchingRow(webtable, new Object[]{new StrictTextCell(col1)});
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1, String col2) {
        this.assertTableHasMatchingRow(webtable, new Object[]{new StrictTextCell(col1), new StrictTextCell(col2)});
    }

    private void assertTableHasMatchingRow(WebTable webtable, String col1, String col2, String col3) {
        this.assertTableHasMatchingRow(webtable, new Object[]{new StrictTextCell(col1), new StrictTextCell(col2), new StrictTextCell(col3)});
    }

    protected void assertTableCellHasImageInContext(WebTable table, int row, int col, String path) {
        String fullPath = new LocalTestEnvironmentData().getContext() + path;
        this.assertTableCellHasImage(table, row, col, fullPath);
    }

    private WebTable getTable(String tableID) throws SAXException {
        return this.getDialog().getResponse().getTableWithID(tableID);
    }
}

