/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.history;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestRecentIssueHistory
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testVisitedIssues() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        this.assertHistoryhasTheseIssues(new String[0]);
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1, HSP_3, HSP_2});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1, HSP_3});
    }

    public void testVisitedIssuesForNotLoggedIn() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/AddPermission.jspa?permissions=10&schemeId=0&type=group"));
        this.assertHistoryhasTheseIssues(new String[0]);
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        this.navigation.logout();
        this.assertHistoryhasTheseIssues(new String[0]);
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        this.navigation.login("admin");
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1, HSP_3});
        this.navigation.logout();
        this.assertHistoryhasTheseIssues(new String[0]);
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        issueNavigation.viewIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        issueNavigation.viewIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1, HSP_2});
        this.navigation.login("admin");
        issueNavigation.viewIssue(HSP_3);
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_1, HSP_2});
    }

    public void testDeletedIssuesChangesHistory() throws Exception {
        IssueNavigation issueNavigation = this.navigation.issue();
        String HSP_1 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-1|");
        String HSP_2 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-2|");
        String HSP_3 = issueNavigation.createIssue("homosapien", null, "summary of |HSP-3|");
        this.assertHistoryhasTheseIssues(new String[]{HSP_3, HSP_2, HSP_1});
        this.deleteIssue(HSP_3);
        this.assertHistoryhasTheseIssues(new String[]{HSP_2, HSP_1});
        this.deleteIssue(HSP_2);
        this.assertHistoryhasTheseIssues(new String[]{HSP_1});
        this.deleteIssue(HSP_1);
        this.assertHistoryhasTheseIssues(new String[0]);
    }

    private void deleteIssue(String issueKey) {
        this.tester.setWorkingForm("quicksearch");
        this.tester.setFormElement("searchString", issueKey);
        this.tester.submit("quicksearch");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
    }

    private void assertHistoryhasTheseIssues(String[] issueKeys) {
        this.tester.gotoPage("secure/RecentIssueHistory.jspa?json=true&decorator=none");
        String webPageText = this.tester.getDialog().getResponseText();
        if (issueKeys.length == 0) {
            this.text.assertTextSequence(webPageText, new String[]{"[", "]"});
        } else {
            this.text.assertTextSequence(webPageText, issueKeys);
        }
        this.tester.gotoPage("secure/RecentIssueHistory.jspa");
        if (issueKeys.length == 0) {
            this.text.assertTextPresent(new WebPageLocator(this.tester), "No issues in your history");
        } else {
            TableLocator tableLocator = new TableLocator(this.tester, "recent_history_list");
            int rowCount = tableLocator.getTable().getRowCount();
            int colCount = tableLocator.getTable().getColumnCount();
            TestRecentIssueHistory.assertEquals((int)2, (int)colCount);
            for (int i = 0; i < issueKeys.length; ++i) {
                String issueKey = issueKeys[i];
                TableCellLocator cellLocator = new TableCellLocator(this.tester, "recent_history_list", i, 0);
                TestRecentIssueHistory.assertEquals((String)issueKey, (String)cellLocator.getText());
            }
        }
    }
}

