/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestAssignUserProgress
extends FuncTestCase {
    public static final String TEST_SUMMARY = "testing progress inconsistency";
    public static final String IN_PROGRESS = "In Progress";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testChangeProgressWithAssign() {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.administration.project().addProject("homosapien", "HSP", "admin");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", TEST_SUMMARY);
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Start Progress");
        this.navigation.issue().assignIssue(key, TEST_SUMMARY, "Bob The Builder");
        this.text.assertTextPresent(this.locator.page(), IN_PROGRESS);
    }

    public void testChangeProgressWithEdit() {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.administration.project().addProject("homosapien", "HSP", "admin");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", TEST_SUMMARY);
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Start Progress");
        this.tester.clickLink("editIssue");
        this.tester.selectOption("assignee", "Bob The Builder");
        this.tester.submit("Update");
        this.text.assertTextPresent(this.locator.page(), IN_PROGRESS);
    }
}

