/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestAssignToCurrentUserFunction
extends JIRAWebTest {
    public TestAssignToCurrentUserFunction(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestAssignToCurrentUserFunction.xml");
    }

    public void testAssignToCurrentUserWithNoAssignIssuePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_13_jira-developers");
        this.submit("Delete");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextSequence(new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }

    public void testAssignToCurrentUserWithNoAssignableUserPermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_17_jira-developers");
        this.submit("Delete");
        this.clickLink("del_perm_17_jira-users");
        this.submit("Delete");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
    }

    public void testAssignToCurrentUser() {
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextSequence(new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }
}

