/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestAssignIssue
extends FuncTestCase {
    private String issueKey;
    private String issueKey2 = "TST-1";
    private String issueId;
    public static final String ADMIN_SELECTED_OPTION = " value=\"admin\">";
    private static final String SEPARATOR = "---------------";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        if (this.administration.project().projectExists("homosapien")) {
            this.administration.project().deleteProject("homosapien");
        }
        this.administration.project().addProject("homosapien", "HSP", "admin");
        this.issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "This is a test issue");
        this.navigation.issue().assignIssue(this.issueKey, "", "Administrator");
        this.navigation.issue().setEnvironment(this.issueKey, "test environment");
        this.navigation.issue().setDescription(this.issueKey, "description for this is a test issue");
        this.issueId = this.navigation.issue().getId(this.issueKey);
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
    }

    @Override
    protected void tearDownTest() {
        if (this.administration.usersAndGroups().userExists("bob")) {
            this.administration.generalConfiguration().setAllowUnassignedIssues(false);
            this.administration.usersAndGroups().deleteUser("bob");
            this.navigation.issue().deleteIssue(this.issueKey);
            this.administration.project().deleteProject("homosapien");
        }
        super.tearDownTest();
    }

    public void testAssignIssue() {
        this._testUnassignedNotAvailable();
        this._testUserUnassign();
        this._testUserAssign();
        this._testUnassignUnassignedIssueError();
        this._testAlreadyAssignedError();
        this._testPermissionError();
        this._testReporterInList();
        this._testAssignWithComment();
        this._testDuplicateNamesInList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testUnassignedNotAvailable() {
        try {
            this.administration.generalConfiguration().setAllowUnassignedIssues(false);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("assign-issue");
            this.tester.assertRadioOptionNotPresent("assignee", "");
        }
        finally {
            this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        }
    }

    public void _testAssignWithComment() {
        this.administration.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.navigation.login("admin", "admin");
        this.navigation.issue().unassignIssue(this.issueKey2, "comment viewable by Administrators", "Administrators");
        this.navigation.issue().assignIssue(this.issueKey2, "Administrator", "comment viewable by jira-administrators", "jira-administrators");
        this.navigation.issue().unassignIssue(this.issueKey2, "comment viewable by Users", "Users");
        this.navigation.issue().assignIssue(this.issueKey2, "Administrator", "comment viewable by jira-users", "jira-users");
        this.navigation.issue().unassignIssue(this.issueKey2, "comment viewable by Developers", "Developers");
        this.navigation.issue().assignIssue(this.issueKey2, "Administrator", "comment viewable by jira-developers", "jira-developers");
        ArrayList userComments = Lists.newArrayList((Object[])new String[]{"comment viewable by Users", "comment viewable by jira-users"});
        ArrayList developerComments = Lists.newArrayList((Object[])new String[]{"comment viewable by Developers", "comment viewable by jira-developers"});
        ArrayList adminComments = Lists.newArrayList((Object[])new String[]{"comment viewable by Administrators", "comment viewable by jira-administrators"});
        this.assertions.comments(Iterables.concat((Iterable)userComments, (Iterable)developerComments, (Iterable)adminComments)).areVisibleTo("admin", this.issueKey2);
        this.assertions.comments(userComments).areVisibleTo("fred", this.issueKey2);
        this.assertions.comments(Iterables.concat((Iterable)developerComments, (Iterable)adminComments)).areNotVisibleTo("fred", this.issueKey2);
        this.assertions.comments(Iterables.concat((Iterable)userComments, (Iterable)developerComments)).areVisibleTo("devman", this.issueKey2);
        this.assertions.comments(adminComments).areNotVisibleTo("devman", this.issueKey2);
        this.assertions.comments(Iterables.concat((Iterable)userComments, (Iterable)adminComments)).areVisibleTo("onlyadmin", this.issueKey2);
        this.assertions.comments(developerComments).areNotVisibleTo("onlyadmin", this.issueKey2);
    }

    public void _testUserUnassign() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.clickButton("assign-issue-submit");
        this.tester.assertTextPresent("Unassigned");
    }

    public void _testUserAssign() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Administrator");
        this.tester.clickButton("assign-issue-submit");
        this.tester.assertTextNotPresent("Unassigned");
        this.tester.assertTextPresent("secure/ViewProfile.jspa?name=admin\">Administrator</a>");
    }

    public void _testUnassignUnassignedIssueError() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.clickButton("assign-issue-submit");
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.clickButton("assign-issue-submit");
        this.tester.assertTextPresent("Issue already unassigned.");
    }

    public void _testAlreadyAssignedError() {
        this._testUserAssign();
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", "Administrator");
        this.tester.clickButton("assign-issue-submit");
        this.tester.assertTextPresent("Issue already assigned to Administrator (admin).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testPermissionError() {
        try {
            this.navigation.logout();
            this.navigation.login("bob", "bob");
            this.tester.gotoPage("/secure/AssignIssue!default.jspa?id=" + this.issueId);
            this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.tester.assertButtonNotPresent("assign-issue-submit");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    public void _testReporterInList() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.setWorkingForm("assign-issue");
        this.text.assertTextSequence(this.locator.id("assignee").getHTML(), new String[]{ADMIN_SELECTED_OPTION});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDuplicateNamesInList() {
        this.administration.restoreData("TestAssigneeDuplicateNames.xml");
        try {
            this.navigation.issue().gotoIssue(this.issueKey2);
            this.tester.clickLink("editIssue");
            this.tester.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Administrator", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
            this.tester.setFormElement("reporter", "devman");
            this.tester.submit("Update");
            this.tester.clickLink("editIssue");
            this.tester.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Administrator", "Mr Dev Man (devman)", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
            this.tester.setFormElement("reporter", "devman2");
            this.tester.submit("Update");
            this.tester.clickLink("editIssue");
            this.tester.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Administrator", "Mr Dev Man (devman2)", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
        }
        finally {
            this.administration.restoreData("TestBlankInstancePlusAFewUsers.xml");
        }
    }
}

