/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestXmlIssueViewErrors
extends JIRAWebTest {
    private static final String SAMPLE_PATH_MESSAGE_1 = "Invalid path format.";
    private static final String SAMPLE_PATH_MESSAGE_2 = "Path should be of format";
    private static final String SAMPLE_PATH_MESSAGE_3 = "/si/jira.issueviews:xml/JRA-10/JRA-10.xml";
    private static final String BAD_PLUGIN_MESSAGE = "java.lang.IllegalArgumentException: Invalid complete key specified: unknownplugin";

    public TestXmlIssueViewErrors(String name) {
        super(name);
    }

    @Override
    protected void setUpHttpUnitOptions() {
        TestXmlIssueViewErrors.log("not running normal test setup for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void tearDown() {
        TestXmlIssueViewErrors.log("not running normal test teardown for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    public void testMalformedUrls() throws Exception {
        this.assert500SamplePathMessage("/si");
        this.assert500SamplePathMessage("/si/");
        this.assert500SamplePathMessage("/si/unknownplugin");
        this.assert500SamplePathMessage("/si/unknownplugin/");
        this.assert500SamplePathMessage("/si/unknownplugin/blah");
        this.assert500BadPlugin("/si/unknownplugin/blah/");
        this.assert404BadKey("/si/jira.issueviews:issue-xml/badkey/");
    }

    private void assert404BadKey(String url) {
        this.assertResponseCode(url, 404);
        this.assertTextPresent("Could not find issue with issue key badkey");
    }

    private void assert500SamplePathMessage(String url) {
        this.assertResponseCode(url, 500);
        this.assertTextSequence(new String[]{"System Error", "Cause:", SAMPLE_PATH_MESSAGE_1, SAMPLE_PATH_MESSAGE_2, SAMPLE_PATH_MESSAGE_3});
    }

    private void assert500BadPlugin(String url) {
        this.assertResponseCode(url, 500);
        this.assertTextSequence(new String[]{"System Error", "Cause:", BAD_PLUGIN_MESSAGE});
    }

    private void assertResponseCode(String url, int code) {
        this.beginAt(url);
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestXmlIssueViewErrors.assertEquals((int)code, (int)webResponse.getResponseCode());
    }
}

